/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.blocks.signals.ISignalBlockTile;
import mods.railcraft.common.blocks.signals.ItemSignalBlockSurveyor;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.signals.SignalBlock;
import mods.railcraft.common.blocks.signals.SignalBlockRelay;
import mods.railcraft.common.blocks.signals.TileBoxActionManager;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.ForgeDirection;

public class TileBoxBlockRelay
extends TileBoxActionManager
implements IControllerTile,
ISignalBlockTile,
IAspectActionManager,
IGuiReturnHandler,
IAspectProvider {
    private boolean prevBlinkState;
    private final SimpleSignalController controller = new SimpleSignalController(this.func_70303_b(), this);
    private final SignalBlock signalBlock = new SignalBlockRelay(this);
    private int update = MiscTools.getRand().nextInt();

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_BLOCK_RELAY;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null && (current.func_77973_b() instanceof ItemSignalTuner || current.func_77973_b() instanceof ItemSignalBlockSurveyor)) {
            return super.blockActivated(side, player);
        }
        if (Game.isHost(this.field_70331_k)) {
            GuiHandler.openGui(EnumGui.BOX_RELAY, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        ++this.update;
        if (Game.isNotHost(this.field_70331_k)) {
            this.controller.tickClient();
            this.signalBlock.tickClient();
            if (this.update % 4 == 0 && this.controller.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.field_70331_k.func_72936_c(EnumSkyBlock.Block, this.getX(), this.getY(), this.getZ());
                this.markBlockForUpdate();
            }
            return;
        }
        this.controller.tickServer();
        this.signalBlock.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else {
            this.controller.setAspect(this.signalBlock.getSignalAspect());
        }
        if (prevAspect != this.controller.getAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    private void updateNeighbors() {
        int blockID = this.getBlockId();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, blockID);
        for (int side = 2; side < 6; ++side) {
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            TileEntity tile = this.tileCache.getTileOnSide(forgeSide);
            if (!(tile instanceof TileBoxBase)) continue;
            TileBoxBase box = (TileBoxBase)tile;
            box.onNeighborStateChange(this);
        }
    }

    @Override
    public int getPowerOutput(int side) {
        TileEntity tile = MiscTools.getBlockTileEntityOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return 0;
        }
        return this.isEmitingRedstone() ? 15 : 0;
    }

    @Override
    public boolean isEmitingRedstone() {
        return this.doesActionOnAspect(this.getBoxSignalAspect());
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.signalBlock.writeToNBT(data);
        this.controller.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.signalBlock.readFromNBT(data);
        this.controller.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.controller.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        super.readGuiData(data, sender);
        this.updateNeighbors();
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }

    @Override
    public SignalBlock getSignalBlock() {
        return this.signalBlock;
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        super.doActionOnAspect(aspect, trigger);
        this.updateNeighbors();
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.controller.getAspect();
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }

    @Override
    public SignalAspect getTriggerAspect() {
        return this.getBoxSignalAspect();
    }
}

