/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.signals.ISignalBlockTile;
import mods.railcraft.common.blocks.signals.Signals;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.BlockRail;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class SignalBlock
extends AbstractPair {
    Map trackCache = new HashMap();
    Set waitingForRetest = new HashSet();
    private WorldCoordinate trackLocation;
    private int update = rand.nextInt();

    public SignalBlock(RailcraftTileEntity tile, int numPairs) {
        super(tile.func_70303_b(), tile, numPairs);
    }

    public SignalBlock getSignalAt(WorldCoordinate coord) {
        TileEntity recv = this.getPairAt(coord);
        if (recv != null) {
            return ((ISignalBlockTile)recv).getSignalBlock();
        }
        return null;
    }

    public abstract SignalAspect getSignalAspect();

    private void printDebug(String msg, Object ... args) {
        if (RailcraftConfig.printSignalDebug()) {
            Game.log(Level.FINEST, msg, args);
        }
    }

    public void clearSignalBlockPairing(WorldCoordinate other, String reason, Object ... args) {
        this.printDebug(reason, args);
        if (other == null) {
            this.clearPairings();
        } else {
            this.clearPairing(other);
        }
    }

    @Override
    public boolean isValidPair(TileEntity tile) {
        boolean isValid = false;
        if (tile instanceof ISignalBlockTile) {
            SignalBlock block = ((ISignalBlockTile)tile).getSignalBlock();
            isValid = block.isPairedWith(this.getCoords());
        }
        if (!isValid) {
            if (tile != null) {
                this.printDebug("Signal Block dropped because pair was no longer paired or was not a valid Signal [{0}, {1}, {2}]", tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
            } else {
                this.printDebug("Signal Block dropped because pair was no longer paired or was not a valid Signal [null]", new Object[0]);
            }
        }
        return isValid;
    }

    public boolean createSignalBlock(SignalBlock other) {
        this.locateTrack();
        other.locateTrack();
        WorldCoordinate tA = this.getTrackLocation();
        WorldCoordinate tB = other.getTrackLocation();
        if (tA == null || tB == null) {
            return false;
        }
        if (!TrackTools.areTracksConnectedAlongAxis(this.tile.field_70331_k, tA.x, tA.y, tA.z, tB.x, tB.y, tB.z)) {
            return false;
        }
        this.addPairing(other.getCoords());
        other.addPairing(this.getCoords());
        this.endPairing();
        other.endPairing();
        return true;
    }

    @Deprecated
    public void registerLegacyBlock(int x, int y, int z) {
        this.pairings.add(new WorldCoordinate(0, x, y, z));
    }

    protected abstract void updateSignalAspect();

    protected abstract SignalAspect getSignalAspectForPair(WorldCoordinate var1);

    protected SignalAspect determineAspect(WorldCoordinate otherCoord) {
        if (this.isWaitingForRetest() || this.isBeingPaired()) {
            return SignalAspect.BLINK_YELLOW;
        }
        if (!this.isPaired()) {
            return SignalAspect.BLINK_RED;
        }
        SignalAspect otherAspect = SignalAspect.GREEN;
        SignalBlock other = this.getSignalAt(otherCoord);
        if (other != null) {
            otherAspect = other.getSignalAspectForPair(this.getCoords());
        }
        SignalAspect myAspect = this.determineMyAspect(otherCoord);
        return SignalAspect.mostRestrictive(myAspect, otherAspect);
    }

    private SignalAspect determineMyAspect(WorldCoordinate otherCoord) {
        WorldCoordinate myTrack = this.getTrackLocation();
        if (myTrack == null) {
            return SignalAspect.RED;
        }
        WorldCoordinate otherTrack = this.getOtherTrackLocation(otherCoord);
        if (otherTrack == null) {
            return SignalAspect.YELLOW;
        }
        int x1 = Math.min(myTrack.x, otherTrack.x);
        int y1 = Math.min(myTrack.y, otherTrack.y);
        int z1 = Math.min(myTrack.z, otherTrack.z);
        int x2 = Math.max(myTrack.x, otherTrack.x) + 1;
        int y2 = Math.max(myTrack.y, otherTrack.y) + 1;
        int z2 = Math.max(myTrack.z, otherTrack.z) + 1;
        boolean zAxis = Math.abs(myTrack.x - otherTrack.x) < Math.abs(myTrack.z - otherTrack.z);
        int xOffset = otherTrack.x > myTrack.x ? -3 : 3;
        int zOffset = otherTrack.z > myTrack.z ? -3 : 3;
        List carts = CartTools.getMinecartsIn(this.tile.field_70331_k, x1, y1, z1, x2, y2, z2);
        SignalAspect newAspect = SignalAspect.GREEN;
        for (EntityMinecart cart : carts) {
            int cartX = MathHelper.func_76128_c((double)cart.field_70165_t);
            int cartZ = MathHelper.func_76128_c((double)cart.field_70161_v);
            if (Math.abs(cart.field_70159_w) < 0.08 && Math.abs(cart.field_70179_y) < 0.08) {
                return SignalAspect.RED;
            }
            if (zAxis) {
                if (cartZ > myTrack.z + zOffset && cart.field_70179_y < 0.0) {
                    return SignalAspect.RED;
                }
                if (cartZ < myTrack.z + zOffset && cart.field_70179_y > 0.0) {
                    return SignalAspect.RED;
                }
                newAspect = SignalAspect.YELLOW;
                continue;
            }
            if (cartX > myTrack.x + xOffset && cart.field_70159_w < 0.0) {
                return SignalAspect.RED;
            }
            if (cartX < myTrack.x + xOffset && cart.field_70159_w > 0.0) {
                return SignalAspect.RED;
            }
            newAspect = SignalAspect.YELLOW;
        }
        return newAspect;
    }

    protected WorldCoordinate getOtherTrackLocation(WorldCoordinate otherCoord) {
        SignalBlock other = this.getSignalAt(otherCoord);
        if (other != null) {
            WorldCoordinate track = other.getTrackLocation();
            this.trackCache.put(otherCoord, track);
            return track;
        }
        return (WorldCoordinate)this.trackCache.get(otherCoord);
    }

    private boolean isSignalBlockValid(WorldCoordinate other) {
        if (other == null) {
            return true;
        }
        if (this.getSignalAt(other) == null) {
            return true;
        }
        WorldCoordinate tA = this.getTrackLocation();
        WorldCoordinate tB = this.getOtherTrackLocation(other);
        if (tA == null || tB == null) {
            return false;
        }
        return TrackTools.areTracksConnectedAlongAxis(this.tile.field_70331_k, tA.x, tA.y, tA.z, tB.x, tB.y, tB.z);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        ++this.update;
        if (this.update % Signals.getSignalUpdateInterval() == 0) {
            this.updateSignalAspect();
        }
        if (this.update % 2048 == 0) {
            Status trackStatus = this.getTrackStatus();
            switch (trackStatus) {
                case INVALID: {
                    this.clearSignalBlockPairing(null, "Signal Block dropped because no track was found near Signal. [{0}, {1}, {2}]", this.tile.field_70329_l, this.tile.field_70330_m, this.tile.field_70327_n);
                    break;
                }
                case VALID: {
                    for (WorldCoordinate otherCoord : this.waitingForRetest) {
                        if (this.isSignalBlockValid(otherCoord)) continue;
                        this.clearSignalBlockPairing(otherCoord, "Signal Block dropped because track between Signals was invalid. [{0}, {1}, {2}]", this.tile.field_70329_l, this.tile.field_70330_m, this.tile.field_70327_n);
                    }
                    this.waitingForRetest.clear();
                    for (WorldCoordinate otherCoord : this.pairings) {
                        if (this.isSignalBlockValid(otherCoord)) continue;
                        this.waitingForRetest.add(otherCoord);
                    }
                    break;
                }
            }
        }
    }

    public boolean isWaitingForRetest() {
        return !this.waitingForRetest.isEmpty();
    }

    @Override
    protected String getTagName() {
        return "SignalBlock";
    }

    public WorldCoordinate getTrackLocation() {
        if (this.trackLocation == null) {
            this.locateTrack();
        }
        return this.trackLocation;
    }

    private Status getTrackStatus() {
        if (this.trackLocation == null) {
            return this.locateTrack();
        }
        if (!this.tile.field_70331_k.func_72899_e(this.trackLocation.x, this.trackLocation.y, this.trackLocation.z)) {
            return Status.UNKNOWN;
        }
        if (!BlockRail.func_72180_d_((World)this.tile.field_70331_k, (int)this.trackLocation.x, (int)this.trackLocation.y, (int)this.trackLocation.z)) {
            this.trackLocation = null;
            return Status.INVALID;
        }
        return Status.VALID;
    }

    private Status locateTrack() {
        int x = this.tile.field_70329_l;
        int y = this.tile.field_70330_m;
        int z = this.tile.field_70327_n;
        Status status = this.testForTrack(x, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x - 1, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x + 1, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z - 1);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z + 1);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x - 2, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x + 2, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z - 2);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z + 2);
        if (status != Status.INVALID) {
            return status;
        }
        return Status.INVALID;
    }

    private Status testForTrack(int x, int y, int z) {
        for (int jj = -2; jj < 4; ++jj) {
            if (!this.tile.field_70331_k.func_72899_e(x, y - jj, z)) {
                return Status.UNKNOWN;
            }
            if (!BlockRail.func_72180_d_((World)this.tile.field_70331_k, (int)x, (int)(y - jj), (int)z)) continue;
            this.trackLocation = new WorldCoordinate(this.tile.field_70331_k.field_73011_w.field_76574_g, x, y - jj, z);
            return Status.VALID;
        }
        return Status.INVALID;
    }

    public static enum Status {
        VALID,
        INVALID,
        UNKNOWN;

    }
}

