/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IPaintedCart;
import mods.railcraft.api.carts.IRefuelableCart;
import mods.railcraft.api.carts.IRoutableCart;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.EnumChatFormatting;

public class RoutingLogic {
    private Deque conditions;
    private RoutingLogicException error;

    public static RoutingLogic buildLogic(LinkedList data) {
        return new RoutingLogic(data);
    }

    private RoutingLogic(LinkedList data) {
        try {
            if (data == null) {
                throw new RoutingLogicException("routing.logic.blank", null);
            }
            this.parseTable(data);
        }
        catch (RoutingLogicException ex) {
            this.error = ex;
        }
    }

    public RoutingLogicException getError() {
        return this.error;
    }

    public boolean isValid() {
        return this.conditions != null;
    }

    private void parseTable(LinkedList data) throws RoutingLogicException {
        LinkedList<Condition> stack = new LinkedList<Condition>();
        Iterator it = data.descendingIterator();
        while (it.hasNext()) {
            String line = ((String)it.next()).trim();
            stack.push(this.parseLine(line, stack));
        }
        this.conditions = stack;
    }

    public boolean matches(EntityMinecart cart) {
        if (this.conditions == null) {
            return false;
        }
        for (Condition condition : this.conditions) {
            if (!condition.matches(cart)) continue;
            return true;
        }
        return false;
    }

    private Condition parseLine(String line, Deque stack) throws RoutingLogicException {
        if (line.startsWith("Dest=")) {
            return new DestCondition(line);
        }
        if (line.startsWith("Color=")) {
            return new ColorCondition(line);
        }
        if (line.startsWith("Owner=")) {
            return new OwnerCondition(line);
        }
        if (line.startsWith("Name=")) {
            return new NameCondition(line);
        }
        if (line.startsWith("NeedsRefuel=")) {
            return new RefuelCondition(line);
        }
        try {
            if (line.equals("NOT")) {
                return new NOT((Condition)stack.pop());
            }
            if (line.equals("AND")) {
                return new AND((Condition)stack.pop(), (Condition)stack.pop());
            }
            if (line.equals("OR")) {
                return new OR((Condition)stack.pop(), (Condition)stack.pop());
            }
        }
        catch (NoSuchElementException ex) {
            throw new RoutingLogicException("routing.logic.insufficient.operands", line);
        }
        throw new RoutingLogicException("routing.logic.unrecognized.keyword", line);
    }

    private class ColorCondition
    extends Condition {
        private final EnumColor primary;
        private final EnumColor secondary;

        public ColorCondition(String color) throws RoutingLogicException {
            color = color.replace("Color=", "");
            String[] colors = color.split(",");
            if (colors[0].equals("Any")) {
                this.primary = null;
            } else {
                this.primary = EnumColor.fromName(colors[0]);
                if (this.primary == null) {
                    throw new RoutingLogicException("routing.logic.unrecognized.keyword", colors[0]);
                }
            }
            if (colors[1].equals("Any")) {
                this.secondary = null;
            } else {
                this.secondary = EnumColor.fromName(colors[1]);
                if (this.secondary == null) {
                    throw new RoutingLogicException("routing.logic.unrecognized.keyword", colors[1]);
                }
            }
        }

        @Override
        public boolean matches(EntityMinecart cart) {
            if (cart instanceof IPaintedCart) {
                IPaintedCart pCart = (IPaintedCart)cart;
                return !(this.primary != null && this.primary.ordinal() != pCart.getPrimaryColor() || this.secondary != null && this.secondary.ordinal() != pCart.getSecondaryColor());
            }
            return false;
        }
    }

    private class RefuelCondition
    extends Condition {
        private final boolean needsRefuel;

        public RefuelCondition(String line) {
            this.needsRefuel = Boolean.parseBoolean(line.replace("NeedsRefuel=", ""));
        }

        @Override
        public boolean matches(EntityMinecart cart) {
            if (cart instanceof IRefuelableCart) {
                IRefuelableCart rCart = (IRefuelableCart)cart;
                return this.needsRefuel == rCart.needsRefuel();
            }
            return false;
        }
    }

    private class NameCondition
    extends Condition {
        private final String name;

        public NameCondition(String name) {
            this.name = name.replace("Name=", "");
        }

        @Override
        public boolean matches(EntityMinecart cart) {
            return this.name.equals(cart.func_95999_t());
        }
    }

    private class OwnerCondition
    extends Condition {
        private final String owner;

        public OwnerCondition(String owner) {
            this.owner = owner.replace("Owner=", "");
        }

        @Override
        public boolean matches(EntityMinecart cart) {
            return this.owner.equals(CartTools.getCartOwner(cart));
        }
    }

    private class DestCondition
    extends Condition {
        private final String dest;

        public DestCondition(String dest) {
            this.dest = dest.replace("Dest=", "");
        }

        @Override
        public boolean matches(EntityMinecart cart) {
            if (cart instanceof IRoutableCart) {
                String cartDest = ((IRoutableCart)cart).getDestination();
                if (this.dest.equals("null")) {
                    return cartDest == null || cartDest.equals("");
                }
                return cartDest.startsWith(this.dest);
            }
            return false;
        }
    }

    private class OR
    extends Condition {
        private final Condition a;
        private final Condition b;

        public OR(Condition a, Condition b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(EntityMinecart cart) {
            return this.a.matches(cart) || this.b.matches(cart);
        }
    }

    private class AND
    extends Condition {
        private final Condition a;
        private final Condition b;

        public AND(Condition a, Condition b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean matches(EntityMinecart cart) {
            return this.a.matches(cart) && this.b.matches(cart);
        }
    }

    private class NOT
    extends Condition {
        private final Condition a;

        public NOT(Condition a) {
            this.a = a;
        }

        @Override
        public boolean matches(EntityMinecart cart) {
            return !this.a.matches(cart);
        }
    }

    private abstract class Condition {
        private Condition() {
        }

        public abstract boolean matches(EntityMinecart var1);
    }

    public class RoutingLogicException
    extends Exception {
        private ToolTip tips = new ToolTip();

        public RoutingLogicException(String errorTag, String line) {
            this.tips.add(EnumChatFormatting.RED + RailcraftLanguage.translate(errorTag));
            if (line != null) {
                this.tips.add("\"" + line + "\"");
            }
        }

        public ToolTip getToolTip() {
            return this.tips;
        }
    }
}

