/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import ic2.api.item.IBoxable;
import java.util.List;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemCircuit;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemSignalTuner
extends Item
implements IBoxable {
    private static Item item;

    public static void registerItem() {
        String tag;
        int id;
        if (item == null && (id = RailcraftConfig.getItemId(tag = "railcraft.tool.signal.tuner")) > 0) {
            item = new ItemSignalTuner(id);
            RailcraftLanguage.instance().registerItemName(item, tag);
            CraftingPlugin.addShapedRecipe(new ItemStack(item), " T ", "BRB", "   ", Character.valueOf('B'), Block.field_72034_aR, Character.valueOf('R'), ItemCircuit.getReceiverCircuit(), Character.valueOf('T'), Block.field_72035_aQ);
            ItemRegistry.registerItem(tag, new ItemStack(item));
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    private ItemSignalTuner(int id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("railcraft.tool.signal.tuner");
        this.func_77637_a(CreativePlugin.TAB);
    }

    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public void func_77633_a(int id, CreativeTabs tag, List list) {
        list.add(new ItemStack((Item)this));
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int i, int j, int k, int side, float par8, float par9, float par10) {
        TileEntity tile = world.func_72796_p(i, j, k);
        if (tile != null) {
            WorldCoordinate cPos = null;
            NBTTagCompound data = item.func_77978_p();
            if (data != null) {
                int cDim = data.func_74762_e("controllerDim");
                int cx = data.func_74762_e("controllerX");
                int cy = data.func_74762_e("controllerY");
                int cz = data.func_74762_e("controllerZ");
                cPos = new WorldCoordinate(cDim, cx, cy, cz);
            }
            if (tile instanceof IReceiverTile && cPos != null) {
                if (Game.isHost(world)) {
                    SignalReceiver receiver = ((IReceiverTile)tile).getReceiver();
                    if (i != cPos.x || j != cPos.y || k != cPos.z) {
                        tile = world.func_72796_p(cPos.x, cPos.y, cPos.z);
                        if (tile != null && tile instanceof IControllerTile) {
                            SignalController controller = ((IControllerTile)tile).getController();
                            if (receiver.getTile() != controller.getTile()) {
                                controller.registerReceiver(receiver);
                                controller.endPairing();
                                Game.sendLocalizedChat(player, "gui.tuner.success", controller.getName(), receiver.getName());
                                item.func_77982_d(null);
                                return true;
                            }
                        } else if (world.func_72899_e(cPos.x, cPos.y, cPos.z)) {
                            player.func_71035_c(RailcraftLanguage.translate("gui.tuner.abandon.gone"));
                            item.func_77982_d(null);
                        } else {
                            player.func_71035_c(RailcraftLanguage.translate("gui.tuner.abandon.chunk"));
                            item.func_77982_d(null);
                        }
                    }
                }
            } else if (tile instanceof IControllerTile) {
                if (Game.isHost(world)) {
                    SignalController controller = ((IControllerTile)tile).getController();
                    if (cPos == null || i != cPos.x || j != cPos.y || k != cPos.z) {
                        Game.sendLocalizedChat(player, "gui.tuner.start", controller.getName());
                        this.setControllerData(item, tile);
                        controller.startPairing();
                    } else {
                        Game.sendLocalizedChat(player, "gui.tuner.stop", controller.getName());
                        controller.endPairing();
                        item.func_77982_d(null);
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private void setControllerData(ItemStack item, TileEntity tile) {
        NBTTagCompound data = new NBTTagCompound("tag");
        data.func_74768_a("controllerDim", tile.field_70331_k.field_73011_w.field_76574_g);
        data.func_74768_a("controllerX", tile.field_70329_l);
        data.func_74768_a("controllerY", tile.field_70330_m);
        data.func_74768_a("controllerZ", tile.field_70327_n);
        item.func_77982_d(data);
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }
}

