/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.PhantomInventory;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileLoaderItemBase
extends TileLoaderBase
implements IGuiReturnHandler,
ISidedInventory {
    protected static final int[] SLOTS = InvTools.buildSlotArray(0, 9);
    private final PhantomInventory invFilters = new PhantomInventory(9, this);
    protected boolean movedItemCart = false;
    private final MultiButtonController transferModeController = new MultiButtonController(EnumTransferMode.ALL.ordinal(), EnumTransferMode.values());
    private final MultiButtonController redstoneModeController = new MultiButtonController(0, this.getValidRedstoneModes());

    public MultiButtonController getTransferModeController() {
        return this.transferModeController;
    }

    public EnumRedstoneMode[] getValidRedstoneModes() {
        return EnumRedstoneMode.values();
    }

    public MultiButtonController getRedstoneModeController() {
        return this.redstoneModeController;
    }

    public final PhantomInventory getItemFilters() {
        return this.invFilters;
    }

    public abstract Slot getBufferSlot(int var1, int var2, int var3);

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    protected void setPowered(boolean p) {
        if (!this.isSendCartGateAction() && this.redstoneModeController.getButtonState() == EnumRedstoneMode.MANUAL) {
            super.setPowered(false);
            return;
        }
        super.setPowered(p);
    }

    public final boolean mustCompleteOperation() {
        return this.redstoneModeController.getButtonState() == EnumRedstoneMode.COMPLETE;
    }

    @Override
    public boolean hasWork() {
        return this.movedItemCart && super.hasWork();
    }

    public final EnumTransferMode getMode() {
        return (EnumTransferMode)this.transferModeController.getButtonState();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.transferModeController.getCurrentState());
        data.writeByte(this.redstoneModeController.getCurrentState());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.transferModeController.setCurrentState(data.readByte());
        this.redstoneModeController.setCurrentState(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.transferModeController.getCurrentState());
        data.writeByte(this.redstoneModeController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.transferModeController.setCurrentState(data.readByte());
        this.redstoneModeController.setCurrentState(data.readByte());
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.transferModeController.writeToNBT(data, "mode");
        this.redstoneModeController.writeToNBT(data, "redstone");
        this.getItemFilters().writeToNBT("invFilters", data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.transferModeController.readFromNBT(data, "mode");
        this.redstoneModeController.readFromNBT(data, "redstone");
        if (data.func_74767_n("waitTillComplete")) {
            this.redstoneModeController.setCurrentState(EnumRedstoneMode.COMPLETE.ordinal());
        }
        if (data.func_74764_b("filters")) {
            NBTTagCompound filters = data.func_74775_l("filters");
            this.getItemFilters().readFromNBT("Items", filters);
        } else {
            this.getItemFilters().readFromNBT("invFilters", data);
        }
    }

    public static enum EnumRedstoneMode implements IMultiButtonState
    {
        IMMEDIATE("gui.item.loader.immediate"),
        COMPLETE("gui.item.loader.complete"),
        MANUAL("gui.item.loader.manual"),
        PARTIAL("gui.item.loader.partial");

        private final String label;
        private final ToolTip tip;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EnumRedstoneMode() {
            void label;
            this.label = label;
            this.tip = ToolTip.buildToolTip((String)label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return RailcraftLanguage.translate(this.label);
        }

        @Override
        public StandardButtonTextureSets getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }

    public static enum EnumTransferMode implements IMultiButtonState
    {
        TRANSFER("gui.item.loader.transfer"),
        STOCK("gui.item.loader.stock"),
        EXCESS("gui.item.loader.excess"),
        ALL("gui.item.loader.all");

        private final String label;
        private final ToolTip tip;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EnumTransferMode() {
            void label;
            this.label = label;
            this.tip = ToolTip.buildToolTip((String)label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return RailcraftLanguage.translate(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

