/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.modules.ModuleIC2;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.IEnergyDevice;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileLoaderEnergyBase
extends TileLoaderBase
implements IEnergyDevice,
ISidedInventory {
    private static final int SLOT_CHARGE = 0;
    private static final int SLOT_BATTERY = 1;
    private static final int TIER = 2;
    private static final int CAPACITY = 100000;
    private static final int MAX_OVERCLOCKS = 10;
    private static final int MAX_LAPOTRON = 9;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    protected int energy;
    private int prevEnergy;
    protected int transferRate;
    protected short storageUpgrades;
    protected short lapotronUpgrades;
    protected short transformerUpgrades;
    protected short overclockerUpgrades;
    protected ForgeDirection direction = ForgeDirection.NORTH;
    private boolean addedToIC2EnergyNet;
    protected boolean transferedEnergy;

    public TileLoaderEnergyBase() {
        this.setInventorySize(6);
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        switch (slot) {
            case 0: {
                return IC2Plugin.canCharge(stack, this.getTier());
            }
            case 1: {
                return IC2Plugin.canDischarge(stack, this.getTier());
            }
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving) {
        super.onBlockPlacedBy(entityliving);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.direction = MiscTools.getSideClosestToPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, entityliving);
    }

    protected void countUpgrades() {
        ItemStack storage = IC2Plugin.getItem("energyStorageUpgrade");
        ItemStack overclocker = IC2Plugin.getItem("overclockerUpgrade");
        ItemStack transformer = IC2Plugin.getItem("transformerUpgrade");
        Item lapotron = ModuleIC2.lapotronUpgrade;
        this.storageUpgrades = 0;
        this.overclockerUpgrades = 0;
        this.transformerUpgrades = 0;
        this.lapotronUpgrades = 0;
        for (int i = 2; i < 6; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            if (storage != null && stack.func_77969_a(storage)) {
                this.storageUpgrades = (short)(this.storageUpgrades + stack.field_77994_a);
                continue;
            }
            if (overclocker != null && stack.func_77969_a(overclocker)) {
                this.overclockerUpgrades = (short)(this.overclockerUpgrades + stack.field_77994_a);
                continue;
            }
            if (transformer != null && stack.func_77969_a(transformer)) {
                this.transformerUpgrades = (short)(this.transformerUpgrades + stack.field_77994_a);
                continue;
            }
            if (lapotron == null || stack.field_77993_c != lapotron.field_77779_bT) continue;
            this.lapotronUpgrades = (short)(this.lapotronUpgrades + stack.field_77994_a);
        }
        if (this.overclockerUpgrades > 10) {
            this.overclockerUpgrades = (short)10;
        }
        if (this.lapotronUpgrades > 9) {
            this.lapotronUpgrades = (short)9;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.countUpgrades();
    }

    @Override
    public boolean hasWork() {
        return this.transferedEnergy && super.hasWork();
    }

    public abstract TileEntity getIC2Delegate();

    @Override
    public void func_70316_g() {
        ItemStack battery;
        ItemStack charge;
        int capacity;
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (!this.addedToIC2EnergyNet) {
            IC2Plugin.addTileToNet(this.getIC2Delegate());
            this.addedToIC2EnergyNet = true;
        }
        if (this.energy > (capacity = this.getCapacity())) {
            this.energy = capacity;
        }
        if (Game.isHost(this.getWorld()) && this.prevEnergy != this.energy && this.clock % 4 == 0) {
            this.prevEnergy = this.energy;
            this.markBlockForUpdate();
        }
        if ((charge = this.func_70301_a(0)) != null) {
            this.energy -= IC2Plugin.chargeItem(charge, this.energy, this.getTier());
        }
        if ((battery = this.func_70301_a(1)) != null && this.energy < capacity) {
            this.energy += IC2Plugin.dischargeItem(battery, capacity - this.energy, this.getTier());
        }
        if (this.clock % 64 == 0) {
            this.countUpgrades();
        }
    }

    private void dropFromNet() {
        if (this.addedToIC2EnergyNet) {
            IC2Plugin.removeTileFromNet(this.getIC2Delegate());
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.dropFromNet();
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.dropFromNet();
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("energy", this.energy);
        data.func_74774_a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.energy = data.func_74762_e("energy");
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
        this.countUpgrades();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
        data.writeShort(this.storageUpgrades);
        data.writeShort(this.lapotronUpgrades);
        data.writeInt(this.energy);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.storageUpgrades = data.readShort();
        this.lapotronUpgrades = data.readShort();
        this.energy = data.readInt();
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getCapacity() {
        int capacity = 100000;
        capacity += this.storageUpgrades * 10000;
        return capacity += this.lapotronUpgrades * 1000000;
    }

    public int getTier() {
        return 2 + this.transformerUpgrades;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    @Override
    public int getEnergyBarScaled(int scale) {
        return this.getEnergy() * scale / this.getCapacity();
    }
}

