/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.gamma.TileDispenserCart;
import mods.railcraft.common.blocks.machine.gamma.TileDispenserTrain;
import mods.railcraft.common.blocks.machine.gamma.TileEnergyLoader;
import mods.railcraft.common.blocks.machine.gamma.TileEnergyUnloader;
import mods.railcraft.common.blocks.machine.gamma.TileItemLoader;
import mods.railcraft.common.blocks.machine.gamma.TileItemLoaderAdvanced;
import mods.railcraft.common.blocks.machine.gamma.TileItemUnloader;
import mods.railcraft.common.blocks.machine.gamma.TileItemUnloaderAdvanced;
import mods.railcraft.common.blocks.machine.gamma.TileLiquidLoader;
import mods.railcraft.common.blocks.machine.gamma.TileLiquidUnloader;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.modules.ModuleManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public enum EnumMachineGamma implements IEnumMachine
{
    ITEM_LOADER(ModuleManager.Module.TRANSPORT, "loader.item", 0, TileItemLoader.class),
    ITEM_UNLOADER(ModuleManager.Module.TRANSPORT, "unloader.item", 0, TileItemUnloader.class),
    ITEM_LOADER_ADVANCED(ModuleManager.Module.TRANSPORT, "loader.item.advanced", 0, TileItemLoaderAdvanced.class),
    ITEM_UNLOADER_ADVANCED(ModuleManager.Module.TRANSPORT, "unloader.item.advanced", 0, TileItemUnloaderAdvanced.class),
    LIQUID_LOADER(ModuleManager.Module.TRANSPORT, "loader.liquid", 2, TileLiquidLoader.class),
    LIQUID_UNLOADER(ModuleManager.Module.TRANSPORT, "unloader.liquid", 2, TileLiquidUnloader.class),
    ENERGY_LOADER(ModuleManager.Module.IC2, "loader.energy", 0, TileEnergyLoader.class),
    ENERGY_UNLOADER(ModuleManager.Module.IC2, "unloader.energy", 0, TileEnergyUnloader.class),
    DISPENSER_CART(ModuleManager.Module.AUTOMATION, "dispenser.cart", 0, TileDispenserCart.class),
    DISPENSER_TRAIN(ModuleManager.Module.TRAIN, "dispenser.train", 0, TileDispenserTrain.class);

    private final ModuleManager.Module module;
    private final String tag;
    private final int extraIcons;
    private final Class tile;
    private Icon[] texture;
    private static final List creativeList;
    private static final EnumMachineGamma[] VALUES;
    public static final Icon[] pipeTexture;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumMachineGamma(int module3, Class tag) {
        void numTextures;
        void tile;
        this.module = (ModuleManager.Module)module3;
        this.tile = tile;
        this.tag = tag;
        this.extraIcons = numTextures;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    public void setTexture(Icon ... tex) {
        this.texture = tex;
    }

    @Override
    public Icon getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    public static void registerIcons(IconRegister iconRegister) {
        for (EnumMachineGamma machine : VALUES) {
            machine.texture = new Icon[machine.extraIcons + 6];
            Icon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:" + machine.tag, machine.extraIcons + 3);
            Icon cap = icons[0];
            Icon side = icons[1];
            Icon face = icons[2];
            machine.texture[0] = cap;
            machine.texture[1] = cap;
            for (int i = 2; i < 6; ++i) {
                machine.texture[i] = side;
            }
            switch (machine) {
                case ITEM_LOADER: 
                case LIQUID_LOADER: {
                    machine.texture[0] = face;
                    break;
                }
                case ITEM_UNLOADER: 
                case LIQUID_UNLOADER: {
                    machine.texture[1] = face;
                    break;
                }
                default: {
                    machine.texture[3] = face;
                }
            }
            if (machine.extraIcons <= 0) continue;
            System.arraycopy(icons, 3, machine.texture, 6, machine.extraIcons);
        }
        Icon[] pipe = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:loader.pipe", 2);
        EnumMachineGamma.pipeTexture[0] = pipe[0];
        EnumMachineGamma.pipeTexture[1] = pipe[0];
        for (int i = 2; i < 6; ++i) {
            EnumMachineGamma.pipeTexture[i] = pipe[1];
        }
    }

    public static EnumMachineGamma fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "railcraft.machine.gamma." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    public TileMachineBase getTileEntity() {
        try {
            return (TileMachineBase)this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public Block getBlock() {
        return RailcraftBlocks.getBlockMachineGamma();
    }

    @Override
    public int getBlockId() {
        Block block = this.getBlock();
        if (block != null) {
            return block.field_71990_ca;
        }
        return 0;
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    @Override
    public boolean isAvaliable() {
        return this.getBlock() != null && this.isEnabled();
    }

    public boolean register() {
        if (RailcraftConfig.isSubBlockEnabled(this.getTag())) {
            RailcraftBlocks.registerBlockMachineGamma();
            if (this.getBlock() != null) {
                ItemStack stack = this.getItem();
                RailcraftLanguage.instance().registerItemName(stack, this.getTag());
                return true;
            }
        }
        return false;
    }

    static {
        creativeList = new ArrayList();
        VALUES = EnumMachineGamma.values();
        pipeTexture = new Icon[6];
        creativeList.add(ITEM_LOADER);
        creativeList.add(ITEM_UNLOADER);
        creativeList.add(ITEM_LOADER_ADVANCED);
        creativeList.add(ITEM_UNLOADER_ADVANCED);
        creativeList.add(LIQUID_LOADER);
        creativeList.add(LIQUID_UNLOADER);
        creativeList.add(ENERGY_LOADER);
        creativeList.add(ENERGY_UNLOADER);
        creativeList.add(DISPENSER_CART);
        creativeList.add(DISPENSER_TRAIN);
    }
}

