/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.delta;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.beta.TileTankIronWall;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.modules.ModuleManager;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public enum EnumMachineDelta implements IEnumMachine
{
    STEAM_TRAP(ModuleManager.Module.TRANSPORT, "tank.iron.wall", TileTankIronWall.class, new int[]{2, 1, 0, 0, 1, 1, 1, 1});

    private final ModuleManager.Module module;
    private final String tag;
    private final Class tile;
    private Icon[] texture = new Icon[12];
    private final int[] textureInfo;
    private static final List creativeList;
    private static final EnumMachineDelta[] VALUES;
    private ToolTip tip;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumMachineDelta(Class module3, int ... tag) {
        void textureInfo;
        void tile;
        this.module = module3;
        this.tile = tile;
        this.tag = tag;
        this.textureInfo = textureInfo;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    public void setTexture(Icon[] tex) {
        this.texture = tex;
    }

    public Icon[] getTexture() {
        return this.texture;
    }

    @Override
    public Icon getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    public static void registerIcons(IconRegister iconRegister) {
        for (EnumMachineDelta machine : VALUES) {
            if (machine.isDepreciated()) continue;
            machine.texture = new Icon[machine.textureInfo.length - 2];
            int columns = machine.textureInfo[0];
            int rows = machine.textureInfo[1];
            Icon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:" + machine.tag, columns, rows);
            for (int i = 0; i < machine.texture.length; ++i) {
                machine.texture[i] = icons[machine.textureInfo[i + 2]];
            }
        }
    }

    public static EnumMachineDelta fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "railcraft.machine.delta." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    public TileMachineBase getTileEntity() {
        try {
            return (TileMachineBase)this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public Block getBlock() {
        return RailcraftBlocks.getBlockMachineBeta();
    }

    @Override
    public int getBlockId() {
        Block block = this.getBlock();
        if (block != null) {
            return block.field_71990_ca;
        }
        return 0;
    }

    @Override
    public boolean isAvaliable() {
        return ModuleManager.isModuleLoaded(this.getModule()) && this.getBlock() != null && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    public ToolTip getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        if (this.tip != null) {
            return this.tip;
        }
        String tipTag = "gui.tip." + this.tag;
        if (RailcraftLanguage.hasTag(tipTag)) {
            this.tip = ToolTip.buildToolTip(tipTag, new String[0]);
        }
        return this.tip;
    }

    static {
        creativeList = new ArrayList();
        VALUES = EnumMachineDelta.values();
        creativeList.add(STEAM_TRAP);
    }
}

