/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteam;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.elements.IIndicatorController;
import mods.railcraft.common.gui.elements.IndicatorController;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import mods.railcraft.common.plugins.buildcraft.triggers.ITemperature;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEngineSteamHobby
extends TileEngineSteam
implements IInventory,
ISidedInventory,
INeedsFuel,
ITemperature {
    private static final int OUTPUT_MJ = 2;
    private static final byte FUEL_PER_CONVERSION = 8;
    private static final byte TICKS_PER_CONVERSION = 20;
    private static final byte TANK_WATER = 1;
    private static final byte SLOT_FUEL = 0;
    private static final byte SLOT_LIQUID_INPUT = 1;
    private static final byte SLOT_LIQUID_OUTPUT = 2;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 3);
    public float burnTime;
    public float currentItemBurnTime;
    private int burnCycle;
    public float heat = 20.0f;
    private int update;
    private StandaloneInventory inv = new StandaloneInventory(3, this);
    private IIndicatorController heatIndicator = new HeatIndicator();

    public TileEngineSteamHobby() {
        this.getTankManager().add(new FilteredTank(4000, Fluids.WATER.get(), this));
        this.getTankManager().get(0).setCapacity(4000);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.ENGINE_STEAM_HOBBY;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.ENGINE_HOBBY, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.field_77993_c != Item.field_77788_aw.field_77779_bT && (Game.isHost(this.field_70331_k) ? FluidHelper.handleRightClick(this, ForgeDirection.getOrientation((int)side), player, true, false) : FluidHelper.isContainer(current))) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    public IIndicatorController getHeatIndicator() {
        return this.heatIndicator;
    }

    public boolean isBurning() {
        return this.burnTime > 0.0f;
    }

    @Override
    public float getMaxOutputMJ() {
        return 2.0f;
    }

    @Override
    public int steamUsedPerTick() {
        return 10;
    }

    @Override
    public void burn() {
        super.burn();
        ++this.update;
        if (this.update % 8 == 0) {
            FluidHelper.drainContainers(this, this.inv, 1, 2);
        }
        ++this.burnCycle;
        if (this.burnCycle >= 20) {
            FluidStack steam;
            FluidStack water;
            boolean addedFuel;
            this.burnCycle = 0;
            float fuelNeeded = this.getFuelPerConversion();
            while (this.burnTime < fuelNeeded && (addedFuel = this.addFuel())) {
            }
            this.burnTime -= fuelNeeded;
            if (this.burnTime <= 0.0f) {
                this.burnTime = 0.0f;
            }
            if (this.heat >= 100.0f && (water = this.getTankManager().drain(1, 1, false)) != null && (steam = Fluids.STEAM.get(160)) != null) {
                this.getTankManager().drain(1, 1, true);
                this.getTankManager().fill(0, steam, true);
            }
        }
        if (this.isBurning()) {
            this.increaseHeat();
        } else {
            this.reduceHeat();
        }
    }

    private boolean addFuel() {
        if (!this.isPowered()) {
            return false;
        }
        if (this.getEnergyStage() == TileEngine.EnergyStage.OVERHEAT) {
            return false;
        }
        int fuel = this.getMoreFuel();
        this.burnTime += (float)fuel;
        this.currentItemBurnTime = this.burnTime;
        return fuel > 0;
    }

    protected int getMoreFuel() {
        ItemStack fuel = this.func_70301_a(0);
        int burn = FuelPlugin.getBurnTime(fuel);
        if (burn > 0) {
            this.func_70299_a(0, InvTools.depleteItem(fuel));
        }
        return burn;
    }

    public int getFuelPerConversion() {
        float fuel = 8.0f;
        fuel += fuel * (8.0f - 8.0f * this.getHeatLevel());
        return Math.round(fuel);
    }

    public float getHeatLevel() {
        return this.heat / 500.0f;
    }

    private void increaseHeat() {
        float heatLevel = this.getHeatLevel();
        this.heat += 0.05f;
        if (heatLevel < 0.25f) {
            this.heat += 0.05f;
        }
        if (heatLevel < 0.5f) {
            this.heat += 0.05f;
        }
        if (heatLevel < 0.75f) {
            this.heat += 0.05f;
        }
        this.heat = Math.min(this.heat, 500.0f);
    }

    private void reduceHeat() {
        float heatLevel = this.getHeatLevel();
        this.heat -= 0.05f;
        if (heatLevel > 0.25f) {
            this.heat -= 0.05f;
        }
        if (heatLevel > 0.5f) {
            this.heat -= 0.05f;
        }
        if (heatLevel > 0.75f) {
            this.heat -= 0.05f;
        }
        this.heat = Math.max(this.heat, 20.0f);
    }

    public int getBurnProgressScaled(int i) {
        return (int)(this.burnTime / this.currentItemBurnTime * (float)i);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    @Override
    public String func_70303_b() {
        return RailcraftLanguage.translate(EnumMachineBeta.ENGINE_STEAM_HOBBY.getTag());
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int maxEnergy() {
        return 10000;
    }

    @Override
    public int maxEnergyReceived() {
        return 300;
    }

    @Override
    public int maxEnergyExtracted() {
        return 40;
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.inv.func_70301_a(0);
        return fuel == null || fuel.field_77994_a < 8;
    }

    @Override
    public float getTemperature() {
        return this.heat;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.inv.writeToNBT("Items", data);
        data.func_74776_a("heat", this.heat);
        data.func_74776_a("burnTime", this.burnTime);
        data.func_74776_a("currentItemBurnTime", this.currentItemBurnTime);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.inv.readFromNBT("Items", data);
        this.heat = data.func_74760_g("heat");
        this.burnTime = data.func_74760_g("burnTime");
        this.currentItemBurnTime = data.func_74760_g("currentItemBurnTime");
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return FuelPlugin.getBurnTime(stack) > 0;
            }
            case 1: {
                return Fluids.WATER.is(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack));
            }
        }
        return false;
    }

    public boolean func_94042_c() {
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isPowered() && Fluids.STEAM.is(resource)) {
            return this.fill(0, resource, doFill);
        }
        if (Fluids.WATER.is(resource)) {
            return this.fill(1, resource, doFill);
        }
        return 0;
    }

    private int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (tankIndex != 1 || this.heat >= 300.0f) {
            // empty if block
        }
        return this.getTankManager().fill(tankIndex, resource, doFill);
    }

    public void explode() {
        if (Game.isHost(this.field_70331_k)) {
            this.field_70331_k.func_72876_a(null, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, 2.0f, true);
        }
    }

    private class HeatIndicator
    extends IndicatorController {
        private HeatIndicator() {
        }

        @Override
        protected void refreshToolTip() {
            this.tip.text = String.format("%.0f\u00b0C", Float.valueOf(TileEngineSteamHobby.this.heat));
        }

        @Override
        public int getScaledLevel(int size) {
            return (int)((TileEngineSteamHobby.this.heat - 20.0f) * (float)size / 480.0f);
        }
    }
}

