/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.railcraft.common.blocks.machine.beta.ISteamUser;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileEngineSteam
extends TileEngine
implements IFluidHandler,
ISteamUser {
    private static final int TANK_CAPACITY = 8000;
    public static final int TANK_STEAM = 0;
    private final FilteredTank steamTank;
    private TankManager tankManager = new TankManager();
    private int steamUsed;

    public TileEngineSteam() {
        this.steamTank = new FilteredTank(8000, Fluids.STEAM.get(), this);
        this.tankManager.add(this.steamTank);
    }

    @Override
    protected void playSoundOut() {
        SoundHelper.playSoundClient(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, "railcraft:machine.steamburst", 0.15f, (float)(0.5 + MiscTools.getRand().nextGaussian() * 0.1));
    }

    @Override
    protected void playSoundIn() {
        SoundHelper.playSoundClient(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, "railcraft:machine.steamburst", 0.15f, (float)(1.0 + MiscTools.getRand().nextGaussian() * 0.1));
    }

    private int getParticleRate() {
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 1;
            }
            case GREEN: {
                return 2;
            }
            case YELLOW: {
                return 3;
            }
            case ORANGE: {
                return 4;
            }
            case RED: {
                return 5;
            }
            case OVERHEAT: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.ENGINE_STEAM, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random rand) {
        if (this.isActive() || this.getEnergyStage() == TileEngine.EnergyStage.OVERHEAT) {
            int steamRate = this.getParticleRate();
            for (int i = 0; i < steamRate; ++i) {
                EffectManager.instance.steamEffect(this.field_70331_k, this, 0.0);
            }
        }
    }

    @Override
    public void burn() {
        float output = 0.0f;
        if (this.getEnergyStage() != TileEngine.EnergyStage.OVERHEAT) {
            FluidStack steam;
            if (this.isPowered() && (steam = this.steamTank.getFluid()) != null && steam.amount >= this.steamTank.getCapacity() / 2 - 160 && (steam = this.tankManager.drain(0, this.steamUsedPerTick() - 1, true)) != null) {
                this.steamUsed += steam.amount;
            }
            if ((steam = this.tankManager.drain(0, 1, true)) != null) {
                this.steamUsed += steam.amount;
            }
            if (this.isPowered()) {
                if (this.steamUsed >= this.steamUsedPerTick()) {
                    this.steamUsed -= this.steamUsedPerTick();
                    output = this.getMaxOutputMJ();
                    this.addEnergy(this.getMaxOutputMJ());
                }
            } else {
                this.steamUsed = 0;
                this.ventSteam();
            }
        }
        this.currentOutput = (this.currentOutput * 74.0f + output) / 75.0f;
    }

    @Override
    protected void overheat() {
        super.overheat();
        this.ventSteam();
    }

    protected void ventSteam() {
        this.getTankManager().drain(0, 5, true);
    }

    public abstract float getMaxOutputMJ();

    public abstract int steamUsedPerTick();

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.tankManager.readTanksFromNBT(data);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.isPowered()) {
            return 0;
        }
        return this.tankManager.fill(0, resource, doFill);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return Fluids.STEAM.is(fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection dir) {
        return this.tankManager.getTankInfo();
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }
}

