/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.tanks.BoilerFuelTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileBoilerFireboxLiquid
extends TileBoilerFirebox {
    private static final int TANK_FUEL = 2;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    protected final BoilerFuelTank tankFuel = new BoilerFuelTank(16000, this);

    public TileBoilerFireboxLiquid() {
        super(2);
        this.tankManager.add(this.tankFuel);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.BOILER_FIREBOX_LIQUID;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.BOILER_LIQUID, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleClick(EntityPlayer player, int side) {
        if (FluidHelper.handleRightClick(this, ForgeDirection.getOrientation((int)side), player, true, false)) {
            return true;
        }
        return super.handleClick(player, side);
    }

    @Override
    protected void process() {
    }

    @Override
    protected void processBuckets() {
        super.processBuckets();
        FluidHelper.drainContainers(this, this.inventory, 0, 1);
    }

    @Override
    protected float getMoreFuel() {
        FluidStack fuel = this.tankManager.drain(2, 1000, false);
        if (fuel == null) {
            return 0.0f;
        }
        float heatValue = FuelManager.getBoilerFuelValue(fuel.getFluid());
        if (heatValue > 0.0f) {
            this.tankManager.drain(2, 1000, true);
            if (fuel.amount < 1000) {
                heatValue *= (float)fuel.amount / 1000.0f;
            }
        }
        return heatValue;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (Fluids.WATER.is(resource)) {
            return this.fill(0, resource, doFill);
        }
        return this.fill(2, resource, doFill);
    }

    public boolean func_94042_c() {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                Fluid fluid = FluidHelper.getFluidInContianer(stack);
                if (fluid == null) {
                    return false;
                }
                if (!Fluids.WATER.is(fluid) && FuelManager.getBoilerFuelValue(fluid) <= 0) break;
                return true;
            }
        }
        return false;
    }
}

