/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.elements.IIndicatorController;
import mods.railcraft.common.gui.elements.IndicatorController;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventoryConcatenator;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.filters.ArrayStackFilter;
import mods.railcraft.common.util.inventory.wrappers.IInvSlot;
import mods.railcraft.common.util.inventory.wrappers.InventoryIterator;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileRollingMachine
extends TileMachineBase
implements IPowerReceptor,
ISidedInventory,
IHasWork {
    private static final int PROCESS_TIME = 100;
    private static final int ACTIVATION_POWER = 5;
    private static final int MAX_RECEIVE = 100;
    private static final int MAX_ENERGY = 500;
    private static final int SLOT_RESULT = 0;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 10);
    private InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingContainer(), 3, 3);
    private StandaloneInventory invResult = new StandaloneInventory(1, "invResult", (IInventory)this);
    private IInventory inv = InventoryConcatenator.make().add(this.invResult).add((IInventory)this.craftMatrix);
    private PowerHandler powerHandler;
    public boolean useLast;
    private boolean isWorking;
    private boolean paused;
    private int progress;
    private int update;
    public int guiEnergy;
    private AdjacentInventoryCache cache = new AdjacentInventoryCache(this, null, InventorySorter.SIZE_DECENDING);
    private final Set actions = new HashSet();
    private IIndicatorController energyIndicator = new EnergyIndicator();

    public IIndicatorController getEnergyIndicator() {
        return this.energyIndicator;
    }

    public TileRollingMachine() {
        if (RailcraftConfig.machinesRequirePower()) {
            this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
            this.initPowerProvider();
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROLLING_MACHINE;
    }

    private void initPowerProvider() {
        if (this.powerHandler != null) {
            this.powerHandler.configure(1.0f, 100.0f, 5.0f, 500.0f);
            this.powerHandler.configurePowerPerdition(1, 10);
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler != null ? this.powerHandler.getPowerReceiver() : null;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public Icon getIcon(int side) {
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("progress", this.progress);
        if (this.powerHandler != null) {
            this.powerHandler.writeToNBT(data);
        }
        this.invResult.writeToNBT("invResult", data);
        InvTools.writeInvToNBT((IInventory)this.craftMatrix, "Crafting", data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.progress = data.func_74762_e("progress");
        if (this.powerHandler != null) {
            this.powerHandler.readFromNBT(data);
            this.initPowerProvider();
        }
        this.invResult.readFromNBT("invResult", data);
        InvTools.readInvFromNBT((IInventory)this.craftMatrix, "Crafting", data);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) > 64.0) {
            return false;
        }
        GuiHandler.openGui(EnumGui.ROLLING_MACHINE, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public void func_70296_d() {
        this.craftMatrix.func_70296_d();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory((IInventory)this.craftMatrix, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public InventoryCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.cache.purge();
    }

    public void func_70312_q() {
        super.func_70312_q();
        this.cache.purge();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        ++this.update;
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        if (this.powerHandler != null) {
            this.powerHandler.update();
        }
        this.balanceSlots();
        Collection chests = this.cache.getAdjecentInventories();
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !stack.func_77985_e() || stack.field_77994_a != 1) continue;
            ItemStack request = InvTools.removeOneItem(chests, (IStackFilter)new ArrayStackFilter(stack));
            if (request != null) {
                ++stack.field_77994_a;
                break;
            }
            if (stack.field_77994_a <= 1) continue;
            break;
        }
        if (this.update % 16 == 0) {
            this.processActions();
        }
        if (this.paused) {
            return;
        }
        ItemStack recipe = RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.field_70331_k);
        if (recipe != null && this.canMakeMore()) {
            if (this.progress >= 100) {
                this.isWorking = false;
                if (InvTools.isRoomForStack(recipe, this.invResult)) {
                    for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                        this.craftMatrix.func_70298_a(i, 1);
                    }
                    InvTools.moveItemStack(recipe, this.invResult);
                    this.useLast = false;
                    this.progress = 0;
                }
            } else {
                this.isWorking = true;
                if (this.powerHandler != null) {
                    float energy = this.powerHandler.useEnergy(5.0f, 5.0f, true);
                    if (energy >= 5.0f) {
                        ++this.progress;
                    }
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
            this.isWorking = false;
        }
    }

    private void balanceSlots() {
        for (IInvSlot slotA : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
            ItemStack stackA = slotA.getStackInSlot();
            if (stackA == null) continue;
            for (IInvSlot slotB : InventoryIterator.getIterable((IInventory)this.craftMatrix)) {
                ItemStack stackB;
                if (slotA.getIndex() == slotB.getIndex() || (stackB = slotB.getStackInSlot()) == null || !InvTools.isItemEqual(stackA, stackB) || stackA.field_77994_a <= stackB.field_77994_a + 1) continue;
                --stackA.field_77994_a;
                ++stackB.field_77994_a;
                return;
            }
        }
    }

    @Override
    public boolean hasWork() {
        return this.isWorking;
    }

    public void setPaused(boolean p) {
        this.paused = p;
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IAction action) {
        this.actions.add(action);
    }

    public boolean canMakeMore() {
        if (RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.field_70331_k) == null) {
            return false;
        }
        if (this.useLast) {
            return true;
        }
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack slot = this.craftMatrix.func_70301_a(i);
            if (slot == null || slot.field_77994_a > 1) continue;
            return false;
        }
        return true;
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (!stack.func_77985_e()) {
            return false;
        }
        if (stack.func_77973_b().func_77634_r()) {
            return false;
        }
        return this.func_70301_a(slot) != null;
    }

    public int func_70302_i_() {
        return 10;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int count) {
        return this.inv.func_70298_a(slot, count);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    private static class RollingContainer
    extends Container {
        private RollingContainer() {
        }

        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }
    }

    private class EnergyIndicator
    extends IndicatorController {
        private EnergyIndicator() {
        }

        @Override
        protected void refreshToolTip() {
            this.tip.text = String.format("%d MJ", TileRollingMachine.this.guiEnergy);
        }

        @Override
        public int getScaledLevel(int size) {
            float e = Math.min(TileRollingMachine.this.guiEnergy, 500);
            return (int)(e * (float)size / 500.0f);
        }
    }
}

