/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockInventory;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.elements.IIndicatorController;
import mods.railcraft.common.gui.elements.IndicatorController;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryCopy;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileRockCrusher
extends TileMultiBlockInventory
implements IPowerReceptor,
IHasWork,
ISidedInventory {
    private static final int PROCESS_TIME = 100;
    private static final int POWER = 16;
    private static final int MAX_RECEIVE = 500;
    private static final int MAX_ENERGY = 1600;
    private static final int[] SLOTS_INPUT = InvTools.buildSlotArray(0, 9);
    private static final int[] SLOTS_OUTPUT = InvTools.buildSlotArray(9, 9);
    private static final List patterns = new ArrayList();
    private int processTime;
    private IInventory invInput = new InventoryMapper(this, 0, 9);
    private IInventory invOutput = new InventoryMapper(this, 9, 9, false);
    private PowerHandler powerHandler;
    private boolean isWorking = false;
    private boolean paused = false;
    public int guiEnergy;
    private final Set actions = new HashSet();
    private IIndicatorController energyIndicator = new EnergyIndicator();

    public IIndicatorController getEnergyIndicator() {
        return this.energyIndicator;
    }

    public TileRockCrusher() {
        super(EnumMachineAlpha.ROCK_CRUSHER.getTag(), 18, patterns);
        if (RailcraftConfig.machinesRequirePower()) {
            this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        }
        this.initPowerProvider();
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROCK_CRUSHER;
    }

    @Override
    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        int id = this.field_70331_k.func_72798_a(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (id != this.getBlockId() || this.field_70331_k.func_72805_g(i, j, k) != this.func_70322_n()) break;
                return false;
            }
            case 'B': 
            case 'D': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': {
                if (id == this.getBlockId() && this.field_70331_k.func_72805_g(i, j, k) == this.func_70322_n()) break;
                return false;
            }
            case 'A': {
                if (this.field_70331_k.func_72799_c(i, j, k)) break;
                return false;
            }
        }
        return true;
    }

    private void initPowerProvider() {
        if (this.powerHandler != null) {
            this.powerHandler.configure(1.0f, 500.0f, 16.0f, 1600.0f);
            this.powerHandler.configurePowerPerdition(1, 1);
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isHost(this.getWorld())) {
            if (this.powerHandler != null) {
                this.powerHandler.update();
            }
            if (this.isMaster()) {
                if (this.update % 16 == 0) {
                    this.processActions();
                }
                if (this.paused) {
                    return;
                }
                ItemStack input = null;
                IRockCrusherRecipe recipe = null;
                for (int i = 0; i < 9 && ((input = this.invInput.func_70301_a(i)) == null || (recipe = RailcraftCraftingManager.rockCrusher.getRecipe(input)) == null); ++i) {
                }
                if (recipe != null) {
                    if (this.processTime >= 100) {
                        this.isWorking = false;
                        InventoryCopy tempInv = new InventoryCopy(this.invOutput);
                        boolean hasRoom = true;
                        List outputs = recipe.getRandomizedOuputs();
                        for (ItemStack output : outputs) {
                            if ((output = InvTools.moveItemStack(output, tempInv)) == null) continue;
                            hasRoom = false;
                            break;
                        }
                        if (hasRoom) {
                            for (ItemStack output : outputs) {
                                InvTools.moveItemStack(output, this.invOutput);
                            }
                            InvTools.removeOneItem(this.invInput, input);
                            SoundHelper.playSound(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, "mob.irongolem.death", 1.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.25f + 0.7f);
                            this.processTime = 0;
                        }
                    } else {
                        this.isWorking = true;
                        if (this.powerHandler != null) {
                            float energy = this.powerHandler.useEnergy(16.0f, 16.0f, true);
                            if (energy >= 16.0f) {
                                ++this.processTime;
                            }
                        } else {
                            ++this.processTime;
                        }
                    }
                } else {
                    this.processTime = 0;
                    this.isWorking = false;
                }
            }
        }
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
        this.processTime = 0;
        if (this.powerHandler != null) {
            this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        }
        this.initPowerProvider();
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.ROCK_CRUSHER, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon(int side) {
        if (this.isStructureValid()) {
            if (side > 1 && this.getPatternMarker() == 'D') {
                return this.getMachineType().getTexture(6);
            }
            if (side == 1) {
                char m = this.getPatternMarker();
                return this.getMachineType().getTexture(m - 97 + 7);
            }
        }
        if (side > 1) {
            return this.getMachineType().getTexture(0);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("processTime", this.processTime);
        if (this.powerHandler != null) {
            this.powerHandler.writeToNBT(data);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.processTime = data.func_74762_e("processTime");
        if (this.powerHandler != null) {
            this.powerHandler.readFromNBT(data);
            this.initPowerProvider();
        }
    }

    public int getProcessTime() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.processTime;
        }
        return -1;
    }

    public void setProcessTime(int processTime) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.processTime = processTime;
        }
    }

    public int getProgressScaled(int i) {
        return this.getProcessTime() * i / 100;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null && this.powerHandler != null) {
            return mBlock.powerHandler.getPowerReceiver();
        }
        return this.powerHandler != null ? this.powerHandler.getPowerReceiver() : null;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public boolean hasWork() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.isWorking;
        }
        return false;
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IAction action) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.actions.add(action);
        }
    }

    public int[] func_94128_d(int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            return SLOTS_INPUT;
        }
        return SLOTS_OUTPUT;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 9;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 9) {
            return RailcraftCraftingManager.rockCrusher.getRecipe(stack) != null;
        }
        return false;
    }

    static {
        char[][][] map1 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'D', 'B', 'O'}, {'O', 'B', 'D', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'a', 'd', 'f', 'O'}, {'O', 'c', 'e', 'h', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map1));
        char[][][] map2 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'D', 'D', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'a', 'f', 'O'}, {'O', 'b', 'g', 'O'}, {'O', 'c', 'h', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map2));
    }

    private class EnergyIndicator
    extends IndicatorController {
        private EnergyIndicator() {
        }

        @Override
        protected void refreshToolTip() {
            this.tip.text = String.format("%d MJ", TileRockCrusher.this.guiEnergy);
        }

        @Override
        public int getScaledLevel(int size) {
            float e = Math.min(TileRockCrusher.this.guiEnergy, 1600);
            return (int)(e * (float)size / 1600.0f);
        }
    }
}

