/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.hidden;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.Map;
import java.util.WeakHashMap;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.hidden.BlockHidden;
import mods.railcraft.common.blocks.hidden.TileHidden;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeDirection;

public class TrailTicker
implements IScheduledTickHandler {
    private Map lastPosition = new WeakHashMap();

    public int nextTickSpacing() {
        return 40;
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        EntityPlayer player = (EntityPlayer)tickData[0];
        if (player.field_71092_bJ == null || player.field_71092_bJ.startsWith("[")) {
            return;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        WorldServer world = DimensionManager.getWorld((int)player.field_70170_p.field_73011_w.field_76574_g);
        boolean success = this.trySetMarker((World)world, x, y, z, player);
        for (int i = 0; i < 8 && !success; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)MiscTools.RANDOM.nextInt(6));
            int newX = MiscTools.getXOnSide(x, dir);
            int newY = MiscTools.getYOnSide(y, dir);
            int newZ = MiscTools.getZOnSide(z, dir);
            success = this.trySetMarker((World)world, newX, newY, newZ, player);
        }
    }

    private boolean trySetMarker(World world, int x, int y, int z, EntityPlayer player) {
        int blockId = world.func_72798_a(x, y, z);
        if (blockId == 0) {
            world.func_72832_d(x, y, z, BlockHidden.getBlock().field_71990_ca, 0, 3);
            TileEntity tile = world.func_72796_p(x, y, z);
            if (tile instanceof TileHidden) {
                TileHidden hidden = (TileHidden)tile;
                hidden.timestamp = System.currentTimeMillis();
                hidden.colorSeed = (long)player.field_71092_bJ.hashCode() * 50021L;
                WorldCoordinate last = (WorldCoordinate)this.lastPosition.get(player);
                if (last != null) {
                    hidden.lastMarker = last;
                }
                hidden.sendUpdateToClient();
                this.lastPosition.put(player, new WorldCoordinate(world.field_73011_w.field_76574_g, x, y, z));
                return true;
            }
        }
        return blockId == BlockHidden.getBlock().field_71990_ca;
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "Railcraft Heat Trail Ticker";
    }
}

