/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.slab;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.aesthetics.slab.EnumSlab;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class TileSlab
extends RailcraftTileEntity {
    private EnumSlab top = null;
    private EnumSlab bottom = null;

    public boolean canUpdate() {
        return false;
    }

    public Icon getTexture(int side) {
        if (this.bottom != null) {
            return this.bottom.getTexture(side);
        }
        if (this.top != null) {
            return this.top.getTexture(side);
        }
        return EnumSlab.SANDY_BRICK.getTexture(side);
    }

    public void setTopSlab(EnumSlab slab) {
        if (this.top != slab) {
            this.top = slab;
            this.sendUpdateToClient();
        }
    }

    public void setBottomSlab(EnumSlab slab) {
        if (this.bottom != slab) {
            this.bottom = slab;
            this.sendUpdateToClient();
        }
    }

    public EnumSlab getTopSlab() {
        return this.top;
    }

    public EnumSlab getBottomSlab() {
        return this.bottom;
    }

    public boolean isDoubleSlab() {
        return this.top != null && this.bottom != null;
    }

    public boolean isTopSlab() {
        return this.top != null && this.bottom == null;
    }

    public boolean isBottomSlab() {
        return this.top == null && this.bottom != null;
    }

    public EnumSlab getUpmostSlab() {
        if (this.top != null) {
            return this.top;
        }
        return this.bottom;
    }

    public boolean addSlab(EnumSlab slab) {
        if (this.bottom == null) {
            this.setBottomSlab(slab);
            return true;
        }
        if (this.top == null) {
            this.setTopSlab(slab);
            return true;
        }
        return false;
    }

    @Override
    public String func_70303_b() {
        return "";
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        if (this.top != null) {
            data.func_74778_a("top", this.top.name());
        }
        if (this.bottom != null) {
            data.func_74778_a("bottom", this.bottom.name());
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        if (data.func_74764_b("top")) {
            this.top = EnumSlab.fromName(data.func_74779_i("top"));
        }
        if (data.func_74764_b("bottom")) {
            this.bottom = EnumSlab.fromName(data.func_74779_i("bottom"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)(this.top != null ? this.top.ordinal() : -1));
        data.writeByte((byte)(this.bottom != null ? this.bottom.ordinal() : -1));
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte t = data.readByte();
        this.top = t != -1 ? EnumSlab.fromOrdinal(t) : null;
        byte b = data.readByte();
        this.bottom = b != -1 ? EnumSlab.fromOrdinal(b) : null;
        this.markBlockForUpdate();
    }

    @Override
    public short getId() {
        return 43;
    }
}

