/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.aesthetics.post.BlockPost;
import mods.railcraft.common.blocks.signals.BlockSignal;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IDualHeadSignal;
import mods.railcraft.common.util.misc.FakeBlockRenderInfo;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;

public class RenderSignalDual
implements ICombinedRenderer {
    private FakeBlockRenderInfo info = new FakeBlockRenderInfo();

    public RenderSignalDual() {
        this.info.texture = new Icon[6];
        this.info.template = RailcraftBlocks.getBlockSignal();
    }

    @Override
    public void renderBlock(RenderBlocks renderblocks, IBlockAccess iBlockAccess, int x, int y, int z, Block block) {
        int ii;
        float temp;
        IDualHeadSignal tile = (IDualHeadSignal)iBlockAccess.func_72796_p(x, y, z);
        int facing = tile.getFacing().ordinal();
        float pix = 0.0625f;
        float f = 3.0f * pix;
        float f1 = 13.0f * pix;
        this.info.setBlockBounds(f, 0.0f, f, f1, 1.0f, f1);
        this.info.texture[0] = BlockSignal.texturesSignalDual[0];
        this.info.texture[1] = BlockSignal.texturesSignalDual[0];
        this.info.texture[2] = BlockSignal.texturesSignalDual[1];
        this.info.texture[3] = BlockSignal.texturesSignalDual[1];
        this.info.texture[4] = BlockSignal.texturesSignalDual[1];
        this.info.texture[5] = BlockSignal.texturesSignalDual[1];
        this.info.texture[facing] = BlockSignal.texturesSignalDual[2];
        RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        this.info.setRenderSingleSide(facing);
        SignalAspect aspect = tile.getTopAspect();
        if (!aspect.isLit()) {
            aspect = SignalAspect.OFF;
        }
        this.info.texture[facing] = BlockSignal.texturesLampTop[aspect.getTextureIndex()];
        this.info.brightness = aspect.getTextureBrightness();
        RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, this.info.brightness < 0, false);
        aspect = tile.getBottomAspect();
        if (!aspect.isLit()) {
            aspect = SignalAspect.OFF;
        }
        this.info.texture[facing] = BlockSignal.texturesLampBottom[aspect.getTextureIndex()];
        this.info.brightness = aspect.getTextureBrightness();
        RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, this.info.brightness < 0, false);
        this.info.brightness = -1;
        this.info.setRenderAllSides();
        this.info.texture[facing] = BlockSignal.texturesSignalDual[2];
        if (facing == 2 || facing == 3) {
            temp = 13.0f * pix;
            if (facing == 2) {
                temp = pix;
            }
            for (ii = 0; ii < 2; ++ii) {
                this.info.setBlockBounds(6.0f * pix, 7.0f * pix + (float)ii * 6.0f * pix, temp, 10.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
                RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
                this.info.setBlockBounds(5.0f * pix, 4.0f * pix + (float)ii * 6.0f * pix, temp, 6.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
                RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
                this.info.setBlockBounds(10.0f * pix, 4.0f * pix + (float)ii * 6.0f * pix, temp, 11.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
                RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            }
        } else if (facing == 4 || facing == 5) {
            temp = 13.0f * pix;
            if (facing == 4) {
                temp = pix;
            }
            for (ii = 0; ii < 2; ++ii) {
                this.info.setBlockBounds(temp, 7.0f * pix + (float)ii * 6.0f * pix, 6.0f * pix, temp + 2.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, 10.0f * pix);
                RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
                this.info.setBlockBounds(temp, 4.0f * pix + (float)ii * 6.0f * pix, 5.0f * pix, temp + 2.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, 6.0f * pix);
                RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
                this.info.setBlockBounds(temp, 4.0f * pix + (float)ii * 6.0f * pix, 10.0f * pix, temp + 2.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, 11.0f * pix);
                RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
            }
        }
        World world = Game.getWorld();
        boolean flag1 = false;
        boolean flag2 = false;
        if (BlockPost.connectPostAt((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST) || BlockPost.connectPostAt((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST)) {
            flag1 = true;
        }
        if (BlockPost.connectPostAt((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH) || BlockPost.connectPostAt((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH)) {
            flag2 = true;
        }
        boolean flag3 = BlockPost.connectPostAt((IBlockAccess)world, x - 1, y, z, ForgeDirection.EAST);
        boolean flag4 = BlockPost.connectPostAt((IBlockAccess)world, x + 1, y, z, ForgeDirection.WEST);
        boolean flag5 = BlockPost.connectPostAt((IBlockAccess)world, x, y, z - 1, ForgeDirection.SOUTH);
        boolean flag6 = BlockPost.connectPostAt((IBlockAccess)world, x, y, z + 1, ForgeDirection.NORTH);
        if (!flag1 && !flag2) {
            flag1 = true;
        }
        f = 0.4375f;
        f1 = 0.5625f;
        float f2 = 11.0f * pix;
        float f3 = 14.0f * pix;
        float f4 = flag3 ? 0.0f : f;
        float f5 = flag4 ? 1.0f : f1;
        float f6 = flag5 ? 0.0f : f;
        float f7 = flag6 ? 1.0f : f1;
        this.info.texture[0] = BlockSignal.texturesSignalDual[3];
        this.info.texture[1] = BlockSignal.texturesSignalDual[3];
        this.info.texture[2] = BlockSignal.texturesSignalDual[4];
        this.info.texture[3] = BlockSignal.texturesSignalDual[4];
        this.info.texture[4] = BlockSignal.texturesSignalDual[4];
        this.info.texture[5] = BlockSignal.texturesSignalDual[4];
        if (flag1) {
            this.info.setBlockBounds(f4, f2, f, f5, f3, f1);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        if (flag2) {
            this.info.setBlockBounds(f, f2, f6, f1, f3, f7);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        f2 = 5.0f * pix;
        f3 = 8.0f * pix;
        if (flag1) {
            this.info.setBlockBounds(f4, f2, f, f5, f3, f1);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
        if (flag2) {
            this.info.setBlockBounds(f, f2, f6, f1, f3, f7);
            RenderFakeBlock.renderBlock(this.info, iBlockAccess, x, y, z, true, false);
        }
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        EnumSignal signalType = EnumSignal.fromId(item.func_77960_j());
        float pix = 0.0625f;
        float f = 3.0f * pix;
        float f1 = 13.0f * pix;
        this.info.setBlockBounds(f, 0.0f, f, f1, 1.0f, f1);
        this.info.texture[0] = BlockSignal.texturesSignalDual[0];
        this.info.texture[1] = BlockSignal.texturesSignalDual[0];
        this.info.texture[2] = BlockSignal.texturesSignalDual[1];
        this.info.texture[3] = BlockSignal.texturesSignalDual[2];
        this.info.texture[4] = BlockSignal.texturesSignalDual[1];
        this.info.texture[5] = BlockSignal.texturesSignalDual[1];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        this.info.texture[3] = BlockSignal.texturesLampTop[signalType == EnumSignal.DUAL_HEAD_BLOCK_SIGNAL ? 0 : 2];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f, 3);
        this.info.texture[3] = BlockSignal.texturesLampBottom[signalType == EnumSignal.DUAL_HEAD_BLOCK_SIGNAL ? 2 : 0];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f, 3);
        this.info.texture[3] = BlockSignal.texturesSignalDual[2];
        float temp = 13.0f * pix;
        for (int ii = 0; ii < 2; ++ii) {
            this.info.setBlockBounds(6.0f * pix, 7.0f * pix + (float)ii * 6.0f * pix, temp, 10.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
            this.info.setBlockBounds(5.0f * pix, 4.0f * pix + (float)ii * 6.0f * pix, temp, 6.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
            this.info.setBlockBounds(10.0f * pix, 4.0f * pix + (float)ii * 6.0f * pix, temp, 11.0f * pix, 8.0f * pix + (float)ii * 6.0f * pix, temp + 2.0f * pix);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        }
    }
}

