/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.buttons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiBetterButton
extends GuiButton {
    private static final ResourceLocation TEXTURE = new ResourceLocation("railcraft:textures/gui/gui_basic.png");
    protected final IButtonTextureSet texture;
    private ToolTip toolTip;

    public GuiBetterButton(int id, int x, int y, String label) {
        this(id, x, y, 200, StandardButtonTextureSets.LARGE_BUTTON, label);
    }

    public GuiBetterButton(int id, int x, int y, int width, String label) {
        this(id, x, y, width, StandardButtonTextureSets.LARGE_BUTTON, label);
    }

    public GuiBetterButton(int id, int x, int y, int width, IButtonTextureSet texture, String label) {
        super(id, x, y, width, texture.getHeight(), label);
        this.texture = texture;
    }

    public int getWidth() {
        return this.field_73747_a;
    }

    public int getHeight() {
        return this.texture.getHeight();
    }

    public int getTextColor(boolean mouseOver) {
        if (!this.field_73742_g) {
            return -6250336;
        }
        if (mouseOver) {
            return 0xFFFFA0;
        }
        return 0xE0E0E0;
    }

    public boolean isMouseOverButton(int mouseX, int mouseY) {
        return mouseX >= this.field_73746_c && mouseY >= this.field_73743_d && mouseX < this.field_73746_c + this.field_73747_a && mouseY < this.field_73743_d + this.getHeight();
    }

    protected void bindButtonTextures(Minecraft minecraft) {
        minecraft.field_71446_o.func_110577_a(TEXTURE);
    }

    public void func_73737_a(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.field_73748_h) {
            return;
        }
        FontRenderer fontrenderer = minecraft.field_71466_p;
        this.bindButtonTextures(minecraft);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = this.texture.getX();
        int yOffset = this.texture.getY();
        int h = this.texture.getHeight();
        int w = this.texture.getWidth();
        boolean mouseOver = this.isMouseOverButton(mouseX, mouseY);
        int hoverState = this.func_73738_a(mouseOver);
        this.func_73729_b(this.field_73746_c, this.field_73743_d, xOffset, yOffset + hoverState * h, this.field_73747_a / 2, h);
        this.func_73729_b(this.field_73746_c + this.field_73747_a / 2, this.field_73743_d, xOffset + w - this.field_73747_a / 2, yOffset + hoverState * h, this.field_73747_a / 2, h);
        this.func_73739_b(minecraft, mouseX, mouseY);
        this.func_73732_a(fontrenderer, this.field_73744_e, this.field_73746_c + this.field_73747_a / 2, this.field_73743_d + (h - 8) / 2, this.getTextColor(mouseOver));
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(ToolTip tips) {
        this.toolTip = tips;
    }
}

