/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.gui.GuiBasic;
import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.common.blocks.signals.TileBoxController;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketGuiReturn;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.network.packet.Packet;

public class GuiBoxController
extends GuiBasic {
    private final TileBoxController tile;
    private SignalAspect defaultAspect;
    private SignalAspect poweredAspect;

    public GuiBoxController(TileBoxController t) {
        super(t.func_70303_b());
        this.tile = t;
        this.defaultAspect = t.defaultAspect;
        this.poweredAspect = t.poweredAspect;
    }

    public void func_73866_w_() {
        if (this.tile == null) {
            return;
        }
        this.field_73887_h.clear();
        int w = (this.field_73880_f - this.xSize) / 2;
        int h = (this.field_73881_g - this.ySize) / 2;
        this.field_73887_h.add(new GuiButton(0, w + 10, h + 25, 30, 20, "<"));
        this.field_73887_h.add(new GuiButton(1, w + 135, h + 25, 30, 20, ">"));
        this.field_73887_h.add(new GuiButton(2, w + 10, h + 60, 30, 20, "<"));
        this.field_73887_h.add(new GuiButton(3, w + 135, h + 60, 30, 20, ">"));
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        GuiTools.drawCenteredString(this.field_73886_k, RailcraftLanguage.translate("gui.box.controller.aspect.default"), 25);
        GuiTools.drawCenteredString(this.field_73886_k, this.defaultAspect.toString(), 35);
        GuiTools.drawCenteredString(this.field_73886_k, RailcraftLanguage.translate("gui.box.controller.aspect.redstone"), 60);
        GuiTools.drawCenteredString(this.field_73886_k, this.poweredAspect.toString(), 70);
    }

    protected void func_73875_a(GuiButton button) {
        if (this.tile == null) {
            return;
        }
        int normal = this.defaultAspect.ordinal();
        int redstone = this.poweredAspect.ordinal();
        switch (button.field_73741_f) {
            case 0: {
                --normal;
                break;
            }
            case 1: {
                ++normal;
                break;
            }
            case 2: {
                --redstone;
                break;
            }
            case 3: {
                ++redstone;
            }
        }
        normal = Math.min(normal, SignalAspect.OFF.ordinal());
        normal = Math.max(normal, 0);
        redstone = Math.min(redstone, SignalAspect.OFF.ordinal());
        redstone = Math.max(redstone, 0);
        this.defaultAspect = SignalAspect.values()[normal];
        this.poweredAspect = SignalAspect.values()[redstone];
    }

    public void func_73874_b() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.defaultAspect = this.defaultAspect;
            this.tile.poweredAspect = this.poweredAspect;
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendPacketToServer((Packet)pkt.getPacket());
        }
    }
}

