/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.block.IElectricalStorage;
import universalelectricity.core.electricity.ElectricityHelper;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.tile.TileEntityAdvanced;

public abstract class TileEntityElectrical
extends TileEntityAdvanced
implements IElectrical,
IElectricalStorage {
    public float energyStored = 0.0f;

    public void recharge(ItemStack itemStack) {
        this.setEnergyStored(this.getEnergyStored() - ElectricItemHelper.chargeItem(itemStack, this.getProvide(ForgeDirection.UNKNOWN)));
    }

    public void discharge(ItemStack itemStack) {
        this.setEnergyStored(this.getEnergyStored() + ElectricItemHelper.dischargeItem(itemStack, this.getRequest(ForgeDirection.UNKNOWN)));
    }

    public void produce() {
        if (!this.field_70331_k.field_72995_K) {
            for (ForgeDirection outputDirection : this.getOutputDirections()) {
                this.produceUE(outputDirection);
            }
        }
    }

    public void produceUE(ForgeDirection outputDirection) {
        TileEntity outputTile;
        IElectricityNetwork outputNetwork;
        float provide;
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN && (provide = this.getProvide(outputDirection)) > 0.0f && (outputNetwork = ElectricityHelper.getNetworkFromTileEntity(outputTile = VectorHelper.getConnectorFromSide(this.field_70331_k, new Vector3(this), outputDirection), outputDirection)) != null) {
            TileEntity[] tileEntityArray = new TileEntity[]{this};
            ElectricityPack powerRequest = outputNetwork.getRequest(tileEntityArray);
            if (powerRequest.getWatts() > 0.0f) {
                ElectricityPack sendPack = ElectricityPack.min(ElectricityPack.getFromWatts(this.getEnergyStored(), this.getVoltage()), ElectricityPack.getFromWatts(provide, this.getVoltage()));
                float rejectedPower = outputNetwork.produce(sendPack, this);
                this.setEnergyStored(this.getEnergyStored() - (sendPack.getWatts() - rejectedPower));
            }
        }
    }

    public EnumSet<ForgeDirection> getInputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public float receiveElectricity(ForgeDirection from, ElectricityPack receive, boolean doReceive) {
        if (this.getInputDirections().contains(from)) {
            return this.receiveElectricity(receive, doReceive);
        }
        return 0.0f;
    }

    @Override
    public ElectricityPack provideElectricity(ForgeDirection from, ElectricityPack request, boolean doProvide) {
        if (this.getOutputDirections().contains(from)) {
            return this.provideElectricity(request, doProvide);
        }
        return new ElectricityPack();
    }

    public float receiveElectricity(ElectricityPack receive, boolean doReceive) {
        if (receive != null) {
            float prevEnergyStored = this.getEnergyStored();
            float newStoredEnergy = Math.min(this.getEnergyStored() + receive.getWatts(), this.getMaxEnergyStored());
            if (doReceive) {
                this.setEnergyStored(newStoredEnergy);
            }
            return Math.max(newStoredEnergy - prevEnergyStored, 0.0f);
        }
        return 0.0f;
    }

    public float receiveElectricity(float energy, boolean doReceive) {
        return this.receiveElectricity(ElectricityPack.getFromWatts(energy, this.getVoltage()), doReceive);
    }

    public ElectricityPack provideElectricity(ElectricityPack request, boolean doProvide) {
        if (request != null) {
            float requestedEnergy = Math.min(request.getWatts(), this.energyStored);
            if (doProvide) {
                this.setEnergyStored(this.energyStored - requestedEnergy);
            }
            return ElectricityPack.getFromWatts(requestedEnergy, this.getVoltage());
        }
        return new ElectricityPack();
    }

    public ElectricityPack provideElectricity(float energy, boolean doProvide) {
        return this.provideElectricity(ElectricityPack.getFromWatts(energy, this.getVoltage()), doProvide);
    }

    @Override
    public void setEnergyStored(float energy) {
        this.energyStored = Math.max(Math.min(energy, this.getMaxEnergyStored()), 0.0f);
    }

    @Override
    public float getEnergyStored() {
        return this.energyStored;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN)) {
            return false;
        }
        return this.getInputDirections().contains(direction) || this.getOutputDirections().contains(direction);
    }

    @Override
    public float getVoltage() {
        return 0.12f;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energyStored = nbt.func_74760_g("energyStored");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74776_a("energyStored", this.energyStored);
    }
}

