/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.NetworkLoader;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.tile.TileEntityAdvanced;

public abstract class TileEntityConductor
extends TileEntityAdvanced
implements IConductor {
    private IElectricityNetwork network;
    public TileEntity[] adjacentConnections = null;

    public void func_70313_j() {
        if (!this.field_70331_k.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_70313_j();
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public IElectricityNetwork getNetwork() {
        if (this.network == null) {
            this.setNetwork(NetworkLoader.getNewNetwork(this));
        }
        return this.network;
    }

    @Override
    public void setNetwork(IElectricityNetwork network) {
        this.network = network;
    }

    @Override
    public void refresh() {
        if (!this.field_70331_k.field_72995_K) {
            this.adjacentConnections = null;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = VectorHelper.getConnectorFromSide(this.field_70331_k, new Vector3(this), side);
                if (tileEntity == null || tileEntity.getClass() != this.getClass() || !(tileEntity instanceof INetworkProvider)) continue;
                this.getNetwork().merge(((INetworkProvider)tileEntity).getNetwork());
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = new TileEntity[6];
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                ForgeDirection side = ForgeDirection.getOrientation((int)i);
                TileEntity tileEntity = VectorHelper.getConnectorFromSide(this.field_70331_k, new Vector3(this), side);
                if (!(tileEntity instanceof IConnector) || !((IConnector)tileEntity).canConnect(side.getOpposite())) continue;
                this.adjacentConnections[i] = tileEntity;
            }
        }
        return this.adjacentConnections;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }
}

