/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

public class ElectricityDisplay {
    public static String getDisplay(float value, ElectricUnit unit, int decimalPlaces, boolean isShort) {
        return ElectricityDisplay.getDisplay(value, unit, decimalPlaces, isShort, 1000.0f);
    }

    public static String getDisplay(float value, ElectricUnit unit, int decimalPlaces, boolean isShort, float multiplier) {
        value *= multiplier;
        String unitName = unit.name;
        if (isShort) {
            unitName = unit.symbol;
        } else if (value > 1.0f) {
            unitName = unit.getPlural();
        }
        if (value == 0.0f) {
            return value + " " + unitName;
        }
        if ((double)value <= MeasurementUnit.MILLI.value) {
            return ElectricityDisplay.roundDecimals(MeasurementUnit.MICRO.process(value), decimalPlaces) + " " + MeasurementUnit.MICRO.getName(isShort) + unitName;
        }
        if (value < 1.0f) {
            return ElectricityDisplay.roundDecimals(MeasurementUnit.MILLI.process(value), decimalPlaces) + " " + MeasurementUnit.MILLI.getName(isShort) + unitName;
        }
        if ((double)value > MeasurementUnit.MEGA.value) {
            return ElectricityDisplay.roundDecimals(MeasurementUnit.MEGA.process(value), decimalPlaces) + " " + MeasurementUnit.MEGA.getName(isShort) + unitName;
        }
        if ((double)value > MeasurementUnit.KILO.value) {
            return ElectricityDisplay.roundDecimals(MeasurementUnit.KILO.process(value), decimalPlaces) + " " + MeasurementUnit.KILO.getName(isShort) + unitName;
        }
        return ElectricityDisplay.roundDecimals(value, decimalPlaces) + " " + unitName;
    }

    public static String getDisplay(float value, ElectricUnit unit) {
        return ElectricityDisplay.getDisplay(value, unit, 2, false);
    }

    public static String getDisplayShort(float value, ElectricUnit unit) {
        return ElectricityDisplay.getDisplay(value, unit, 2, true);
    }

    public static String getDisplayShort(float value, ElectricUnit unit, int decimalPlaces) {
        return ElectricityDisplay.getDisplay(value, unit, decimalPlaces, true);
    }

    public static String getDisplaySimple(float value, ElectricUnit unit, int decimalPlaces) {
        if (value > 1.0f) {
            if (decimalPlaces < 1) {
                return (int)value + " " + unit.getPlural();
            }
            return ElectricityDisplay.roundDecimals(value, decimalPlaces) + " " + unit.getPlural();
        }
        if (decimalPlaces < 1) {
            return (int)value + " " + unit.name;
        }
        return ElectricityDisplay.roundDecimals(value, decimalPlaces) + " " + unit.name;
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public static double roundDecimals(double d) {
        return ElectricityDisplay.roundDecimals(d, 2);
    }

    public static enum MeasurementUnit {
        MICRO("Micro", "mi", 1.0E-6),
        MILLI("Milli", "m", 0.001),
        KILO("Kilo", "k", 1000.0),
        MEGA("Mega", "M", 1000000.0),
        GIGA("Giga", "G", 1.0E9);

        public String name;
        public String symbol;
        public double value;

        private MeasurementUnit(String name, String symbol, double value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean isSymbol) {
            if (isSymbol) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double value) {
            return value / this.value;
        }
    }

    public static enum ElectricUnit {
        AMPERE("Amp", "I"),
        AMP_HOUR("Amp Hour", "Ah"),
        VOLTAGE("Volt", "V"),
        WATT("Watt", "W"),
        WATT_HOUR("Watt Hour", "Wh"),
        RESISTANCE("Ohm", "R"),
        CONDUCTANCE("Siemen", "S"),
        JOULES("Joule", "J");

        public String name;
        public String symbol;

        private ElectricUnit(String name, String symbol) {
            this.name = name;
            this.symbol = symbol;
        }

        public String getPlural() {
            return this.name + "s";
        }
    }
}

