/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import buildcraft.api.power.IPowerReceptor;
import cpw.mods.fml.common.FMLLog;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.block.INetworkConnection;
import universalelectricity.core.block.INetworkProvider;
import universalelectricity.core.electricity.ElectricalEvent;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.ElectricityNetwork;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.path.PathfinderChecker;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public class UniversalNetwork
extends ElectricityNetwork {
    @Override
    public ElectricityPack getRequest(TileEntity ... ignoreTiles) {
        ArrayList<ElectricityPack> requests = new ArrayList<ElectricityPack>();
        for (TileEntity tileEntity : this.getAcceptors()) {
            if (Arrays.asList(ignoreTiles).contains(tileEntity)) continue;
            if (tileEntity instanceof IElectrical && !tileEntity.func_70320_p() && tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) == tileEntity) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (!((IElectrical)tileEntity).canConnect(direction) || !this.getConductors().contains(VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction))) continue;
                    requests.add(ElectricityPack.getFromWatts(((IElectrical)tileEntity).getRequest(direction), ((IElectrical)tileEntity).getVoltage()));
                }
                continue;
            }
            if (Compatibility.isIndustrialCraft2Loaded() && tileEntity instanceof IEnergySink && !tileEntity.func_70320_p() && tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) == tileEntity) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (!((IEnergySink)tileEntity).acceptsEnergyFrom(VectorHelper.getTileEntityFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction), Direction.values()[(direction.ordinal() + 2) % 6]) || !this.getConductors().contains(VectorHelper.getConnectorFromSide(tileEntity.field_70331_k, new Vector3(tileEntity), direction))) continue;
                    requests.add(ElectricityPack.getFromWatts((float)Math.min(((IEnergySink)tileEntity).demandsEnergy(), ((IEnergySink)tileEntity).getMaxSafeInput()) * Compatibility.IC2_RATIO, 120.0f));
                }
                continue;
            }
            if (!Compatibility.isBuildcraftLoaded() || !(tileEntity instanceof IPowerReceptor) || tileEntity.func_70320_p() || tileEntity.field_70331_k.func_72796_p(tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n) != tileEntity) continue;
            requests.add(ElectricityPack.getFromWatts(((IPowerReceptor)tileEntity).getPowerReceiver(ForgeDirection.UNKNOWN).getActivationEnergy() * Compatibility.BC3_RATIO, 120.0f));
        }
        ElectricityPack mergedPack = ElectricityPack.merge(requests);
        ElectricalEvent.ElectricityRequestEvent evt = new ElectricalEvent.ElectricityRequestEvent(mergedPack, ignoreTiles);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return mergedPack;
    }

    @Override
    public void refresh() {
        this.electricalTiles.clear();
        try {
            Iterator<IConductor> it = this.getConductors().iterator();
            while (it.hasNext()) {
                IConductor conductor = it.next();
                if (conductor == null) {
                    it.remove();
                } else if (((TileEntity)conductor).func_70320_p()) {
                    it.remove();
                } else {
                    conductor.setNetwork(this);
                }
                for (int i = 0; i < conductor.getAdjacentConnections().length; ++i) {
                    ArrayList possibleDirections;
                    TileEntity acceptor = conductor.getAdjacentConnections()[i];
                    if (acceptor instanceof IConductor) continue;
                    if (acceptor instanceof IElectrical) {
                        possibleDirections = null;
                        possibleDirections = this.electricalTiles.containsKey(acceptor) ? (ArrayList)this.electricalTiles.get(acceptor) : new ArrayList();
                        if (((IElectrical)acceptor).canConnect(ForgeDirection.getOrientation((int)i)) && this.getConductors().contains(VectorHelper.getConnectorFromSide(acceptor.field_70331_k, new Vector3(acceptor), ForgeDirection.getOrientation((int)i)))) {
                            possibleDirections.add(ForgeDirection.getOrientation((int)i));
                        }
                        this.electricalTiles.put(acceptor, possibleDirections);
                        continue;
                    }
                    if (Compatibility.isIndustrialCraft2Loaded() && acceptor instanceof IEnergyAcceptor) {
                        possibleDirections = null;
                        possibleDirections = this.electricalTiles.containsKey(acceptor) ? (ArrayList)this.electricalTiles.get(acceptor) : new ArrayList();
                        if (((IEnergyAcceptor)acceptor).acceptsEnergyFrom(VectorHelper.getTileEntityFromSide(acceptor.field_70331_k, new Vector3(acceptor), ForgeDirection.getOrientation((int)i)), Direction.values()[(i + 2) % 6]) && this.getConductors().contains(VectorHelper.getConnectorFromSide(acceptor.field_70331_k, new Vector3(acceptor), ForgeDirection.getOrientation((int)i)))) {
                            possibleDirections.add(ForgeDirection.getOrientation((int)i));
                        }
                        this.electricalTiles.put(acceptor, possibleDirections);
                        continue;
                    }
                    if (!Compatibility.isBuildcraftLoaded() || !(acceptor instanceof IPowerReceptor)) continue;
                    possibleDirections = null;
                    possibleDirections = this.electricalTiles.containsKey(acceptor) ? (ArrayList)this.electricalTiles.get(acceptor) : new ArrayList();
                    if (this.getConductors().contains(VectorHelper.getConnectorFromSide(acceptor.field_70331_k, new Vector3(acceptor), ForgeDirection.getOrientation((int)i)))) {
                        possibleDirections.add(ForgeDirection.getOrientation((int)i));
                    }
                    this.electricalTiles.put(acceptor, possibleDirections);
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Universal Electricity: Failed to refresh conductor.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public void merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            UniversalNetwork newNetwork = new UniversalNetwork();
            newNetwork.getConductors().addAll(this.getConductors());
            newNetwork.getConductors().addAll(network.getConductors());
            newNetwork.refresh();
        }
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.getConductors().remove(splitPoint);
            TileEntity[] connectedBlocks = splitPoint.getAdjacentConnections();
            for (int i = 0; i < connectedBlocks.length; ++i) {
                TileEntity connectedBlockA = connectedBlocks[i];
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (int ii = 0; ii < connectedBlocks.length; ++ii) {
                    TileEntity connectedBlockB = connectedBlocks[ii];
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).field_70331_k, (INetworkConnection)connectedBlockB, splitPoint);
                    finder.init(new Vector3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (Vector3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    UniversalNetwork newNetwork = new UniversalNetwork();
                    for (Vector3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getConductors().add((IConductor)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    @Override
    public String toString() {
        return "UniversalNetwork[" + this.hashCode() + "|Wires:" + this.getConductors().size() + "|Acceptors:" + this.electricalTiles.size() + "]";
    }
}

