/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.compatibility;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.block.IConnector;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;
import universalelectricity.prefab.tile.TileEntityConductor;

public abstract class TileEntityUniversalConductor
extends TileEntityConductor
implements IEnergySink,
IPowerReceptor {
    protected boolean addedToIC2Network = false;

    @Override
    public void setNetwork(IElectricityNetwork network) {
        super.setNetwork(network);
    }

    @Override
    public void func_70313_j() {
        this.unloadTileIC2();
        super.func_70313_j();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    private void unloadTileIC2() {
        if (this.addedToIC2Network && this.field_70331_k != null) {
            if (Compatibility.isIndustrialCraft2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this.addedToIC2Network = false;
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && !this.addedToIC2Network) {
            if (Compatibility.isIndustrialCraft2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            }
            this.addedToIC2Network = true;
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return emitter instanceof IEnergyTile;
    }

    public boolean isAddedToEnergyNet() {
        return this.addedToIC2Network;
    }

    public int demandsEnergy() {
        if (this.getNetwork() == null) {
            return 0;
        }
        return (int)Math.floor(Math.min(this.getNetwork().getRequest(this).getWatts() * Compatibility.TO_IC2_RATIO, 100.0f));
    }

    public int injectEnergy(Direction directionFrom, int amount) {
        if (this.getNetwork() == null) {
            return amount;
        }
        return (int)Math.floor(this.getNetwork().produce(ElectricityPack.getFromWatts(amount, 120.0f), VectorHelper.getTileEntityFromSide(this.field_70331_k, new Vector3(this), directionFrom.toForgeDirection())));
    }

    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        TileEntity[] adjecentConnections = new TileEntity[6];
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            ForgeDirection side = ForgeDirection.getOrientation((int)i);
            TileEntity tileEntity = VectorHelper.getTileEntityFromSide(this.field_70331_k, new Vector3(this), side);
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(side.getOpposite())) continue;
                adjecentConnections[i] = tileEntity;
                continue;
            }
            if (Compatibility.isIndustrialCraft2Loaded() && tileEntity instanceof IEnergyTile) {
                if (tileEntity instanceof IEnergyAcceptor) {
                    if (!((IEnergyAcceptor)tileEntity).acceptsEnergyFrom((TileEntity)this, Direction.values()[(i + 2) % 6].getInverse())) continue;
                    adjecentConnections[i] = tileEntity;
                    continue;
                }
                adjecentConnections[i] = tileEntity;
                continue;
            }
            if (!Compatibility.isBuildcraftLoaded() || !(tileEntity instanceof IPowerReceptor)) continue;
            adjecentConnections[i] = tileEntity;
        }
        return adjecentConnections;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return null;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public World getWorld() {
        return this.func_70314_l();
    }
}

