/*
 * Decompiled with CFR 0.152.
 */
package org.modstats.reporter.v1;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;
import org.modstats.IModstatsReporter;
import org.modstats.ModVersionData;
import org.modstats.ModstatInfo;
import org.modstats.reporter.v1.Config;
import org.modstats.reporter.v1.DataSender;

public class Reporter
implements IModstatsReporter {
    public Map<String, ModVersionData> registeredMods = new ConcurrentHashMap<String, ModVersionData>(2, 0.9f, 1);
    private DataSender sender;
    public Config config;
    private boolean checkedAuto = false;

    public Reporter() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.config = new Config();
    }

    private void startCheck(boolean manual) {
        if (!this.config.allowUpdates) {
            return;
        }
        if (!FMLCommonHandler.instance().getSide().isClient() && !manual) {
            return;
        }
        if (this.registeredMods.isEmpty()) {
            return;
        }
        DataSender currentSender = this.sender;
        if (!manual && this.checkedAuto) {
            return;
        }
        if (currentSender != null && (!currentSender.manual || manual)) {
            return;
        }
        currentSender = new DataSender(this, manual);
        currentSender.start();
        this.sender = currentSender;
    }

    @ForgeSubscribe
    public void worldLoad(WorldEvent.Load event) {
        this.startCheck(false);
    }

    @Override
    public void registerMod(Object mod) {
        ModVersionData data;
        if (!this.config.allowUpdates) {
            return;
        }
        if (mod == null) {
            FMLLog.warning((String)"[Modstats] Can't register null mod.", (Object[])new Object[0]);
            return;
        }
        ModstatInfo info = mod.getClass().getAnnotation(ModstatInfo.class);
        if (info == null) {
            FMLLog.warning((String)"[Modstats] ModstatsInfo annotation not found for given mod.", (Object[])new Object[0]);
            return;
        }
        if (info.prefix() == null || info.prefix().equals("")) {
            FMLLog.warning((String)"[Modstats] Mod prefix can't be empty.", (Object[])new Object[0]);
            return;
        }
        Mod modData = mod.getClass().getAnnotation(Mod.class);
        if (modData == null) {
            if (info.name() == null || info.name().equals("")) {
                FMLLog.warning((String)"[Modstats] Mod name can't be empty.", (Object[])new Object[0]);
                return;
            }
            if (info.version() == null || info.version().equals("")) {
                FMLLog.warning((String)"[Modstats] Mod version can't be empty.", (Object[])new Object[0]);
                return;
            }
            data = new ModVersionData(info.prefix(), info.name(), info.version());
        } else {
            data = new ModVersionData(info.prefix(), modData.name(), modData.version());
        }
        this.registeredMods.put(info.prefix(), data);
    }

    @Override
    public void doManualCheck() {
        this.startCheck(true);
    }
}

