/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.modules.IInterdictionMatrixModule;
import mffs.api.modules.IModule;
import mffs.api.security.IBiometricIdentifier;
import mffs.api.security.IInterdictionMatrix;
import mffs.api.security.Permission;
import mffs.base.TileEntityMFFS;
import mffs.base.TileEntityModuleAcceptor;
import mffs.card.ItemCard;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityInterdictionMatrix
extends TileEntityModuleAcceptor
implements IInterdictionMatrix {
    private boolean isBanMode = true;

    public TileEntityInterdictionMatrix() {
        this.capacityBase = 30;
        this.startModuleIndex = 2;
        this.endModuleIndex = 9;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && (this.isActive() || this.func_70301_a(0) != null && this.func_70301_a((int)0).field_77993_c == ModularForceFieldSystem.itemCardInfinite.field_77779_bT) && this.ticks % 10L == 0L && this.requestFortron(this.getFortronCost() * 10, false) > 0) {
            this.requestFortron(this.getFortronCost() * 10, true);
            this.scan();
        }
    }

    @Override
    public float getAmplifier() {
        return Math.max(Math.min(this.getActionRange() / 20, 10), 1);
    }

    public void scan() {
        try {
            IBiometricIdentifier biometricIdentifier = this.getBiometricIdentifier();
            AxisAlignedBB emptyBounds = AxisAlignedBB.func_72330_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
            List warningList = this.field_70331_k.func_72872_a(EntityLivingBase.class, emptyBounds.func_72314_b((double)this.getWarningRange(), (double)this.getWarningRange(), (double)this.getWarningRange()));
            List actionList = this.field_70331_k.func_72872_a(EntityLivingBase.class, emptyBounds.func_72314_b((double)this.getActionRange(), (double)this.getActionRange(), (double)this.getActionRange()));
            for (EntityLivingBase entityLiving : warningList) {
                if (!(entityLiving instanceof EntityPlayer) || actionList.contains(entityLiving)) continue;
                EntityPlayer player = (EntityPlayer)entityLiving;
                boolean isGranted = false;
                if (biometricIdentifier != null && biometricIdentifier.isAccessGranted(player.field_71092_bJ, Permission.BYPASS_INTERDICTION_MATRIX)) {
                    isGranted = true;
                }
                if (isGranted || this.field_70331_k.field_73012_v.nextInt(3) != 0) continue;
                player.func_71035_c("[" + this.func_70303_b() + "] Warning! You are near the scanning range!");
            }
            if (this.field_70331_k.field_73012_v.nextInt(3) == 0) {
                for (EntityLivingBase entityLiving : actionList) {
                    this.applyAction(entityLiving);
                }
            }
        }
        catch (Exception e) {
            ModularForceFieldSystem.LOGGER.severe("Defense Station has an error!");
            e.printStackTrace();
        }
    }

    public void applyAction(EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            IBiometricIdentifier biometricIdentifier = this.getBiometricIdentifier();
            if (biometricIdentifier != null && biometricIdentifier.isAccessGranted(player.field_71092_bJ, Permission.BYPASS_INTERDICTION_MATRIX)) {
                return;
            }
            if (!Settings.INTERACT_CREATIVE && player.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        for (ItemStack itemStack : this.getModuleStacks(new int[0])) {
            IInterdictionMatrixModule module;
            if (itemStack.func_77973_b() instanceof IInterdictionMatrixModule && ((module = (IInterdictionMatrixModule)itemStack.func_77973_b()).onDefend(this, entityLiving) || entityLiving.field_70128_L)) break;
        }
    }

    @Override
    public List getPacketUpdate() {
        LinkedList<Boolean> objects = new LinkedList<Boolean>();
        objects.addAll(super.getPacketUpdate());
        objects.add(this.isBanMode);
        return objects;
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityMFFS.TilePacketType.DESCRIPTION.ordinal()) {
            this.isBanMode = dataStream.readBoolean();
        } else if (packetID == TileEntityMFFS.TilePacketType.TOGGLE_MODE.ordinal()) {
            this.isBanMode = !this.isBanMode;
        }
    }

    public boolean isBanMode() {
        return this.isBanMode;
    }

    @Override
    public int getActionRange() {
        return Math.min(this.getModuleCount(ModularForceFieldSystem.itemModuleScale, new int[0]), Settings.INTERDICTION_MAX_RANGE);
    }

    @Override
    public int getWarningRange() {
        return Math.min(this.getModuleCount(ModularForceFieldSystem.itemModuleWarn, new int[0]) + this.getActionRange(), Settings.INTERDICTION_MAX_RANGE) + 3;
    }

    public int func_70302_i_() {
        return 19;
    }

    @Override
    public Set<ItemStack> getFilteredItems() {
        HashSet<ItemStack> stacks = new HashSet<ItemStack>();
        for (int i = this.endModuleIndex; i < this.func_70302_i_() - 1; ++i) {
            if (this.func_70301_a(i) == null) continue;
            stacks.add(this.func_70301_a(i));
        }
        return stacks;
    }

    @Override
    public boolean getFilterMode() {
        return this.isBanMode;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0 || slotID == 1) {
            return itemStack.func_77973_b() instanceof ItemCard;
        }
        if (slotID > this.endModuleIndex) {
            return true;
        }
        return itemStack.func_77973_b() instanceof IModule;
    }

    @Override
    public Set<ItemStack> getCards() {
        HashSet<ItemStack> cards = new HashSet<ItemStack>();
        cards.add(super.getCard());
        cards.add(this.func_70301_a(1));
        return cards;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.isBanMode = nbt.func_74767_n("isBanMode");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("isBanMode", this.isBanMode);
    }
}

