/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import icbm.api.IBlockFrequency;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mffs.MFFSHelper;
import mffs.ModularForceFieldSystem;
import mffs.TransferMode;
import mffs.api.card.ICard;
import mffs.api.card.ICardInfinite;
import mffs.api.card.ICoordLink;
import mffs.api.fortron.IFortronCapacitor;
import mffs.api.fortron.IFortronFrequency;
import mffs.api.fortron.IFortronStorage;
import mffs.api.modules.IModule;
import mffs.base.TileEntityMFFS;
import mffs.base.TileEntityModuleAcceptor;
import mffs.fortron.FrequencyGrid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import universalelectricity.core.vector.Vector3;

public class TileEntityFortronCapacitor
extends TileEntityModuleAcceptor
implements IFortronStorage,
IFortronCapacitor {
    private TransferMode transferMode = TransferMode.EQUALIZE;

    public TileEntityFortronCapacitor() {
        this.capacityBase = 700;
        this.capacityBoost = 10;
        this.startModuleIndex = 2;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.consumeCost();
        if (this.isActive() && this.ticks % 10L == 0L) {
            Set<IFortronFrequency> machines = new HashSet<IFortronFrequency>();
            for (ItemStack itemStack : this.getCards()) {
                Vector3 linkPosition;
                if (itemStack == null) continue;
                if (itemStack.func_77973_b() instanceof ICardInfinite) {
                    this.setFortronEnergy(this.getFortronCapacity());
                    continue;
                }
                if (!(itemStack.func_77973_b() instanceof ICoordLink) || (linkPosition = ((ICoordLink)itemStack.func_77973_b()).getLink(itemStack)) == null || !(linkPosition.getTileEntity((IBlockAccess)this.field_70331_k) instanceof IFortronFrequency)) continue;
                machines.add(this);
                machines.add((IFortronFrequency)linkPosition.getTileEntity((IBlockAccess)this.field_70331_k));
            }
            if (machines.size() < 1) {
                machines = this.getLinkedDevices();
            }
            MFFSHelper.transferFortron(this, machines, this.transferMode, this.getTransmissionRate());
        }
    }

    @Override
    public float getAmplifier() {
        return 0.001f;
    }

    @Override
    public List getPacketUpdate() {
        LinkedList<Integer> objects = new LinkedList<Integer>();
        objects.addAll(super.getPacketUpdate());
        objects.add(this.transferMode.ordinal());
        return objects;
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityMFFS.TilePacketType.DESCRIPTION.ordinal()) {
            this.transferMode = TransferMode.values()[dataStream.readInt()];
        } else if (packetID == TileEntityMFFS.TilePacketType.TOGGLE_MODE.ordinal()) {
            this.transferMode = this.transferMode.toggle();
        }
    }

    public int func_70302_i_() {
        return 5;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.transferMode = TransferMode.values()[nbt.func_74762_e("transferMode")];
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("transferMode", this.transferMode.ordinal());
    }

    @Override
    public Set<IFortronFrequency> getLinkedDevices() {
        HashSet<IFortronFrequency> fortronBlocks = new HashSet<IFortronFrequency>();
        Set<IBlockFrequency> frequencyBlocks = FrequencyGrid.instance().get(this.field_70331_k, new Vector3(this), this.getTransmissionRange(), this.getFrequency());
        for (IBlockFrequency frequencyBlock : frequencyBlocks) {
            if (!(frequencyBlock instanceof IFortronFrequency)) continue;
            fortronBlocks.add((IFortronFrequency)frequencyBlock);
        }
        return fortronBlocks;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0 || slotID == 1) {
            return itemStack.func_77973_b() instanceof ICard;
        }
        return itemStack.func_77973_b() instanceof IModule;
    }

    @Override
    public Set<ItemStack> getCards() {
        HashSet<ItemStack> cards = new HashSet<ItemStack>();
        cards.add(super.getCard());
        cards.add(this.func_70301_a(1));
        return cards;
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    @Override
    public int getTransmissionRange() {
        return 15 + this.getModuleCount(ModularForceFieldSystem.itemModuleScale, new int[0]);
    }

    @Override
    public int getTransmissionRate() {
        return 250 + 50 * this.getModuleCount(ModularForceFieldSystem.itemModuleSpeed, new int[0]);
    }
}

