/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mffs.DelayedEvent;
import mffs.IDelayedEventHandler;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.ICache;
import mffs.api.IFieldInteraction;
import mffs.api.modules.IModule;
import mffs.api.modules.IProjectorMode;
import mffs.base.TileEntityMFFS;
import mffs.base.TileEntityModuleAcceptor;
import mffs.tileentity.ProjectorCalculationThread;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public abstract class TileEntityFieldInteraction
extends TileEntityModuleAcceptor
implements IFieldInteraction,
IDelayedEventHandler {
    protected static final int MODULE_SLOT_ID = 2;
    protected boolean isCalculating = false;
    protected boolean isCalculated = false;
    public boolean isAbsolute = false;
    protected final Set<Vector3> calculatedField = Collections.synchronizedSet(new HashSet());
    private final List<DelayedEvent> delayedEvents = new ArrayList<DelayedEvent>();
    private final List<DelayedEvent> quedDelayedEvents = new ArrayList<DelayedEvent>();

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.delayedEvents.size() > 0) {
            do {
                this.quedDelayedEvents.clear();
                Iterator<DelayedEvent> it = this.delayedEvents.iterator();
                while (it.hasNext()) {
                    DelayedEvent evt = it.next();
                    evt.update();
                    if (evt.ticks > 0) continue;
                    it.remove();
                }
                this.delayedEvents.addAll(this.quedDelayedEvents);
            } while (!this.quedDelayedEvents.isEmpty());
        }
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityMFFS.TilePacketType.TOGGLE_MODE_4.ordinal() && !this.field_70331_k.field_72995_K) {
            this.isAbsolute = !this.isAbsolute;
        }
    }

    protected void calculateForceField(ProjectorCalculationThread.IThreadCallBack callBack) {
        if (!this.field_70331_k.field_72995_K && !this.isCalculating && this.getMode() != null) {
            if (this.getModeStack().func_77973_b() instanceof ICache) {
                ((ICache)this.getModeStack().func_77973_b()).clearCache();
            }
            this.calculatedField.clear();
            new ProjectorCalculationThread(this, callBack).start();
        }
    }

    protected void calculateForceField() {
        this.calculateForceField(null);
    }

    @Override
    public ItemStack getModeStack() {
        if (this.func_70301_a(2) != null && this.func_70301_a(2).func_77973_b() instanceof IProjectorMode) {
            return this.func_70301_a(2);
        }
        return null;
    }

    @Override
    public IProjectorMode getMode() {
        if (this.getModeStack() != null) {
            return (IProjectorMode)this.getModeStack().func_77973_b();
        }
        return null;
    }

    @Override
    public int getSidedModuleCount(IModule module, ForgeDirection ... direction) {
        int count = 0;
        if (direction != null && direction.length > 0) {
            for (ForgeDirection checkDir : direction) {
                count += this.getModuleCount(module, this.getSlotsBasedOnDirection(checkDir));
            }
        } else {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection checkDir = ForgeDirection.getOrientation((int)i);
                count += this.getModuleCount(module, this.getSlotsBasedOnDirection(checkDir));
            }
        }
        return count;
    }

    @Override
    public int[] getModuleSlots() {
        return new int[]{15, 16, 17, 18, 19, 20};
    }

    @Override
    public Vector3 getTranslation() {
        int yTranslationNeg;
        int yTranslationPos;
        int xTranslationPos;
        int xTranslationNeg;
        int zTranslationPos;
        int zTranslationNeg;
        String cacheID = "getTranslation";
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Vector3) {
            return (Vector3)this.cache.get(cacheID);
        }
        ForgeDirection direction = this.getDirection();
        if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
            direction = ForgeDirection.NORTH;
        }
        if (this.isAbsolute) {
            zTranslationNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(ForgeDirection.NORTH));
            zTranslationPos = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(ForgeDirection.SOUTH));
            xTranslationNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(ForgeDirection.WEST));
            xTranslationPos = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(ForgeDirection.EAST));
            yTranslationPos = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(ForgeDirection.UP));
            yTranslationNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(ForgeDirection.DOWN));
        } else {
            zTranslationNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.NORTH)));
            zTranslationPos = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.SOUTH)));
            xTranslationNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.WEST)));
            xTranslationPos = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.EAST)));
            yTranslationPos = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(ForgeDirection.UP));
            yTranslationNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleTranslate, this.getSlotsBasedOnDirection(ForgeDirection.DOWN));
        }
        Vector3 translation = new Vector3(xTranslationPos - xTranslationNeg, yTranslationPos - yTranslationNeg, zTranslationPos - zTranslationNeg);
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, translation);
        }
        return translation;
    }

    @Override
    public Vector3 getPositiveScale() {
        int yScalePos;
        int xScalePos;
        int zScalePos;
        String cacheID = "getPositiveScale";
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Vector3) {
            return (Vector3)this.cache.get(cacheID);
        }
        if (this.isAbsolute) {
            zScalePos = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(ForgeDirection.SOUTH));
            xScalePos = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(ForgeDirection.EAST));
            yScalePos = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(ForgeDirection.UP));
        } else {
            ForgeDirection direction = this.getDirection();
            if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
                direction = ForgeDirection.NORTH;
            }
            zScalePos = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.SOUTH)));
            xScalePos = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.EAST)));
            yScalePos = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(ForgeDirection.UP));
        }
        int omnidirectionalScale = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getModuleSlots());
        Vector3 positiveScale = new Vector3(xScalePos += omnidirectionalScale, yScalePos += omnidirectionalScale, zScalePos += omnidirectionalScale);
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, positiveScale);
        }
        return positiveScale;
    }

    @Override
    public Vector3 getNegativeScale() {
        int yScaleNeg;
        int xScaleNeg;
        int zScaleNeg;
        String cacheID = "getNegativeScale";
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Vector3) {
            return (Vector3)this.cache.get(cacheID);
        }
        if (this.isAbsolute) {
            zScaleNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(ForgeDirection.NORTH));
            xScaleNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(ForgeDirection.WEST));
            yScaleNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(ForgeDirection.DOWN));
        } else {
            ForgeDirection direction = this.getDirection();
            if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
                direction = ForgeDirection.NORTH;
            }
            zScaleNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.NORTH)));
            xScaleNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.WEST)));
            yScaleNeg = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getSlotsBasedOnDirection(ForgeDirection.DOWN));
        }
        int omnidirectionalScale = this.getModuleCount(ModularForceFieldSystem.itemModuleScale, this.getModuleSlots());
        Vector3 negativeScale = new Vector3(xScaleNeg += omnidirectionalScale, yScaleNeg += omnidirectionalScale, zScaleNeg += omnidirectionalScale);
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, negativeScale);
        }
        return negativeScale;
    }

    @Override
    public int getRotationYaw() {
        int horizontalRotation;
        String cacheID = "getRotationYaw";
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Integer) {
            return (Integer)this.cache.get(cacheID);
        }
        if (this.isAbsolute) {
            horizontalRotation = this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(ForgeDirection.EAST)) - this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(ForgeDirection.WEST)) + this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(ForgeDirection.SOUTH)) - this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(ForgeDirection.NORTH));
        } else {
            ForgeDirection direction = this.getDirection();
            horizontalRotation = this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.EAST))) - this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.WEST))) + this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.SOUTH))) - this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(VectorHelper.getOrientationFromSide(direction, ForgeDirection.NORTH)));
        }
        horizontalRotation *= 2;
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, horizontalRotation);
        }
        return horizontalRotation;
    }

    @Override
    public int getRotationPitch() {
        String cacheID = "getRotationPitch";
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Integer) {
            return (Integer)this.cache.get(cacheID);
        }
        int verticleRotation = this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(ForgeDirection.UP)) - this.getModuleCount(ModularForceFieldSystem.itemModuleRotate, this.getSlotsBasedOnDirection(ForgeDirection.DOWN));
        verticleRotation *= 2;
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, verticleRotation);
        }
        return verticleRotation;
    }

    @Override
    public Set<Vector3> getInteriorPoints() {
        String cacheID = "getInteriorPoints";
        if (Settings.USE_CACHE && this.cache.containsKey("getInteriorPoints") && this.cache.get("getInteriorPoints") instanceof Set) {
            return (Set)this.cache.get("getInteriorPoints");
        }
        if (this.getModeStack().func_77973_b() instanceof ICache) {
            ((ICache)this.getModeStack().func_77973_b()).clearCache();
        }
        Set<Vector3> newField = this.getMode().getInteriorPoints(this);
        HashSet<Vector3> returnField = new HashSet<Vector3>();
        Vector3 translation = this.getTranslation();
        int rotationYaw = this.getRotationYaw();
        int rotationPitch = this.getRotationPitch();
        for (Vector3 position : newField) {
            Vector3 newPosition = position.clone();
            if (rotationYaw != 0 || rotationPitch != 0) {
                newPosition.rotate((double)rotationYaw, rotationPitch);
            }
            newPosition.add(new Vector3(this));
            newPosition.add(translation);
            returnField.add(newPosition);
        }
        if (Settings.USE_CACHE) {
            this.cache.put("getInteriorPoints", returnField);
        }
        return returnField;
    }

    @Override
    public int[] getSlotsBasedOnDirection(ForgeDirection direction) {
        switch (direction) {
            default: {
                return new int[0];
            }
            case UP: {
                return new int[]{3, 11};
            }
            case DOWN: {
                return new int[]{6, 14};
            }
            case NORTH: {
                return new int[]{8, 10};
            }
            case SOUTH: {
                return new int[]{7, 9};
            }
            case WEST: {
                return new int[]{4, 5};
            }
            case EAST: 
        }
        return new int[]{12, 13};
    }

    @Override
    public void setCalculating(boolean bool) {
        this.isCalculating = bool;
    }

    @Override
    public void setCalculated(boolean bool) {
        this.isCalculated = bool;
    }

    @Override
    public Set<Vector3> getCalculatedField() {
        return this.calculatedField;
    }

    @Override
    public List<DelayedEvent> getDelayedEvents() {
        return this.delayedEvents;
    }

    @Override
    public List<DelayedEvent> getQuedDelayedEvents() {
        return this.quedDelayedEvents;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.isAbsolute = nbt.func_74767_n("isAbsolute");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("isAbsolute", this.isAbsolute);
    }
}

