/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import com.google.common.io.ByteArrayDataInput;
import java.io.IOException;
import java.util.EnumSet;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.modules.IModule;
import mffs.base.TileEntityMFFS;
import mffs.base.TileEntityMFFSUniversal;
import mffs.fortron.FortronHelper;
import mffs.item.card.ItemCardFrequency;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.item.IItemElectric;

public class TileEntityCoercionDeriver
extends TileEntityMFFSUniversal {
    public static final int WATTAGE = 5;
    public static final int REQUIRED_TIME = 200;
    private static final int INITIAL_PRODUCTION = 40;
    public static final float MULTIPLE_PRODUCTION = 4.0f;
    public static final float FORTRON_UE_RATIO = 0.03125f;
    public static final int SLOT_FREQUENCY = 0;
    public static final int SLOT_BATTERY = 1;
    public static final int SLOT_FUEL = 2;
    public int processTime = 0;
    public boolean isInversed = false;

    public TileEntityCoercionDeriver() {
        super(10.0f);
        this.capacityBase = 30;
        this.startModuleIndex = 3;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.isActive()) {
                if (this.isInversed && Settings.ENABLE_ELECTRICITY) {
                    float withdrawnElectricity = (float)this.requestFortron(160, true) * 0.03125f;
                    this.receiveElectricity(withdrawnElectricity, true);
                    this.recharge(this.func_70301_a(1));
                    this.produce();
                    this.provideFortron((int)(this.provideElectricity(this.getMaxEnergyStored(), true).getWatts() / 0.03125f), true);
                } else {
                    this.discharge(this.func_70301_a(1));
                    if (Math.round(this.provideElectricity(5.0f, false).getWatts()) >= 5 || !Settings.ENABLE_ELECTRICITY && this.func_94041_b(2, this.func_70301_a(2))) {
                        int production = this.getProductionRate();
                        this.fortronTank.fill(FortronHelper.getFortron(production + this.field_70331_k.field_73012_v.nextInt(production)), true);
                        if (this.processTime == 0 && this.func_94041_b(2, this.func_70301_a(2))) {
                            this.func_70298_a(2, 1);
                            this.processTime = 200 * Math.max(this.getModuleCount(ModularForceFieldSystem.itemModuleSpeed, new int[0]) / 20, 1);
                        }
                        if (this.processTime > 0) {
                            --this.processTime;
                            if (this.processTime < 1) {
                                this.processTime = 0;
                            }
                        } else {
                            this.processTime = 0;
                        }
                        this.provideElectricity(ForgeDirection.UNKNOWN, ElectricityPack.getFromWatts(5.0f, this.getVoltage()), true);
                    }
                }
            }
        } else if (this.isActive()) {
            this.animation += 1.0f;
        }
    }

    @Override
    public EnumSet<ForgeDirection> getOutputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        if (this.canConsume()) {
            return this.getMaxEnergyStored() - this.getEnergyStored();
        }
        return 0.0f;
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        if (this.isInversed) {
            return Math.min((float)this.getFortronEnergy() * 0.03125f, 5.0f);
        }
        return 0.0f;
    }

    public int getProductionRate() {
        if (this.isActive() && !this.isInversed) {
            int production = 40;
            if (this.processTime > 0) {
                production = (int)((float)production * 4.0f);
            }
            return production;
        }
        return 0;
    }

    public int func_70302_i_() {
        return 6;
    }

    public boolean canConsume() {
        if (this.isActive() && !this.isInversed) {
            return FortronHelper.getAmount(this.fortronTank) < this.fortronTank.getCapacity();
        }
        return false;
    }

    @Override
    public void onReceivePacket(int packetID, ByteArrayDataInput dataStream) throws IOException {
        super.onReceivePacket(packetID, dataStream);
        if (packetID == TileEntityMFFS.TilePacketType.TOGGLE_MODE.ordinal()) {
            this.isInversed = !this.isInversed;
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.processTime = nbt.func_74762_e("processTime");
        this.isInversed = nbt.func_74767_n("isInversed");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("processTime", this.processTime);
        nbt.func_74757_a("isInversed", this.isInversed);
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (itemStack != null) {
            if (slotID >= this.startModuleIndex) {
                return itemStack.func_77973_b() instanceof IModule;
            }
            switch (slotID) {
                case 0: {
                    return itemStack.func_77973_b() instanceof ItemCardFrequency;
                }
                case 1: {
                    return itemStack.func_77973_b() instanceof IItemElectric;
                }
                case 2: {
                    return itemStack.func_77969_a(new ItemStack(Item.field_77756_aW, 1, 4)) || itemStack.func_77969_a(new ItemStack(Item.field_94583_ca));
                }
            }
        }
        return false;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        return true;
    }
}

