/*
 * Decompiled with CFR 0.152.
 */
package mffs.tileentity;

import java.util.Set;
import mffs.ModularForceFieldSystem;
import mffs.api.IFieldInteraction;
import mffs.api.modules.IModule;
import net.minecraft.tileentity.TileEntity;
import universalelectricity.core.vector.Vector3;

public class ProjectorCalculationThread
extends Thread {
    private IFieldInteraction projector;
    private IThreadCallBack callBack;

    public ProjectorCalculationThread(IFieldInteraction projector) {
        this.projector = projector;
    }

    public ProjectorCalculationThread(IFieldInteraction projector, IThreadCallBack callBack) {
        this(projector);
        this.callBack = callBack;
    }

    @Override
    public void run() {
        this.projector.setCalculating(true);
        try {
            if (this.projector.getMode() != null) {
                Set<Vector3> newField = this.projector.getModuleCount(ModularForceFieldSystem.itemModuleInvert, new int[0]) > 0 ? this.projector.getMode().getInteriorPoints(this.projector) : this.projector.getMode().getExteriorPoints(this.projector);
                Vector3 translation = this.projector.getTranslation();
                int rotationYaw = this.projector.getRotationYaw();
                int rotationPitch = this.projector.getRotationPitch();
                for (Vector3 position : newField) {
                    if (rotationYaw != 0 || rotationPitch != 0) {
                        position.rotate((double)rotationYaw, rotationPitch);
                    }
                    position.add(new Vector3((TileEntity)this.projector));
                    position.add(translation);
                    if (position.intY() > ((TileEntity)this.projector).field_70331_k.func_72800_K()) continue;
                    this.projector.getCalculatedField().add(position.round());
                }
                for (IModule module : this.projector.getModules(this.projector.getModuleSlots())) {
                    module.onCalculate(this.projector, this.projector.getCalculatedField());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.projector.setCalculating(false);
        this.projector.setCalculated(true);
        if (this.callBack != null) {
            this.callBack.onThreadComplete();
        }
    }

    public static interface IThreadCallBack {
        public void onThreadComplete();
    }
}

