/*
 * Decompiled with CFR 0.152.
 */
package mffs.item.module.projector;

import java.util.HashSet;
import java.util.Set;
import mffs.IDelayedEventHandler;
import mffs.MFFSHelper;
import mffs.ModularForceFieldSystem;
import mffs.api.Blacklist;
import mffs.api.IProjector;
import mffs.base.TileEntityInventory;
import mffs.base.TileEntityMFFS;
import mffs.event.BlockDropDelayedEvent;
import mffs.event.BlockInventoryDropDelayedEvent;
import mffs.item.module.ItemModule;
import mffs.tileentity.TileEntityForceFieldProjector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.PacketManager;

public class ItemModuleDisintegration
extends ItemModule {
    private int blockCount = 0;

    public ItemModuleDisintegration(int id) {
        super(id, "moduleDisintegration");
        this.setMaxStackSize(1);
        this.setCost(20.0f);
    }

    @Override
    public boolean onProject(IProjector projector, Set<Vector3> fields) {
        this.blockCount = 0;
        return false;
    }

    @Override
    public int onProject(IProjector projector, Vector3 position) {
        if (projector.getTicks() % 40L == 0L) {
            TileEntity tileEntity = (TileEntity)projector;
            int blockID = position.getBlockID((IBlockAccess)tileEntity.field_70331_k);
            Block block = Block.field_71973_m[blockID];
            if (block != null) {
                if (projector.getModuleCount(ModularForceFieldSystem.itemModuleCamouflage, new int[0]) > 0) {
                    int blockMetadata = position.getBlockMetadata((IBlockAccess)tileEntity.field_70331_k);
                    HashSet<ItemStack> filterStacks = new HashSet<ItemStack>();
                    for (int i : projector.getModuleSlots()) {
                        ItemStack checkStack = projector.func_70301_a(i);
                        Block filterBlock = MFFSHelper.getFilterBlock(checkStack);
                        if (filterBlock == null) continue;
                        filterStacks.add(checkStack);
                    }
                    boolean contains = false;
                    for (ItemStack filterStack : filterStacks) {
                        if (!filterStack.func_77969_a(new ItemStack(blockID, 1, blockMetadata))) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) {
                        return 1;
                    }
                }
                if (Blacklist.disintegrationBlacklist.contains(block) || block instanceof BlockFluid || block instanceof IFluidBlock) {
                    return 1;
                }
                PacketManager.sendPacketToClients(PacketManager.getPacket("MFFS", (TileEntity)projector, new Object[]{TileEntityMFFS.TilePacketType.FXS.ordinal(), 2, position.intX(), position.intY(), position.intZ()}), ((TileEntity)projector).field_70331_k);
                if (projector.getModuleCount(ModularForceFieldSystem.itemModuleCollection, new int[0]) > 0) {
                    ((TileEntityForceFieldProjector)projector).getDelayedEvents().add(new BlockInventoryDropDelayedEvent((IDelayedEventHandler)((Object)projector), 39, block, tileEntity.field_70331_k, position, (TileEntityInventory)((Object)projector)));
                } else {
                    ((TileEntityForceFieldProjector)projector).getDelayedEvents().add(new BlockDropDelayedEvent((IDelayedEventHandler)((Object)projector), 39, block, tileEntity.field_70331_k, position));
                }
                if (this.blockCount++ >= projector.getModuleCount(ModularForceFieldSystem.itemModuleSpeed, new int[0]) / 3) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }
}

