/*
 * Decompiled with CFR 0.152.
 */
package mffs.item.module.projector;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import mffs.api.IFieldInteraction;
import mffs.api.IProjector;
import mffs.item.mode.ItemMode;
import mffs.render.model.ModelCube;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import universalelectricity.core.vector.Vector3;

public class ItemModeCylinder
extends ItemMode {
    private static final int RADIUS_Expansion = 0;

    public ItemModeCylinder(int i) {
        super(i, "modeCylinder");
    }

    @Override
    public Set<Vector3> getExteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3> fieldBlocks = new HashSet<Vector3>();
        Vector3 posScale = projector.getPositiveScale();
        Vector3 negScale = projector.getNegativeScale();
        int radius = (posScale.intX() + negScale.intX() + posScale.intZ() + negScale.intZ()) / 2;
        int height = posScale.intY() + negScale.intY();
        for (float x = (float)(-radius); x <= (float)radius; x += 1.0f) {
            for (float z = (float)(-radius); z <= (float)radius; z += 1.0f) {
                for (float y = 0.0f; y < (float)height; y += 1.0f) {
                    if ((y == 0.0f || y == (float)(height - 1)) && x * x + z * z + 0.0f <= (float)(radius * radius)) {
                        fieldBlocks.add(new Vector3(x, y, z));
                    }
                    if (!(x * x + z * z + 0.0f <= (float)(radius * radius)) || !(x * x + z * z + 0.0f >= (float)((radius - 1) * (radius - 1)))) continue;
                    fieldBlocks.add(new Vector3(x, y, z));
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public Set<Vector3> getInteriorPoints(IFieldInteraction projector) {
        HashSet<Vector3> fieldBlocks = new HashSet<Vector3>();
        Vector3 translation = projector.getTranslation();
        Vector3 posScale = projector.getPositiveScale();
        Vector3 negScale = projector.getNegativeScale();
        int radius = (posScale.intX() + negScale.intX() + posScale.intZ() + negScale.intZ()) / 2;
        int height = posScale.intY() + negScale.intY();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 0; y < height; ++y) {
                    Vector3 position = new Vector3(x, y, z);
                    if (!this.isInField(projector, Vector3.add(position, new Vector3((TileEntity)projector)).add(translation))) continue;
                    fieldBlocks.add(position);
                }
            }
        }
        return fieldBlocks;
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3 position) {
        Vector3 posScale = projector.getPositiveScale();
        Vector3 negScale = projector.getNegativeScale();
        int radius = (posScale.intX() + negScale.intX() + posScale.intZ() + negScale.intZ()) / 2;
        Vector3 projectorPos = new Vector3((TileEntity)projector);
        projectorPos.add(projector.getTranslation());
        Vector3 relativePosition = position.clone().subtract(projectorPos);
        relativePosition.rotate((double)(-projector.getRotationYaw()), -projector.getRotationPitch());
        return relativePosition.x * relativePosition.x + relativePosition.z * relativePosition.z + 0.0 <= (double)(radius * radius);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IProjector projector, double x, double y, double z, float f, long ticks) {
        float scale = 0.15f;
        float detail = 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        float radius = 1.5f;
        int i = 0;
        for (float renderX = -radius; renderX <= radius; renderX += detail) {
            for (float renderZ = -radius; renderZ <= radius; renderZ += detail) {
                for (float renderY = -radius; renderY <= radius; renderY += detail) {
                    if (!(renderX * renderX + renderZ * renderZ + 0.0f <= radius * radius && renderX * renderX + renderZ * renderZ + 0.0f >= (radius - 1.0f) * (radius - 1.0f)) && (renderY != 0.0f && renderY != radius - 1.0f || !(renderX * renderX + renderZ * renderZ + 0.0f <= radius * radius))) continue;
                    if (i % 2 == 0) {
                        Vector3 vector = new Vector3(renderX, renderY, renderZ);
                        GL11.glTranslated((double)vector.x, (double)vector.y, (double)vector.z);
                        ModelCube.INSTNACE.render();
                        GL11.glTranslated((double)(-vector.x), (double)(-vector.y), (double)(-vector.z));
                    }
                    ++i;
                }
            }
        }
    }
}

