/*
 * Decompiled with CFR 0.152.
 */
package mffs.item.module.projector;

import calclavia.lib.NBTFileLoader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mffs.MFFSHelper;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.ICache;
import mffs.api.IFieldInteraction;
import mffs.api.IProjector;
import mffs.api.modules.IProjectorMode;
import mffs.item.mode.ItemMode;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import universalelectricity.core.vector.Vector3;

public class ItemModeCustom
extends ItemMode
implements ICache {
    private static final String NBT_ID = "id";
    private static final String NBT_MODE = "mode";
    private static final String NBT_POINT_1 = "point1";
    private static final String NBT_POINT_2 = "point2";
    private static final String NBT_FIELD_BLOCK_LIST = "fieldPoints";
    private static final String NBT_FIELD_BLOCK_ID = "blockID";
    private static final String NBT_FIELD_BLOCK_METADATA = "blockMetadata";
    private static final String NBT_FIELD_SIZE = "fieldSize";
    private static final String NBT_FILE_SAVE_PREFIX = "custom_mode_";
    private final HashMap<String, Object> cache = new HashMap();

    public ItemModeCustom(int i) {
        super(i, "modeCustom");
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
        list.add("Mode: " + (nbt.func_74767_n(NBT_MODE) ? "Subtraction" : "Additive"));
        Vector3 point1 = new Vector3(nbt.func_74775_l(NBT_POINT_1));
        list.add("Point 1: " + point1.intX() + ", " + point1.intY() + ", " + point1.intZ());
        Vector3 point2 = new Vector3(nbt.func_74775_l(NBT_POINT_2));
        list.add("Point 2: " + point2.intX() + ", " + point2.intY() + ", " + point2.intZ());
        int modeID = nbt.func_74762_e(NBT_ID);
        if (modeID > 0) {
            list.add("Mode ID: " + modeID);
            int fieldSize = nbt.func_74762_e(NBT_FIELD_SIZE);
            if (fieldSize > 0) {
                list.add("Field size: " + fieldSize);
            } else {
                list.add("Field not saved.");
            }
        }
        if (GuiScreen.func_73877_p()) {
            super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        } else {
            list.add("Hold shift for more...");
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!world.field_72995_K) {
            if (entityPlayer.func_70093_af()) {
                NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
                if (nbt != null) {
                    Vector3 point1 = new Vector3(nbt.func_74775_l(NBT_POINT_1));
                    Vector3 point2 = new Vector3(nbt.func_74775_l(NBT_POINT_2));
                    if (nbt.func_74764_b(NBT_POINT_1) && nbt.func_74764_b(NBT_POINT_2) && !point1.equals(point2) && point1.distanceTo(point2) < (double)Settings.MAX_FORCE_FIELD_SCALE) {
                        nbt.func_82580_o(NBT_POINT_1);
                        nbt.func_82580_o(NBT_POINT_2);
                        Vector3 midPoint = new Vector3();
                        midPoint.x = (point1.x + point2.x) / 2.0;
                        midPoint.y = (point1.y + point2.y) / 2.0;
                        midPoint.z = (point1.z + point2.z) / 2.0;
                        midPoint = midPoint.floor();
                        point1.subtract(midPoint);
                        point2.subtract(midPoint);
                        Vector3 minPoint = new Vector3(Math.min(point1.x, point2.x), Math.min(point1.y, point2.y), Math.min(point1.z, point2.z));
                        Vector3 maxPoint = new Vector3(Math.max(point1.x, point2.x), Math.max(point1.y, point2.y), Math.max(point1.z, point2.z));
                        NBTTagCompound saveNBT = NBTFileLoader.loadData(this.getSaveDirectory(), NBT_FILE_SAVE_PREFIX + this.getModeID(itemStack));
                        if (saveNBT == null) {
                            saveNBT = new NBTTagCompound();
                        }
                        NBTTagList list = saveNBT.func_74764_b(NBT_FIELD_BLOCK_LIST) ? (NBTTagList)saveNBT.func_74781_a(NBT_FIELD_BLOCK_LIST) : new NBTTagList();
                        for (int x = minPoint.intX(); x <= maxPoint.intX(); ++x) {
                            for (int y = minPoint.intY(); y <= maxPoint.intY(); ++y) {
                                for (int z = minPoint.intZ(); z <= maxPoint.intZ(); ++z) {
                                    Vector3 position = new Vector3(x, y, z);
                                    Vector3 targetCheck = Vector3.add(midPoint, position);
                                    int blockID = targetCheck.getBlockID((IBlockAccess)world);
                                    if (blockID <= 0) continue;
                                    if (!nbt.func_74767_n(NBT_MODE)) {
                                        NBTTagCompound vectorTag = new NBTTagCompound();
                                        position.writeToNBT(vectorTag);
                                        vectorTag.func_74768_a(NBT_FIELD_BLOCK_ID, blockID);
                                        vectorTag.func_74768_a(NBT_FIELD_BLOCK_METADATA, targetCheck.getBlockMetadata((IBlockAccess)world));
                                        list.func_74742_a((NBTBase)vectorTag);
                                        continue;
                                    }
                                    for (int i = 0; i < list.func_74745_c(); ++i) {
                                        Vector3 vector = Vector3.readFromNBT((NBTTagCompound)list.func_74743_b(i));
                                        if (!vector.equals(position)) continue;
                                        list.func_74744_a(i);
                                    }
                                }
                            }
                        }
                        saveNBT.func_74782_a(NBT_FIELD_BLOCK_LIST, (NBTBase)list);
                        nbt.func_74768_a(NBT_FIELD_SIZE, list.func_74745_c());
                        NBTFileLoader.saveData(this.getSaveDirectory(), NBT_FILE_SAVE_PREFIX + this.getModeID(itemStack), saveNBT);
                        this.clearCache();
                        entityPlayer.func_71035_c("Field structure saved.");
                    }
                }
            } else {
                NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
                if (nbt != null) {
                    nbt.func_74757_a(NBT_MODE, !nbt.func_74767_n(NBT_MODE));
                    entityPlayer.func_71035_c("Changed selection mode to " + (nbt.func_74767_n(NBT_MODE) ? "subtraction" : "additive"));
                }
            }
        }
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        NBTTagCompound nbt;
        if (!world.field_72995_K && (nbt = MFFSHelper.getNBTTagCompound(itemStack)) != null) {
            Vector3 point1 = Vector3.readFromNBT(nbt.func_74775_l(NBT_POINT_1));
            if (!nbt.func_74764_b(NBT_POINT_1) || point1.equals(new Vector3(0.0, 0.0, 0.0))) {
                nbt.func_74766_a(NBT_POINT_1, new Vector3(x, y, z).writeToNBT(new NBTTagCompound()));
                entityPlayer.func_71035_c("Set point 1: " + x + ", " + y + ", " + z + ".");
            } else {
                nbt.func_74766_a(NBT_POINT_2, new Vector3(x, y, z).writeToNBT(new NBTTagCompound()));
                entityPlayer.func_71035_c("Set point 2: " + x + ", " + y + ", " + z + ".");
            }
        }
        return true;
    }

    public int getModeID(ItemStack itemStack) {
        NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
        int id = nbt.func_74762_e(NBT_ID);
        if (id <= 0) {
            nbt.func_74768_a(NBT_ID, this.getNextAvaliableID());
            id = nbt.func_74762_e(NBT_ID);
        }
        return id;
    }

    public int getNextAvaliableID() {
        int i = 1;
        for (File fileEntry : this.getSaveDirectory().listFiles()) {
            ++i;
        }
        return i;
    }

    public File getSaveDirectory() {
        File file;
        File saveDirectory = NBTFileLoader.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I());
        if (!saveDirectory.exists()) {
            saveDirectory.mkdir();
        }
        if (!(file = new File(saveDirectory, "mffs")).exists()) {
            file.mkdir();
        }
        return file;
    }

    public Set<Vector3> getFieldBlocks(IFieldInteraction projector, ItemStack itemStack) {
        return this.getFieldBlockMap(projector, itemStack).keySet();
    }

    public HashMap<Vector3, int[]> getFieldBlockMap(IFieldInteraction projector, ItemStack itemStack) {
        String cacheID = "itemStack_" + itemStack.hashCode();
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof HashMap) {
            return (HashMap)this.cache.get(cacheID);
        }
        float scale = (float)projector.getModuleCount(ModularForceFieldSystem.itemModuleScale, new int[0]) / 3.0f;
        HashMap<Vector3, int[]> fieldBlocks = new HashMap<Vector3, int[]>();
        if (this.getSaveDirectory() != null) {
            NBTTagCompound nbt = NBTFileLoader.loadData(this.getSaveDirectory(), NBT_FILE_SAVE_PREFIX + this.getModeID(itemStack));
            if (nbt != null) {
                NBTTagList nbtTagList = nbt.func_74761_m(NBT_FIELD_BLOCK_LIST);
                for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                    NBTTagCompound vectorTag = (NBTTagCompound)nbtTagList.func_74743_b(i);
                    Vector3 position = Vector3.readFromNBT(vectorTag);
                    if (scale > 0.0f) {
                        position.scale(scale);
                    }
                    int[] blockInfo = new int[]{vectorTag.func_74762_e(NBT_FIELD_BLOCK_ID), vectorTag.func_74762_e(NBT_FIELD_BLOCK_METADATA)};
                    if (position == null) continue;
                    fieldBlocks.put(position, blockInfo);
                }
            }
            if (Settings.USE_CACHE) {
                this.cache.put(cacheID, fieldBlocks);
            }
        }
        return fieldBlocks;
    }

    @Override
    public Object getCache(String cacheID) {
        return this.cache.get(cacheID);
    }

    @Override
    public void clearCache(String cacheID) {
        this.cache.remove(cacheID);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Set<Vector3> getExteriorPoints(IFieldInteraction projector) {
        return this.getFieldBlocks(projector, projector.getModeStack());
    }

    @Override
    public Set<Vector3> getInteriorPoints(IFieldInteraction projector) {
        return this.getExteriorPoints(projector);
    }

    @Override
    public boolean isInField(IFieldInteraction projector, Vector3 position) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(IProjector projector, double x, double y, double z, float f, long ticks) {
        IProjectorMode[] modes = new IProjectorMode[]{ModularForceFieldSystem.itemModeCube, ModularForceFieldSystem.itemModeSphere, ModularForceFieldSystem.itemModeTube, ModularForceFieldSystem.itemModePyramid};
        modes[((TileEntity)projector).field_70331_k.field_73012_v.nextInt(modes.length - 1)].render(projector, x, y, z, f, ticks);
    }
}

