/*
 * Decompiled with CFR 0.152.
 */
package mffs.item.module.interdiction;

import java.util.Set;
import mffs.api.security.IBiometricIdentifier;
import mffs.api.security.IInterdictionMatrix;
import mffs.api.security.Permission;
import mffs.item.module.interdiction.ItemModuleInterdictionMatrix;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ItemModuleConfiscate
extends ItemModuleInterdictionMatrix {
    public ItemModuleConfiscate(int i) {
        super(i, "moduleConfiscate");
    }

    @Override
    public boolean onDefend(IInterdictionMatrix interdictionMatrix, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            IBiometricIdentifier biometricIdentifier = interdictionMatrix.getBiometricIdentifier();
            if (biometricIdentifier != null && biometricIdentifier.isAccessGranted(player.field_71092_bJ, Permission.DEFENSE_STATION_CONFISCATION)) {
                return false;
            }
        }
        Set<ItemStack> controlledStacks = interdictionMatrix.getFilteredItems();
        int confiscationCount = 0;
        IInventory inventory = null;
        if (entityLiving instanceof EntityPlayer) {
            IBiometricIdentifier biometricIdentifier = interdictionMatrix.getBiometricIdentifier();
            if (biometricIdentifier != null && biometricIdentifier.isAccessGranted(((EntityPlayer)entityLiving).field_71092_bJ, Permission.BYPASS_INTERDICTION_MATRIX)) {
                return false;
            }
            EntityPlayer player = (EntityPlayer)entityLiving;
            inventory = player.field_71071_by;
        } else if (entityLiving instanceof IInventory) {
            inventory = (IInventory)entityLiving;
        }
        if (inventory != null) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack checkStack = inventory.func_70301_a(i);
                if (checkStack == null) continue;
                boolean stacksMatch = false;
                for (ItemStack itemStack : controlledStacks) {
                    if (itemStack == null || !itemStack.func_77969_a(checkStack)) continue;
                    stacksMatch = true;
                    break;
                }
                if ((!interdictionMatrix.getFilterMode() || !stacksMatch) && (interdictionMatrix.getFilterMode() || stacksMatch)) continue;
                interdictionMatrix.mergeIntoInventory(inventory.func_70301_a(i));
                inventory.func_70299_a(i, null);
                ++confiscationCount;
            }
            if (confiscationCount > 0 && entityLiving instanceof EntityPlayer) {
                ((EntityPlayer)entityLiving).func_71035_c("[" + interdictionMatrix.func_70303_b() + "] " + confiscationCount + " of your item(s) has been confiscated.");
            }
            interdictionMatrix.requestFortron(confiscationCount, true);
        }
        return false;
    }
}

