/*
 * Decompiled with CFR 0.152.
 */
package mffs.item.card;

import java.util.List;
import mffs.MFFSHelper;
import mffs.api.card.ICardIdentification;
import mffs.api.security.Permission;
import mffs.card.ItemCard;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import universalelectricity.prefab.TranslationHelper;

public class ItemCardID
extends ItemCard
implements ICardIdentification {
    private static final String NBT_PREFIX = "mffs_permission_";

    public ItemCardID(int i) {
        super(i, "cardIdentification");
    }

    public ItemCardID(int i, String name) {
        super(i, name);
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase entityLiving, EntityLivingBase par3EntityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            this.setUsername(itemStack, ((EntityPlayer)entityLiving).field_71092_bJ);
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean b) {
        if (this.getUsername(itemStack) != null && !this.getUsername(itemStack).isEmpty()) {
            info.add("Username: " + this.getUsername(itemStack));
        } else {
            info.add("Unidentified");
        }
        String tooltip = "";
        boolean isFirst = true;
        for (Permission permission : Permission.getPermissions()) {
            if (!this.hasPermission(itemStack, permission)) continue;
            if (!isFirst) {
                tooltip = tooltip + ", ";
            }
            isFirst = false;
            tooltip = tooltip + TranslationHelper.getLocal("gui." + permission.name + ".name");
        }
        if (tooltip != null && tooltip.length() > 0) {
            info.addAll(MFFSHelper.splitStringPerWord(tooltip, 5));
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World par2World, EntityPlayer entityPlayer) {
        this.setUsername(itemStack, entityPlayer.field_71092_bJ);
        return itemStack;
    }

    @Override
    public void setUsername(ItemStack itemStack, String username) {
        NBTTagCompound nbtTagCompound = MFFSHelper.getNBTTagCompound(itemStack);
        nbtTagCompound.func_74778_a("name", username);
    }

    @Override
    public String getUsername(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = MFFSHelper.getNBTTagCompound(itemStack);
        if (nbtTagCompound != null && nbtTagCompound.func_74779_i("name") != "") {
            return nbtTagCompound.func_74779_i("name");
        }
        return null;
    }

    @Override
    public boolean hasPermission(ItemStack itemStack, Permission permission) {
        NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
        return nbt.func_74767_n(NBT_PREFIX + permission.id);
    }

    @Override
    public boolean addPermission(ItemStack itemStack, Permission permission) {
        NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
        nbt.func_74757_a(NBT_PREFIX + permission.id, true);
        return false;
    }

    @Override
    public boolean removePermission(ItemStack itemStack, Permission permission) {
        NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
        nbt.func_74757_a(NBT_PREFIX + permission.id, false);
        return false;
    }
}

