/*
 * Decompiled with CFR 0.152.
 */
package mffs.item;

import java.util.List;
import java.util.Set;
import mffs.MFFSHelper;
import mffs.ModularForceFieldSystem;
import mffs.api.card.ICoordLink;
import mffs.api.fortron.IFortronFrequency;
import mffs.api.security.Permission;
import mffs.fortron.FrequencyGrid;
import mffs.item.card.ItemCardFrequency;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import universalelectricity.core.electricity.ElectricityDisplay;
import universalelectricity.core.vector.Vector3;

public class ItemRemoteController
extends ItemCardFrequency
implements ICoordLink {
    public ItemRemoteController(int id) {
        super("remoteController", id);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean b) {
        int blockId;
        super.func_77624_a(itemStack, player, list, b);
        Vector3 position = this.getLink(itemStack);
        if (position != null && Block.field_71973_m[blockId = position.getBlockID((IBlockAccess)player.field_70170_p)] != null) {
            list.add("Linked with: " + Block.field_71973_m[blockId].func_71931_t());
            list.add(position.intX() + ", " + position.intY() + ", " + position.intZ());
            return;
        }
        list.add("Not linked.");
    }

    @Override
    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                Vector3 vector = new Vector3(x, y, z);
                this.setLink(itemStack, vector);
                if (Block.field_71973_m[vector.getBlockID((IBlockAccess)world)] != null) {
                    player.func_71035_c("Linked remote to position: " + x + ", " + y + ", " + z + " with block: " + Block.field_71973_m[vector.getBlockID((IBlockAccess)world)].func_71931_t());
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        Chunk chunk;
        int blockId;
        Vector3 position;
        if (!entityPlayer.func_70093_af() && (position = this.getLink(itemStack)) != null && Block.field_71973_m[blockId = position.getBlockID((IBlockAccess)world)] != null && (chunk = world.func_72938_d(position.intX(), position.intZ())) != null && chunk.field_76636_d && (MFFSHelper.hasPermission(world, position, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, entityPlayer) || MFFSHelper.hasPermission(world, position, Permission.REMOTE_CONTROL, entityPlayer))) {
            float requiredEnergy = (float)Vector3.distance(new Vector3((Entity)entityPlayer), position) * 10.0f;
            int receivedEnergy = 0;
            Set<IFortronFrequency> fortronTiles = FrequencyGrid.instance().getFortronTiles(world, new Vector3((Entity)entityPlayer), 50, this.getFrequency(itemStack));
            for (IFortronFrequency fortronTile : fortronTiles) {
                int consumedEnergy = fortronTile.requestFortron((int)Math.ceil(requiredEnergy / (float)fortronTiles.size()), true);
                if (consumedEnergy > 0) {
                    if (world.field_72995_K) {
                        ModularForceFieldSystem.proxy.renderBeam(world, new Vector3((Entity)entityPlayer).add(new Vector3(0.0, (double)entityPlayer.func_70047_e() - 0.2, 0.0)), new Vector3((TileEntity)fortronTile).add(0.5), 0.6f, 0.6f, 1.0f, 20);
                    }
                    receivedEnergy += consumedEnergy;
                }
                if (!((float)receivedEnergy >= requiredEnergy)) continue;
                try {
                    Block.field_71973_m[blockId].func_71903_a(world, position.intX(), position.intY(), position.intZ(), entityPlayer, 0, 0.0f, 0.0f, 0.0f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return itemStack;
            }
            if (!world.field_72995_K) {
                entityPlayer.func_71035_c("Unable to harness " + ElectricityDisplay.getDisplay(requiredEnergy, ElectricityDisplay.ElectricUnit.JOULES) + " from the Fortron field.");
            }
        }
        return itemStack;
    }

    @Override
    public void setLink(ItemStack itemStack, Vector3 position) {
        NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
        nbt.func_74766_a("position", position.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public Vector3 getLink(ItemStack itemStack) {
        NBTTagCompound nbt = MFFSHelper.getNBTTagCompound(itemStack);
        return Vector3.readFromNBT(nbt.func_74775_l("position"));
    }
}

