/*
 * Decompiled with CFR 0.152.
 */
package mffs.base;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mffs.ModularForceFieldSystem;
import mffs.Settings;
import mffs.api.ICache;
import mffs.api.modules.IModule;
import mffs.api.modules.IModuleAcceptor;
import mffs.base.TileEntityFortron;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class TileEntityModuleAcceptor
extends TileEntityFortron
implements IModuleAcceptor,
ICache {
    public final HashMap<String, Object> cache = new HashMap();
    public int startModuleIndex = 0;
    public int endModuleIndex = this.func_70302_i_() - 1;
    protected int capacityBase = 500;
    protected int capacityBoost = 5;

    @Override
    public void initiate() {
        super.initiate();
        this.fortronTank.setCapacity((this.getModuleCount(ModularForceFieldSystem.itemModuleCapacity, new int[0]) * this.capacityBoost + this.capacityBase) * 1000);
    }

    public void consumeCost() {
        if (this.getFortronCost() > 0) {
            this.requestFortron(this.getFortronCost(), true);
        }
    }

    @Override
    public ItemStack getModule(IModule module) {
        String cacheID = "getModule_" + module.hashCode();
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof ItemStack) {
            return (ItemStack)this.cache.get(cacheID);
        }
        ItemStack returnStack = new ItemStack((Item)module, 0);
        for (ItemStack comparedModule : this.getModuleStacks(new int[0])) {
            if (comparedModule.func_77973_b() != module) continue;
            returnStack.field_77994_a += comparedModule.field_77994_a;
        }
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, returnStack.func_77946_l());
        }
        return returnStack;
    }

    @Override
    public int getModuleCount(IModule module, int ... slots) {
        int count = 0;
        if (module != null) {
            String cacheID = "getModuleCount_" + module.hashCode();
            if (slots != null) {
                cacheID = cacheID + "_" + Arrays.hashCode(slots);
            }
            if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Integer) {
                return (Integer)this.cache.get(cacheID);
            }
            if (slots != null && slots.length > 0) {
                for (int slotID : slots) {
                    if (this.func_70301_a(slotID) == null || this.func_70301_a(slotID).func_77973_b() != module) continue;
                    count += this.func_70301_a((int)slotID).field_77994_a;
                }
            } else {
                for (ItemStack itemStack : this.getModuleStacks(new int[0])) {
                    if (itemStack.func_77973_b() != module) continue;
                    count += itemStack.field_77994_a;
                }
            }
            if (Settings.USE_CACHE) {
                this.cache.put(cacheID, count);
            }
        }
        return count;
    }

    @Override
    public Set<ItemStack> getModuleStacks(int ... slots) {
        String cacheID = "getModuleStacks_";
        if (slots != null) {
            cacheID = cacheID + Arrays.hashCode(slots);
        }
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Set) {
            return (Set)this.cache.get(cacheID);
        }
        HashSet<ItemStack> modules = new HashSet<ItemStack>();
        if (slots == null || slots.length <= 0) {
            for (int slotID = this.startModuleIndex; slotID <= this.endModuleIndex; ++slotID) {
                ItemStack itemStack = this.func_70301_a(slotID);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IModule)) continue;
                modules.add(itemStack);
            }
        } else {
            for (int slotID : slots) {
                ItemStack itemStack = this.func_70301_a(slotID);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IModule)) continue;
                modules.add(itemStack);
            }
        }
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, modules);
        }
        return modules;
    }

    @Override
    public Set<IModule> getModules(int ... slots) {
        String cacheID = "getModules_";
        if (slots != null) {
            cacheID = cacheID + Arrays.hashCode(slots);
        }
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Set) {
            return (Set)this.cache.get(cacheID);
        }
        HashSet<IModule> modules = new HashSet<IModule>();
        if (slots == null || slots.length <= 0) {
            for (int slotID = this.startModuleIndex; slotID <= this.endModuleIndex; ++slotID) {
                ItemStack itemStack = this.func_70301_a(slotID);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IModule)) continue;
                modules.add((IModule)itemStack.func_77973_b());
            }
        } else {
            for (int slotID : slots) {
                ItemStack itemStack = this.func_70301_a(slotID);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IModule)) continue;
                modules.add((IModule)itemStack.func_77973_b());
            }
        }
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, modules);
        }
        return modules;
    }

    @Override
    public int getFortronCost() {
        String cacheID = "getFortronCost";
        if (Settings.USE_CACHE && this.cache.containsKey(cacheID) && this.cache.get(cacheID) instanceof Integer) {
            return (Integer)this.cache.get(cacheID);
        }
        float cost = 0.0f;
        for (ItemStack itemStack : this.getModuleStacks(new int[0])) {
            if (itemStack == null) continue;
            cost += (float)itemStack.field_77994_a * ((IModule)itemStack.func_77973_b()).getFortronCost(this.getAmplifier());
        }
        int result = Math.round(cost);
        if (Settings.USE_CACHE) {
            this.cache.put(cacheID, result);
        }
        return result;
    }

    protected float getAmplifier() {
        return 1.0f;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.fortronTank.setCapacity((this.getModuleCount(ModularForceFieldSystem.itemModuleCapacity, new int[0]) * this.capacityBoost + this.capacityBase) * 1000);
        this.clearCache();
    }

    @Override
    public Object getCache(String cacheID) {
        return this.cache.get(cacheID);
    }

    @Override
    public void clearCache(String cacheID) {
        this.cache.remove(cacheID);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

