/*
 * Decompiled with CFR 0.152.
 */
package mffs.base;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.EnumSet;
import mffs.base.TileEntityModuleAcceptor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.block.IElectricalStorage;
import universalelectricity.core.electricity.ElectricityHelper;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.grid.IElectricityNetwork;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.core.vector.Vector3;
import universalelectricity.core.vector.VectorHelper;

public abstract class TileEntityMFFSUniversal
extends TileEntityModuleAcceptor
implements IElectrical,
IElectricalStorage,
IEnergySink,
IEnergySource,
IPowerReceptor {
    protected boolean isAddedToEnergyNet;
    public PowerHandler bcPowerHandler;
    public PowerHandler.Type bcBlockType = PowerHandler.Type.MACHINE;
    public float energyStored = 0.0f;
    public float maxEnergyStored = 0.0f;

    public TileEntityMFFSUniversal(float maxEnergy) {
        this(0.0f, maxEnergy);
    }

    public TileEntityMFFSUniversal(float initialEnergy, float maxEnergy) {
        this.energyStored = initialEnergy;
        this.maxEnergyStored = maxEnergy;
        this.bcPowerHandler = new PowerHandler(this, this.bcBlockType);
        this.bcPowerHandler.configure(0.0f, 100.0f, 0.0f, (int)Math.ceil(maxEnergy * Compatibility.BC3_RATIO));
    }

    public void recharge(ItemStack itemStack) {
        this.setEnergyStored(this.getEnergyStored() - ElectricItemHelper.chargeItem(itemStack, this.getProvide(ForgeDirection.UNKNOWN)));
    }

    public void discharge(ItemStack itemStack) {
        this.setEnergyStored(this.getEnergyStored() + ElectricItemHelper.dischargeItem(itemStack, this.getProvide(ForgeDirection.UNKNOWN)));
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && !this.isAddedToEnergyNet) {
            if (Compatibility.isIndustrialCraft2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            }
            this.isAddedToEnergyNet = true;
        }
        this.produce();
    }

    public void produce() {
        if (!this.field_70331_k.field_72995_K) {
            for (ForgeDirection outputDirection : this.getOutputDirections()) {
                this.produceUE(outputDirection);
                this.produceIC2(outputDirection);
                this.produceBuildCraft(outputDirection);
            }
        }
        if (Compatibility.isBuildcraftLoaded()) {
            this.receiveElectricity(this.bcPowerHandler.getEnergyStored(), true);
            this.bcPowerHandler.setEnergy(0.0f);
        }
    }

    public void produceIC2(ForgeDirection outputDirection) {
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN) {
            float provide = this.getProvide(outputDirection);
            if (this.getEnergyStored() >= provide && provide > 0.0f && Compatibility.isIndustrialCraft2Loaded()) {
                int ic2Provide = (int)Math.ceil(provide * Compatibility.TO_IC2_RATIO);
                EnergyTileSourceEvent event = new EnergyTileSourceEvent((IEnergySource)this, ic2Provide);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.setEnergyStored(this.getEnergyStored() - ((float)ic2Provide * Compatibility.IC2_RATIO - (float)event.amount * Compatibility.IC2_RATIO));
            }
        }
    }

    public void produceBuildCraft(ForgeDirection outputDirection) {
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN) {
            PowerHandler.PowerReceiver receiver;
            TileEntity tileEntity;
            float provide = this.getProvide(outputDirection);
            if (this.getEnergyStored() >= provide && provide > 0.0f && Compatibility.isBuildcraftLoaded() && (tileEntity = new Vector3(this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_70331_k)) instanceof IPowerReceptor && (receiver = ((IPowerReceptor)tileEntity).getPowerReceiver(outputDirection.getOpposite())) != null) {
                float bc3Provide = provide * Compatibility.TO_BC_RATIO;
                float energyUsed = Math.min(receiver.receiveEnergy(this.bcBlockType, bc3Provide, outputDirection.getOpposite()), bc3Provide);
                this.setEnergyStored(this.getEnergyStored() - (bc3Provide - energyUsed * Compatibility.TO_BC_RATIO));
            }
        }
    }

    public void produceUE(ForgeDirection outputDirection) {
        TileEntity outputTile;
        IElectricityNetwork outputNetwork;
        float provide;
        if (!this.field_70331_k.field_72995_K && outputDirection != null && outputDirection != ForgeDirection.UNKNOWN && (provide = this.getProvide(outputDirection)) > 0.0f && (outputNetwork = ElectricityHelper.getNetworkFromTileEntity(outputTile = VectorHelper.getConnectorFromSide(this.field_70331_k, new Vector3(this), outputDirection), outputDirection)) != null) {
            TileEntity[] tileEntityArray = new TileEntity[]{this};
            ElectricityPack powerRequest = outputNetwork.getRequest(tileEntityArray);
            if (powerRequest.getWatts() > 0.0f) {
                ElectricityPack sendPack = ElectricityPack.min(ElectricityPack.getFromWatts(this.getEnergyStored(), this.getVoltage()), ElectricityPack.getFromWatts(provide, this.getVoltage()));
                float rejectedPower = outputNetwork.produce(sendPack, this);
                this.setEnergyStored(this.getEnergyStored() - (sendPack.getWatts() - rejectedPower));
            }
        }
    }

    public EnumSet<ForgeDirection> getInputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return this.canConnect(direction.toForgeDirection());
    }

    public boolean isAddedToEnergyNet() {
        return this.isAddedToEnergyNet;
    }

    @Override
    public void func_70313_j() {
        this.unloadTileIC2();
        super.func_70313_j();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_70331_k != null) {
            if (Compatibility.isIndustrialCraft2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this.isAddedToEnergyNet = false;
        }
    }

    public int demandsEnergy() {
        return (int)Math.ceil(this.getRequest(ForgeDirection.UNKNOWN) * Compatibility.TO_IC2_RATIO);
    }

    public int injectEnergy(Direction directionFrom, int amount) {
        if (this.getInputDirections().contains(directionFrom.toForgeDirection())) {
            float convertedEnergy = (float)amount * Compatibility.IC2_RATIO;
            ElectricityPack toSend = ElectricityPack.getFromWatts(convertedEnergy, this.getVoltage());
            float receive = this.receiveElectricity(directionFrom.toForgeDirection(), toSend, true);
            return Math.round((float)amount - receive * Compatibility.TO_IC2_RATIO);
        }
        return amount;
    }

    public int getMaxEnergyOutput() {
        return (int)Math.ceil(this.getProvide(ForgeDirection.UNKNOWN));
    }

    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return receiver instanceof IEnergyTile && direction.toForgeDirection().equals(this.getOutputDirections());
    }

    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public float receiveElectricity(ForgeDirection from, ElectricityPack receive, boolean doReceive) {
        if (this.getInputDirections().contains(from)) {
            return this.receiveElectricity(receive, doReceive);
        }
        return 0.0f;
    }

    @Override
    public ElectricityPack provideElectricity(ForgeDirection from, ElectricityPack request, boolean doProvide) {
        if (this.getOutputDirections().contains(from)) {
            return this.provideElectricity(request, doProvide);
        }
        return new ElectricityPack();
    }

    public float receiveElectricity(ElectricityPack receive, boolean doReceive) {
        if (receive != null) {
            float prevEnergyStored = this.getEnergyStored();
            float newStoredEnergy = Math.min(this.getEnergyStored() + receive.getWatts(), this.getMaxEnergyStored());
            if (doReceive) {
                this.setEnergyStored(newStoredEnergy);
            }
            return Math.max(newStoredEnergy - prevEnergyStored, 0.0f);
        }
        return 0.0f;
    }

    public float receiveElectricity(float energy, boolean doReceive) {
        return this.receiveElectricity(ElectricityPack.getFromWatts(energy, this.getVoltage()), doReceive);
    }

    public ElectricityPack provideElectricity(ElectricityPack request, boolean doProvide) {
        if (request != null) {
            float requestedEnergy = Math.min(request.getWatts(), this.energyStored);
            if (doProvide) {
                this.setEnergyStored(this.energyStored - requestedEnergy);
            }
            return ElectricityPack.getFromWatts(requestedEnergy, this.getVoltage());
        }
        return new ElectricityPack();
    }

    public ElectricityPack provideElectricity(float energy, boolean doProvide) {
        return this.provideElectricity(ElectricityPack.getFromWatts(energy, this.getVoltage()), doProvide);
    }

    @Override
    public void setEnergyStored(float energy) {
        this.energyStored = Math.max(Math.min(energy, this.getMaxEnergyStored()), 0.0f);
    }

    @Override
    public float getEnergyStored() {
        return this.energyStored;
    }

    public void setMaxEnergyStored(float maxEnergyStored) {
        this.maxEnergyStored = maxEnergyStored;
    }

    @Override
    public float getMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN)) {
            return false;
        }
        return this.getInputDirections().contains(direction) || this.getOutputDirections().contains(direction);
    }

    @Override
    public float getVoltage() {
        return 120.0f;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energyStored = nbt.func_74760_g("energyStored");
        this.maxEnergyStored = nbt.func_74760_g("maxEnergyStored");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74776_a("energyStored", this.energyStored);
        nbt.func_74776_a("maxEnergyStored", this.maxEnergyStored);
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.bcPowerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public World getWorld() {
        return this.func_70314_l();
    }
}

