/*
 * Decompiled with CFR 0.152.
 */
package mffs.base;

import calclavia.lib.gui.GuiContainerBase;
import cpw.mods.fml.common.network.PacketDispatcher;
import icbm.api.IBlockFrequency;
import java.util.HashMap;
import java.util.Map;
import mffs.MFFSHelper;
import mffs.api.IBiometricIdentifierLink;
import mffs.base.TileEntityMFFS;
import mffs.gui.button.GuiIcon;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.input.Keyboard;
import universalelectricity.core.vector.Vector2;
import universalelectricity.prefab.TranslationHelper;
import universalelectricity.prefab.network.PacketManager;
import universalelectricity.prefab.vector.Region2;

public class GuiMFFS
extends GuiContainerBase {
    protected GuiTextField textFieldFrequency;
    protected Vector2 textFieldPos = new Vector2();
    public String tooltip = "";
    protected IBlockFrequency frequencyTile;
    protected HashMap<Region2, String> tooltips = new HashMap();

    public GuiMFFS(Container container) {
        super(container);
        this.field_74195_c = 217;
    }

    public GuiMFFS(Container container, IBlockFrequency frequencyTile) {
        this(container);
        this.frequencyTile = frequencyTile;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_73887_h.clear();
        this.field_73887_h.add(new GuiIcon(0, this.field_73880_f / 2 - 82, this.field_73881_g / 2 - 104, new ItemStack(Block.field_72049_aP), new ItemStack(Block.field_72035_aQ)));
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.frequencyTile != null) {
            this.textFieldFrequency = new GuiTextField(this.field_73886_k, this.textFieldPos.intX(), this.textFieldPos.intY(), 50, 12);
            this.textFieldFrequency.func_73804_f(6);
            this.textFieldFrequency.func_73782_a(this.frequencyTile.getFrequency() + "");
        }
    }

    @Override
    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_73874_b();
    }

    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        if (this.textFieldFrequency != null) {
            this.textFieldFrequency.func_73802_a(par1, par2);
            try {
                int newFrequency = Math.max(0, Integer.parseInt(this.textFieldFrequency.func_73781_b()));
                this.frequencyTile.setFrequency(newFrequency);
                this.textFieldFrequency.func_73782_a(this.frequencyTile.getFrequency() + "");
                PacketDispatcher.sendPacketToServer((Packet)PacketManager.getPacket("MFFS", (TileEntity)this.frequencyTile, new Object[]{TileEntityMFFS.TilePacketType.FREQUENCY.ordinal(), this.frequencyTile.getFrequency()}));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void func_73875_a(GuiButton guiButton) {
        super.func_73875_a(guiButton);
        if (this.frequencyTile != null && guiButton.field_73741_f == 0) {
            PacketDispatcher.sendPacketToServer((Packet)PacketManager.getPacket("MFFS", (TileEntity)this.frequencyTile, new Object[]{TileEntityMFFS.TilePacketType.TOGGLE_ACTIVATION.ordinal()}));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textFieldFrequency != null && !this.textFieldFrequency.func_73806_l()) {
            this.textFieldFrequency.func_73782_a(this.frequencyTile.getFrequency() + "");
        }
        if (this.frequencyTile instanceof TileEntityMFFS && this.field_73887_h.size() > 0 && this.field_73887_h.get(0) != null) {
            ((GuiIcon)((Object)this.field_73887_h.get(0))).setIndex(((TileEntityMFFS)((Object)this.frequencyTile)).isActive() ? 1 : 0);
        }
    }

    public void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        if (this.textFieldFrequency != null) {
            this.textFieldFrequency.func_73793_a(x - this.containerWidth, y - this.containerHeight, par3);
        }
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        if (this.textFieldFrequency != null && this.func_74188_c(this.textFieldPos.intX(), this.textFieldPos.intY(), this.textFieldFrequency.func_73801_o(), 12, mouseX, mouseY)) {
            this.tooltip = TranslationHelper.getLocal("gui.frequency.tooltip");
        }
        for (Map.Entry<Region2, String> entry : this.tooltips.entrySet()) {
            if (!entry.getKey().isIn(new Vector2(mouseX - this.field_74198_m, mouseY - this.field_74197_n))) continue;
            this.tooltip = entry.getValue();
            break;
        }
        if (this.tooltip != null && this.tooltip != "") {
            this.drawTooltip(mouseX - this.field_74198_m, mouseY - this.field_74197_n, MFFSHelper.splitStringPerWord(this.tooltip, 5).toArray(new String[0]));
        }
        this.tooltip = "";
    }

    @Override
    protected void func_74185_a(float var1, int x, int y) {
        super.func_74185_a(var1, x, y);
        if (this.frequencyTile instanceof IBiometricIdentifierLink) {
            this.drawBulb(167, 4, ((IBiometricIdentifierLink)((Object)this.frequencyTile)).getBiometricIdentifier() != null);
        }
    }

    @Override
    protected void drawTextWithTooltip(String textName, String format, int x, int y, int mouseX, int mouseY) {
        this.drawTextWithTooltip(textName, format, x, y, mouseX, mouseY, 0x404040);
    }

    @Override
    protected void drawTextWithTooltip(String textName, String format, int x, int y, int mouseX, int mouseY, int color) {
        String name = TranslationHelper.getLocal("gui." + textName + ".name");
        String text = format.replaceAll("%1", name);
        this.field_73886_k.func_78276_b(text, x, y, color);
        String tooltip = TranslationHelper.getLocal("gui." + textName + ".tooltip");
        if (tooltip != null && tooltip != "" && this.func_74188_c(x, y, (int)((double)text.length() * 4.8), 12, mouseX, mouseY)) {
            this.tooltip = tooltip;
        }
    }

    @Override
    protected void drawTextWithTooltip(String textName, int x, int y, int mouseX, int mouseY) {
        this.drawTextWithTooltip(textName, "%1", x, y, mouseX, mouseY);
    }
}

