/*
 * Decompiled with CFR 0.152.
 */
package mffs;

import basiccomponents.common.BasicComponents;
import calclavia.lib.UniversalRecipes;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.logging.Logger;
import mffs.CommonProxy;
import mffs.Settings;
import mffs.SubscribeEventHandler;
import mffs.base.BlockBase;
import mffs.base.BlockMFFS;
import mffs.base.ItemMFFS;
import mffs.block.BlockBiometricIdentifier;
import mffs.block.BlockCoercionDeriver;
import mffs.block.BlockForceField;
import mffs.block.BlockForceFieldProjector;
import mffs.block.BlockForceManipulator;
import mffs.block.BlockFortronCapacitor;
import mffs.block.BlockInterdictionMatrix;
import mffs.card.ItemCard;
import mffs.fortron.FortronHelper;
import mffs.fortron.FrequencyGrid;
import mffs.item.ItemRemoteController;
import mffs.item.card.ItemCardFrequency;
import mffs.item.card.ItemCardID;
import mffs.item.card.ItemCardInfinite;
import mffs.item.card.ItemCardLink;
import mffs.item.mode.ItemMode;
import mffs.item.mode.ItemModeCube;
import mffs.item.mode.ItemModeSphere;
import mffs.item.mode.ItemModeTube;
import mffs.item.module.ItemModule;
import mffs.item.module.interdiction.ItemModuleAntiFriendly;
import mffs.item.module.interdiction.ItemModuleAntiHostile;
import mffs.item.module.interdiction.ItemModuleAntiPersonnel;
import mffs.item.module.interdiction.ItemModuleConfiscate;
import mffs.item.module.interdiction.ItemModuleInterdictionMatrix;
import mffs.item.module.interdiction.ItemModuleWarn;
import mffs.item.module.projector.ItemModeCustom;
import mffs.item.module.projector.ItemModeCylinder;
import mffs.item.module.projector.ItemModePyramid;
import mffs.item.module.projector.ItemModuleDisintegration;
import mffs.item.module.projector.ItemModuleFusion;
import mffs.item.module.projector.ItemModuleManipulator;
import mffs.item.module.projector.ItemModuleShock;
import mffs.item.module.projector.ItemModuleSponge;
import mffs.item.module.projector.ItemModuleStablize;
import mffs.tileentity.TileEntityBiometricIdentifier;
import mffs.tileentity.TileEntityCoercionDeriver;
import mffs.tileentity.TileEntityForceField;
import mffs.tileentity.TileEntityForceFieldProjector;
import mffs.tileentity.TileEntityForceManipulator;
import mffs.tileentity.TileEntityFortronCapacitor;
import mffs.tileentity.TileEntityInterdictionMatrix;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.modstats.ModstatInfo;
import org.modstats.Modstats;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.prefab.CustomDamageSource;
import universalelectricity.prefab.RecipeHelper;
import universalelectricity.prefab.TranslationHelper;
import universalelectricity.prefab.network.PacketManager;

@Mod(modid="MFFS", name="Modular Force Field System", version="3.2.0", useMetadata=true)
@NetworkMod(clientSideRequired=true, channels={"MFFS"}, packetHandler=PacketManager.class)
@ModstatInfo(prefix="mffs")
public class ModularForceFieldSystem {
    public static final String CHANNEL = "MFFS";
    public static final String ID = "MFFS";
    public static final String NAME = "Modular Force Field System";
    public static final String DOMAIN = "mffs";
    public static final String PREFIX = "mffs:";
    public static final String MAJOR_VERSION = "3";
    public static final String MINOR_VERSION = "2";
    public static final String REVISION_VERSION = "0";
    public static final String VERSION = "3.2.0";
    public static final String BUILD_VERSION = "211";
    @Mod.Instance(value="MFFS")
    public static ModularForceFieldSystem instance;
    @Mod.Metadata(value="MFFS")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="mffs.ClientProxy", serverSide="mffs.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger LOGGER;
    public static final String RESOURCE_DIRECTORY = "/assets/mffs/";
    public static final String LANGUAGE_DIRECTORY = "/assets/mffs/languages/";
    public static final String TEXTURE_DIRECTORY = "textures/";
    public static final String BLOCK_DIRECTORY = "textures/blocks/";
    public static final String ITEM_DIRECTORY = "textures/items/";
    public static final String MODEL_DIRECTORY = "textures/models/";
    public static final String GUI_DIRECTORY = "textures/gui/";
    public static final ResourceLocation GUI_BUTTON;
    public static final ResourceLocation HOLOGAM_TEXTURE;
    public static BlockMFFS blockCoercionDeriver;
    public static BlockMFFS blockFortronCapacitor;
    public static BlockMFFS blockForceFieldProjector;
    public static BlockMFFS blockBiometricIdentifier;
    public static BlockMFFS blockInterdictionMatrix;
    public static BlockMFFS blockForceManipulator;
    public static BlockBase blockForceField;
    public static Item itemFortron;
    public static Item itemRemoteController;
    public static Item itemFocusMatix;
    public static ItemCard itemCardBlank;
    public static ItemCard itemCardInfinite;
    public static ItemCard itemCardFrequency;
    public static ItemCard itemCardID;
    public static ItemCard itemCardLink;
    public static ItemMode itemModeCube;
    public static ItemMode itemModeSphere;
    public static ItemMode itemModeTube;
    public static ItemMode itemModeCylinder;
    public static ItemMode itemModePyramid;
    public static ItemMode itemModeCustom;
    public static ItemModule itemModule;
    public static ItemModule itemModuleSpeed;
    public static ItemModule itemModuleCapacity;
    public static ItemModule itemModuleTranslate;
    public static ItemModule itemModuleScale;
    public static ItemModule itemModuleRotate;
    public static ItemModule itemModuleCollection;
    public static ItemModule itemModuleInvert;
    public static ItemModule itemModuleSilence;
    public static ItemModule itemModuleFusion;
    public static ItemModule itemModuleManipulator;
    public static ItemModule itemModuleCamouflage;
    public static ItemModule itemModuleDisintegration;
    public static ItemModule itemModuleShock;
    public static ItemModule itemModuleGlow;
    public static ItemModule itemModuleSponge;
    public static ItemModule itemModuleStablize;
    public static ItemModule itemModuleAntiHostile;
    public static ItemModule itemModuleAntiFriendly;
    public static ItemModule itemModuleAntiPersonnel;
    public static ItemModule itemModuleConfiscate;
    public static ItemModule itemModuleWarn;
    public static ItemModule itemModuleBlockAccess;
    public static ItemModule itemModuleBlockAlter;
    public static ItemModule itemModuleAntiSpawn;
    public static DamageSource damagefieldShock;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.setParent(FMLLog.getLogger());
        Modstats.instance().getReporter().registerMod(this);
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)new SubscribeEventHandler());
        Compatibility.initiate();
        Settings.load();
        Settings.CONFIGURATION.load();
        blockForceField = new BlockForceField(Settings.getNextBlockID());
        blockCoercionDeriver = new BlockCoercionDeriver(Settings.getNextBlockID());
        blockFortronCapacitor = new BlockFortronCapacitor(Settings.getNextBlockID());
        blockForceFieldProjector = new BlockForceFieldProjector(Settings.getNextBlockID());
        blockBiometricIdentifier = new BlockBiometricIdentifier(Settings.getNextBlockID());
        blockInterdictionMatrix = new BlockInterdictionMatrix(Settings.getNextBlockID());
        blockForceManipulator = new BlockForceManipulator(Settings.getNextBlockID());
        itemRemoteController = new ItemRemoteController(Settings.getNextItemID());
        itemFocusMatix = new ItemMFFS(Settings.getNextItemID(), "focusMatrix");
        itemModeCube = new ItemModeCube(Settings.getNextItemID());
        itemModeSphere = new ItemModeSphere(Settings.getNextItemID());
        itemModeTube = new ItemModeTube(Settings.getNextItemID());
        itemModePyramid = new ItemModePyramid(Settings.getNextItemID());
        itemModeCylinder = new ItemModeCylinder(Settings.getNextItemID());
        itemModeCustom = new ItemModeCustom(Settings.getNextItemID());
        itemModuleTranslate = new ItemModule(Settings.getNextItemID(), "moduleTranslate").setCost(1.6f);
        itemModuleScale = new ItemModule(Settings.getNextItemID(), "moduleScale").setCost(1.2f);
        itemModuleRotate = new ItemModule(Settings.getNextItemID(), "moduleRotate").setCost(0.1f);
        itemModuleSpeed = new ItemModule(Settings.getNextItemID(), "moduleSpeed").setCost(1.0f);
        itemModuleCapacity = new ItemModule(Settings.getNextItemID(), "moduleCapacity").setCost(0.5f);
        itemModuleFusion = new ItemModuleFusion(Settings.getNextItemID());
        itemModuleManipulator = new ItemModuleManipulator(Settings.getNextItemID());
        itemModuleCamouflage = new ItemModule(Settings.getNextItemID(), "moduleCamouflage").setCost(1.5f).setMaxStackSize(1);
        itemModuleDisintegration = new ItemModuleDisintegration(Settings.getNextItemID());
        itemModuleShock = new ItemModuleShock(Settings.getNextItemID());
        itemModuleGlow = new ItemModule(Settings.getNextItemID(), "moduleGlow");
        itemModuleSponge = new ItemModuleSponge(Settings.getNextItemID());
        itemModuleStablize = new ItemModuleStablize(Settings.getNextItemID());
        itemCardBlank = new ItemCard(Settings.getNextItemID(), "cardBlank");
        itemCardFrequency = new ItemCardFrequency(Settings.getNextItemID());
        itemCardLink = new ItemCardLink(Settings.getNextItemID());
        itemCardID = new ItemCardID(Settings.getNextItemID());
        itemCardInfinite = new ItemCardInfinite(Settings.getNextItemID());
        itemModuleAntiFriendly = new ItemModuleAntiFriendly(Settings.getNextItemID());
        itemModuleAntiHostile = new ItemModuleAntiHostile(Settings.getNextItemID());
        itemModuleAntiPersonnel = new ItemModuleAntiPersonnel(Settings.getNextItemID());
        itemModuleConfiscate = new ItemModuleConfiscate(Settings.getNextItemID());
        itemModuleWarn = new ItemModuleWarn(Settings.getNextItemID());
        itemModuleBlockAccess = new ItemModuleInterdictionMatrix(Settings.getNextItemID(), "moduleBlockAccess").setCost(10.0f);
        itemModuleBlockAlter = new ItemModuleInterdictionMatrix(Settings.getNextItemID(), "moduleBlockAlter").setCost(15.0f);
        itemModuleAntiSpawn = new ItemModuleInterdictionMatrix(Settings.getNextItemID(), "moduleAntiSpawn").setCost(10.0f);
        itemModuleCollection = new ItemModule(Settings.getNextItemID(), "moduleCollection").setMaxStackSize(1).setCost(15.0f);
        itemModuleInvert = new ItemModule(Settings.getNextItemID(), "moduleInvert").setMaxStackSize(1).setCost(15.0f);
        itemModuleSilence = new ItemModule(Settings.getNextItemID(), "moduleSilence").setMaxStackSize(1).setCost(1.0f);
        itemFortron = new ItemMFFS(Settings.getNextItemID(), "fortron").func_77637_a(null);
        FluidRegistry.registerFluid((Fluid)new Fluid("fortron"));
        FortronHelper.FLUID_FORTRON = new FluidStack(FluidRegistry.getFluidID((String)"fortron"), 0);
        Settings.CONFIGURATION.save();
        GameRegistry.registerBlock((Block)blockForceField, (String)blockForceField.func_71917_a());
        GameRegistry.registerBlock((Block)blockCoercionDeriver, (String)blockCoercionDeriver.func_71917_a());
        GameRegistry.registerBlock((Block)blockFortronCapacitor, (String)blockFortronCapacitor.func_71917_a());
        GameRegistry.registerBlock((Block)blockForceFieldProjector, (String)blockForceFieldProjector.func_71917_a());
        GameRegistry.registerBlock((Block)blockBiometricIdentifier, (String)blockBiometricIdentifier.func_71917_a());
        GameRegistry.registerBlock((Block)blockInterdictionMatrix, (String)blockInterdictionMatrix.func_71917_a());
        GameRegistry.registerBlock((Block)blockForceManipulator, (String)blockForceManipulator.func_71917_a());
        GameRegistry.registerTileEntity(TileEntityForceField.class, (String)blockForceField.func_71917_a());
        GameRegistry.registerTileEntity(TileEntityCoercionDeriver.class, (String)blockCoercionDeriver.func_71917_a());
        GameRegistry.registerTileEntity(TileEntityFortronCapacitor.class, (String)blockFortronCapacitor.func_71917_a());
        GameRegistry.registerTileEntity(TileEntityForceFieldProjector.class, (String)blockForceFieldProjector.func_71917_a());
        GameRegistry.registerTileEntity(TileEntityBiometricIdentifier.class, (String)blockBiometricIdentifier.func_71917_a());
        GameRegistry.registerTileEntity(TileEntityInterdictionMatrix.class, (String)blockInterdictionMatrix.func_71917_a());
        GameRegistry.registerTileEntity(TileEntityForceManipulator.class, (String)blockForceManipulator.func_71917_a());
        proxy.preInit();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        BasicComponents.register("MFFS");
        BasicComponents.requestItem("ingotSteel", 0);
        BasicComponents.requestItem("dustSteel", 0);
        BasicComponents.requestItem("ingotCopper", 0);
        BasicComponents.requestBlock("oreCopper", 0);
        BasicComponents.requestBlock("copperWire", 0);
        BasicComponents.requestItem("wrench", 0);
        LOGGER.fine("Language(s) Loaded: " + TranslationHelper.loadLanguages(LANGUAGE_DIRECTORY, new String[]{"en_US", "zh_CN", "de_DE"}));
        ModularForceFieldSystem.metadata.modId = "MFFS";
        ModularForceFieldSystem.metadata.name = NAME;
        ModularForceFieldSystem.metadata.description = "Modular Force Field System is a mod that adds force fields, high tech machinery and defensive measures to Minecraft.";
        ModularForceFieldSystem.metadata.url = "http://www.universalelectricity.com/mffs/";
        ModularForceFieldSystem.metadata.logoFile = "/mffs_logo.png";
        ModularForceFieldSystem.metadata.version = "3.2.0.211";
        ModularForceFieldSystem.metadata.authorList = Arrays.asList("Calclavia");
        ModularForceFieldSystem.metadata.credits = "Please visit the website.";
        ModularForceFieldSystem.metadata.autogenerated = false;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        UniversalRecipes.init();
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemFocusMatix, 9), new Object[]{"RMR", "MDM", "RMR", Character.valueOf('M'), "ingotSteel", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemRemoteController), new Object[]{"WWW", "MCM", "MCM", Character.valueOf('W'), "calclavia:WIRE", Character.valueOf('C'), UniversalRecipes.BATTERY, Character.valueOf('M'), "ingotSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)blockCoercionDeriver), new Object[]{"M M", "MFM", "MCM", Character.valueOf('C'), UniversalRecipes.BATTERY, Character.valueOf('M'), "ingotSteel", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)blockFortronCapacitor), new Object[]{"MFM", "FCF", "MFM", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('C'), UniversalRecipes.BATTERY, Character.valueOf('F'), itemFocusMatix, Character.valueOf('M'), "ingotSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)blockForceFieldProjector), new Object[]{" D ", "FFF", "MCM", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('C'), UniversalRecipes.BATTERY, Character.valueOf('F'), itemFocusMatix, Character.valueOf('M'), "ingotSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)blockBiometricIdentifier), new Object[]{"FMF", "MCM", "FMF", Character.valueOf('C'), itemCardBlank, Character.valueOf('M'), "ingotSteel", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)blockInterdictionMatrix), new Object[]{"SSS", "FFF", "FEF", Character.valueOf('S'), itemModuleShock, Character.valueOf('E'), Block.field_72066_bS, Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)blockForceManipulator), new Object[]{"F F", "FMF", "F F", Character.valueOf('F'), itemFocusMatix, Character.valueOf('M'), "calclavia:MOTOR"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemCardBlank), new Object[]{"PPP", "PMP", "PPP", Character.valueOf('P'), Item.field_77759_aK, Character.valueOf('M'), "ingotSteel"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemCardLink), new Object[]{"BWB", Character.valueOf('B'), itemCardBlank, Character.valueOf('W'), "calclavia:WIRE"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemCardFrequency), new Object[]{"WBW", Character.valueOf('B'), itemCardBlank, Character.valueOf('W'), "calclavia:WIRE"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemCardID), new Object[]{"RBR", Character.valueOf('B'), itemCardBlank, Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModeSphere), new Object[]{" F ", "FFF", " F ", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModeCube), new Object[]{"FFF", "FFF", "FFF", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModeTube), new Object[]{"FFF", "   ", "FFF", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModePyramid), new Object[]{"F  ", "FF ", "FFF", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModeCylinder), new Object[]{"S", "S", "S", Character.valueOf('S'), itemModeSphere}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModeCustom), new Object[]{" C ", "TFP", " S ", Character.valueOf('S'), itemModeSphere, Character.valueOf('C'), itemModeCube, Character.valueOf('T'), itemModeTube, Character.valueOf('P'), itemModePyramid, Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Item)itemModeCustom), new Object[]{new ItemStack((Item)itemModeCustom)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleSpeed, 2), new Object[]{"FFF", "RRR", "FFF", Character.valueOf('F'), itemFocusMatix, Character.valueOf('R'), Item.field_77767_aC}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleCapacity, 2), new Object[]{"FCF", Character.valueOf('F'), itemFocusMatix, Character.valueOf('C'), UniversalRecipes.BATTERY}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleShock), new Object[]{"FWF", Character.valueOf('F'), itemFocusMatix, Character.valueOf('W'), "calclavia:WIRE"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleSponge), new Object[]{"BBB", "BFB", "BBB", Character.valueOf('F'), itemFocusMatix, Character.valueOf('B'), Item.field_77786_ax}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleDisintegration), new Object[]{" W ", "FBF", " W ", Character.valueOf('F'), itemFocusMatix, Character.valueOf('W'), "calclavia:WIRE", Character.valueOf('B'), UniversalRecipes.BATTERY}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleManipulator), new Object[]{"F", " ", "F", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleCamouflage), new Object[]{"WFW", "FWF", "WFW", Character.valueOf('F'), itemFocusMatix, Character.valueOf('W'), new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleFusion), new Object[]{"FJF", Character.valueOf('F'), itemFocusMatix, Character.valueOf('J'), itemModuleShock}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleScale, 2), new Object[]{"FRF", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleTranslate, 2), new Object[]{"FSF", Character.valueOf('F'), itemFocusMatix, Character.valueOf('S'), itemModuleScale}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleRotate, 4), new Object[]{"F  ", " F ", "  F", Character.valueOf('F'), itemFocusMatix}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleGlow, 4), new Object[]{"GGG", "GFG", "GGG", Character.valueOf('F'), itemFocusMatix, Character.valueOf('G'), Block.field_72014_bd}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleStablize), new Object[]{"FDF", "PSA", "FDF", Character.valueOf('F'), itemFocusMatix, Character.valueOf('P'), Item.field_77674_B, Character.valueOf('S'), Item.field_77673_A, Character.valueOf('A'), Item.field_77675_C, Character.valueOf('D'), Item.field_77702_n}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleCollection), new Object[]{"F F", " H ", "F F", Character.valueOf('F'), itemFocusMatix, Character.valueOf('H'), Block.field_94340_cs}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleInvert), new Object[]{"L", "F", "L", Character.valueOf('F'), itemFocusMatix, Character.valueOf('L'), Block.field_71948_O}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleSilence), new Object[]{" N ", "NFN", " N ", Character.valueOf('F'), itemFocusMatix, Character.valueOf('N'), Block.field_71960_R}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleAntiHostile), new Object[]{" R ", "GFB", " S ", Character.valueOf('F'), itemFocusMatix, Character.valueOf('G'), Item.field_77677_M, Character.valueOf('R'), Item.field_77737_bm, Character.valueOf('B'), Item.field_77755_aX, Character.valueOf('S'), Item.field_77732_bp}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleAntiFriendly), new Object[]{" R ", "GFB", " S ", Character.valueOf('F'), itemFocusMatix, Character.valueOf('G'), Item.field_77782_ar, Character.valueOf('R'), new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE), Character.valueOf('B'), Item.field_77770_aF, Character.valueOf('S'), Item.field_77761_aM}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleAntiPersonnel), new Object[]{"BFG", Character.valueOf('F'), itemFocusMatix, Character.valueOf('B'), itemModuleAntiHostile, Character.valueOf('G'), itemModuleAntiFriendly}));
        RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleConfiscate), new Object[]{"PEP", "EFE", "PEP", Character.valueOf('F'), itemFocusMatix, Character.valueOf('E'), Item.field_77748_bA, Character.valueOf('P'), Item.field_77730_bn}), Settings.CONFIGURATION, true);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleWarn), new Object[]{"NFN", Character.valueOf('F'), itemFocusMatix, Character.valueOf('N'), Block.field_71960_R}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleBlockAccess), new Object[]{" C ", "BFB", " C ", Character.valueOf('F'), itemFocusMatix, Character.valueOf('B'), Block.field_72083_ai, Character.valueOf('C'), Block.field_72077_au}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleBlockAlter), new Object[]{" G ", "GFG", " G ", Character.valueOf('F'), itemModuleBlockAccess, Character.valueOf('G'), Block.field_72105_ah}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)itemModuleAntiSpawn), new Object[]{" H ", "G G", " H ", Character.valueOf('H'), itemModuleAntiHostile, Character.valueOf('G'), itemModuleAntiFriendly}));
        proxy.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        FrequencyGrid.reinitiate();
    }

    static {
        LOGGER = Logger.getLogger(NAME);
        GUI_BUTTON = new ResourceLocation(DOMAIN, "textures/gui/gui_button.png");
        HOLOGAM_TEXTURE = new ResourceLocation(DOMAIN, "textures/blocks/forceField.png");
        damagefieldShock = new CustomDamageSource("fieldShock").func_76348_h();
    }
}

