/*
 * Decompiled with CFR 0.152.
 */
package mffs;

import icbm.api.IBlockFrequency;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import mffs.ModularForceFieldSystem;
import mffs.TransferMode;
import mffs.api.IProjector;
import mffs.api.fortron.IFortronFrequency;
import mffs.api.modules.IModuleAcceptor;
import mffs.api.security.IInterdictionMatrix;
import mffs.api.security.Permission;
import mffs.fortron.FrequencyGrid;
import mffs.item.module.projector.ItemModeCustom;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import universalelectricity.core.vector.Vector3;

public class MFFSHelper {
    public static void transferFortron(IFortronFrequency transferer, Set<IFortronFrequency> frequencyTiles, TransferMode transferMode, int limit) {
        if (transferer != null && frequencyTiles.size() > 1) {
            int totalFortron = 0;
            int totalCapacity = 0;
            for (IFortronFrequency machine : frequencyTiles) {
                if (machine == null) continue;
                totalFortron += machine.getFortronEnergy();
                totalCapacity += machine.getFortronCapacity();
            }
            if (totalFortron > 0 && totalCapacity > 0) {
                switch (transferMode) {
                    case EQUALIZE: {
                        for (IFortronFrequency machine : frequencyTiles) {
                            if (machine == null) continue;
                            double capacityPercentage = (double)machine.getFortronCapacity() / (double)totalCapacity;
                            int amountToSet = (int)((double)totalFortron * capacityPercentage);
                            MFFSHelper.doTransferFortron(transferer, machine, amountToSet - machine.getFortronEnergy(), limit);
                        }
                        break;
                    }
                    case DISTRIBUTE: {
                        int amountToSet = totalFortron / frequencyTiles.size();
                        for (IFortronFrequency machine : frequencyTiles) {
                            if (machine == null) continue;
                            MFFSHelper.doTransferFortron(transferer, machine, amountToSet - machine.getFortronEnergy(), limit);
                        }
                        break;
                    }
                    case DRAIN: {
                        frequencyTiles.remove(transferer);
                        for (IFortronFrequency machine : frequencyTiles) {
                            double capacityPercentage;
                            int amountToSet;
                            if (machine == null || (amountToSet = (int)((double)totalFortron * (capacityPercentage = (double)machine.getFortronCapacity() / (double)totalCapacity))) - machine.getFortronEnergy() <= 0) continue;
                            MFFSHelper.doTransferFortron(transferer, machine, amountToSet - machine.getFortronEnergy(), limit);
                        }
                        break;
                    }
                    case FILL: {
                        if (transferer.getFortronEnergy() >= transferer.getFortronCapacity()) break;
                        frequencyTiles.remove(transferer);
                        int requiredFortron = transferer.getFortronCapacity() - transferer.getFortronEnergy();
                        for (IFortronFrequency machine : frequencyTiles) {
                            if (machine == null) continue;
                            int amountToConsume = Math.min(requiredFortron, machine.getFortronEnergy());
                            int amountToSet = -machine.getFortronEnergy() - amountToConsume;
                            if (amountToConsume <= 0) continue;
                            MFFSHelper.doTransferFortron(transferer, machine, amountToSet - machine.getFortronEnergy(), limit);
                        }
                        break;
                    }
                }
            }
        }
    }

    public static void doTransferFortron(IFortronFrequency transferer, IFortronFrequency receiver, int joules, int limit) {
        if (transferer != null && receiver != null) {
            TileEntity tileEntity = (TileEntity)transferer;
            World world = tileEntity.field_70331_k;
            boolean isCamo = false;
            if (transferer instanceof IModuleAcceptor) {
                boolean bl = isCamo = ((IModuleAcceptor)((Object)transferer)).getModuleCount(ModularForceFieldSystem.itemModuleCamouflage, new int[0]) > 0;
            }
            if (joules > 0) {
                joules = Math.min(joules, limit);
                int toBeInjected = receiver.provideFortron(transferer.requestFortron(joules, false), false);
                toBeInjected = transferer.requestFortron(receiver.provideFortron(toBeInjected, true), true);
                if (world.field_72995_K && toBeInjected > 0 && !isCamo) {
                    ModularForceFieldSystem.proxy.renderBeam(world, Vector3.add(new Vector3(tileEntity), 0.5), Vector3.add(new Vector3((TileEntity)receiver), 0.5), 0.6f, 0.6f, 1.0f, 20);
                }
            } else {
                joules = Math.min(Math.abs(joules), limit);
                int toBeEjected = transferer.provideFortron(receiver.requestFortron(joules, false), false);
                toBeEjected = receiver.requestFortron(transferer.provideFortron(toBeEjected, true), true);
                if (world.field_72995_K && toBeEjected > 0 && !isCamo) {
                    ModularForceFieldSystem.proxy.renderBeam(world, Vector3.add(new Vector3((TileEntity)receiver), 0.5), Vector3.add(new Vector3(tileEntity), 0.5), 0.6f, 0.6f, 1.0f, 20);
                }
            }
        }
    }

    public static IInterdictionMatrix getNearestInterdictionMatrix(World world, Vector3 position) {
        for (IBlockFrequency frequencyTile : FrequencyGrid.instance().get()) {
            IInterdictionMatrix interdictionMatrix;
            if (((TileEntity)frequencyTile).field_70331_k != world || !(frequencyTile instanceof IInterdictionMatrix) || !(interdictionMatrix = (IInterdictionMatrix)frequencyTile).isActive()) continue;
            Vector3 vector3 = new Vector3((TileEntity)interdictionMatrix);
            if (!(position.distanceTo(vector3) <= (double)interdictionMatrix.getActionRange())) continue;
            return interdictionMatrix;
        }
        return null;
    }

    public static boolean isPermittedByInterdictionMatrix(IInterdictionMatrix interdictionMatrix, String username, Permission ... permissions) {
        if (interdictionMatrix != null && interdictionMatrix.isActive() && interdictionMatrix.getBiometricIdentifier() != null) {
            for (Permission permission : permissions) {
                if (interdictionMatrix.getBiometricIdentifier().isAccessGranted(username, permission)) continue;
                return interdictionMatrix.getModuleCount(ModularForceFieldSystem.itemModuleInvert, new int[0]) > 0;
            }
        }
        return interdictionMatrix.getModuleCount(ModularForceFieldSystem.itemModuleInvert, new int[0]) <= 0;
    }

    public static List<String> splitStringPerWord(String string, int wordsPerLine) {
        String[] words = string.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        int lineCount = 0;
        while ((double)lineCount < Math.ceil((float)words.length / (float)wordsPerLine)) {
            String stringInLine = "";
            for (int i = lineCount * wordsPerLine; i < Math.min(wordsPerLine + lineCount * wordsPerLine, words.length); ++i) {
                stringInLine = stringInLine + words[i] + " ";
            }
            lines.add(stringInLine.trim());
            ++lineCount;
        }
        return lines;
    }

    public static ItemStack getFirstItemBlock(TileEntity tileEntity, ItemStack itemStack) {
        return MFFSHelper.getFirstItemBlock(tileEntity, itemStack, true);
    }

    public static ItemStack getFirstItemBlock(TileEntity tileEntity, ItemStack itemStack, boolean recur) {
        ItemStack checkStack;
        if (tileEntity instanceof IProjector) {
            for (int i : ((IProjector)tileEntity).getModuleSlots()) {
                checkStack = MFFSHelper.getFirstItemBlock(i, (IProjector)tileEntity, itemStack);
                if (checkStack == null) continue;
                return checkStack;
            }
        } else if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack checkStack2 = MFFSHelper.getFirstItemBlock(i, inventory, itemStack);
                if (checkStack2 == null) continue;
                return checkStack2;
            }
        }
        if (recur) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                Vector3 vector = new Vector3(tileEntity);
                vector.modifyPositionFromSide(direction);
                TileEntity checkTile = vector.getTileEntity((IBlockAccess)tileEntity.field_70331_k);
                if (checkTile == null || (checkStack = MFFSHelper.getFirstItemBlock(checkTile, itemStack, false)) == null) continue;
                return checkStack;
            }
        }
        return null;
    }

    public static ItemStack getFirstItemBlock(int i, IInventory inventory, ItemStack itemStack) {
        ItemStack checkStack = inventory.func_70301_a(i);
        if (checkStack != null && checkStack.func_77973_b() instanceof ItemBlock && (itemStack == null || checkStack.func_77969_a(itemStack))) {
            return checkStack;
        }
        return null;
    }

    public static Block getFilterBlock(ItemStack itemStack) {
        Block block;
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemStack.func_77973_b()).func_77883_f() < Block.field_71973_m.length && (block = Block.field_71973_m[((ItemBlock)itemStack.func_77973_b()).func_77883_f()]).func_71886_c()) {
            return block;
        }
        return null;
    }

    public static ItemStack getCamoBlock(IProjector projector, Vector3 position) {
        if (projector != null && !((TileEntity)projector).field_70331_k.field_72995_K && projector != null && projector.getModuleCount(ModularForceFieldSystem.itemModuleCamouflage, new int[0]) > 0) {
            HashMap<Vector3, int[]> fieldMap;
            if (projector.getMode() instanceof ItemModeCustom && (fieldMap = ((ItemModeCustom)projector.getMode()).getFieldBlockMap(projector, projector.getModeStack())) != null) {
                Vector3 fieldCenter = new Vector3((TileEntity)projector).add(projector.getTranslation());
                Vector3 relativePosition = position.clone().subtract(fieldCenter);
                relativePosition.rotate((double)(-projector.getRotationYaw()), -projector.getRotationPitch());
                int[] blockInfo = fieldMap.get(relativePosition.round());
                if (blockInfo != null && blockInfo[0] > 0) {
                    return new ItemStack(Block.field_71973_m[blockInfo[0]], 1, blockInfo[1]);
                }
            }
            for (int i : projector.getModuleSlots()) {
                ItemStack checkStack = projector.func_70301_a(i);
                Block block = MFFSHelper.getFilterBlock(checkStack);
                if (block == null) continue;
                return checkStack;
            }
        }
        return null;
    }

    public static NBTTagCompound getNBTTagCompound(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            return itemStack.func_77978_p();
        }
        return null;
    }

    public static boolean hasPermission(World world, Vector3 position, Permission permission, EntityPlayer player) {
        IInterdictionMatrix interdictionMatrix = MFFSHelper.getNearestInterdictionMatrix(world, position);
        if (interdictionMatrix != null) {
            return MFFSHelper.isPermittedByInterdictionMatrix(interdictionMatrix, player.field_71092_bJ, permission);
        }
        return true;
    }

    public static boolean hasPermission(World world, Vector3 position, PlayerInteractEvent.Action action, EntityPlayer player) {
        IInterdictionMatrix interdictionMatrix = MFFSHelper.getNearestInterdictionMatrix(world, position);
        if (interdictionMatrix != null) {
            return MFFSHelper.hasPermission(world, position, interdictionMatrix, action, player);
        }
        return true;
    }

    public static boolean hasPermission(World world, Vector3 position, IInterdictionMatrix interdictionMatrix, PlayerInteractEvent.Action action, EntityPlayer player) {
        boolean hasPermission = true;
        if (action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && position.getTileEntity((IBlockAccess)world) != null && interdictionMatrix.getModuleCount(ModularForceFieldSystem.itemModuleBlockAccess, new int[0]) > 0) {
            hasPermission = false;
            if (MFFSHelper.isPermittedByInterdictionMatrix(interdictionMatrix, player.field_71092_bJ, Permission.BLOCK_ACCESS)) {
                hasPermission = true;
            }
        }
        if (hasPermission && interdictionMatrix.getModuleCount(ModularForceFieldSystem.itemModuleBlockAlter, new int[0]) > 0 && (player.func_71045_bC() != null || action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
            hasPermission = false;
            if (MFFSHelper.isPermittedByInterdictionMatrix(interdictionMatrix, player.field_71092_bJ, Permission.BLOCK_ALTER)) {
                hasPermission = true;
            }
        }
        return hasPermission;
    }
}

