/*
 * Decompiled with CFR 0.152.
 */
package basiccomponents.common;

import basiccomponents.client.RenderCopperWire;
import basiccomponents.common.BCGuiHandler;
import basiccomponents.common.block.BlockBase;
import basiccomponents.common.block.BlockBasicMachine;
import basiccomponents.common.block.BlockCopperWire;
import basiccomponents.common.item.ItemBase;
import basiccomponents.common.item.ItemBattery;
import basiccomponents.common.item.ItemBlockBasicMachine;
import basiccomponents.common.item.ItemBlockCopperWire;
import basiccomponents.common.item.ItemInfiniteBattery;
import basiccomponents.common.item.ItemIngot;
import basiccomponents.common.item.ItemPlate;
import basiccomponents.common.item.ItemWrench;
import basiccomponents.common.tileentity.TileEntityBatteryBox;
import basiccomponents.common.tileentity.TileEntityCoalGenerator;
import basiccomponents.common.tileentity.TileEntityCopperWire;
import basiccomponents.common.tileentity.TileEntityElectricFurnace;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.item.ElectricItemHelper;
import universalelectricity.prefab.ConductorChunkInitiate;
import universalelectricity.prefab.RecipeHelper;
import universalelectricity.prefab.TranslationHelper;
import universalelectricity.prefab.ore.OreGenBase;
import universalelectricity.prefab.ore.OreGenReplaceStone;
import universalelectricity.prefab.ore.OreGenerator;

public class BasicComponents {
    public static final String NAME = "Basic Components";
    public static String CHANNEL = "";
    public static final String RESOURCE_PATH = "/assets/basiccomponents/";
    public static final Configuration CONFIGURATION = new Configuration(new File(Loader.instance().getConfigDir(), "BasicComponents.cfg"));
    public static final String TEXTURE_DIRECTORY = "/assets/basiccomponents/textures/";
    public static final String GUI_DIRECTORY = "/assets/basiccomponents/textures/gui/";
    public static final String BLOCK_TEXTURE_DIRECTORY = "/assets/basiccomponents/textures/blocks/";
    public static final String ITEM_TEXTURE_DIRECTORY = "/assets/basiccomponents/textures/items/";
    public static final String MODEL_TEXTURE_DIRECTORY = "/assets/basiccomponents/textures/models/";
    public static final String TEXTURE_DOMAIN = "basiccomponents";
    public static final String TEXTURE_NAME_PREFIX = "basiccomponents:";
    public static final String LANGUAGE_PATH = "/assets/basiccomponents/languages/";
    private static final String[] LANGUAGES_SUPPORTED = new String[]{"en_US", "zh_CN", "es_ES", "it_IT", "nl_NL", "de_DE"};
    public static final int BLOCK_ID_PREFIX = 3970;
    public static final int ITEM_ID_PREFIX = 13970;
    public static Block blockOreCopper;
    public static final int idOreCopper = 3970;
    public static Block blockOreTin;
    public static final int idOreTin = 3971;
    public static Block blockCopperWire;
    public static final int idCopperWire = 3972;
    public static Block blockMachine;
    public static final int idMachine = 3973;
    public static Item itemBattery;
    public static final int idBattery = 13970;
    public static Item itemInfiniteBattery;
    public static final int idInfiniteBattery = 13971;
    public static Item itemWrench;
    public static final int idWrench = 13972;
    public static Item itemMotor;
    public static final int idMotor = 13973;
    public static Item itemCircuitBasic;
    public static final int idCircuitBasic = 13974;
    public static Item itemCircuitAdvanced;
    public static final int idCircuitAdvanced = 13975;
    public static Item itemCircuitElite;
    public static final int idCircuitElite = 13976;
    public static Item itemPlateCopper;
    public static final int idPlateCopper = 13977;
    public static Item itemPlateTin;
    public static final int idPlateTin = 13978;
    public static Item itemPlateBronze;
    public static final int idPlateBronze = 13979;
    public static Item itemPlateSteel;
    public static final int idPlateSteel = 13980;
    public static Item itemPlateIron;
    public static final int idPlateIron = 13981;
    public static Item itemPlateGold;
    public static final int idPlateGold = 13982;
    public static Item itemIngotCopper;
    public static final int idIngotCopper = 13983;
    public static Item itemIngotTin;
    public static final int idIngotTin = 13984;
    public static Item itemIngotSteel;
    public static final int idIngotSteel = 13985;
    public static Item itemIngotBronze;
    public static final int idIngotBronze = 13986;
    public static Item itemDustSteel;
    public static final int idDustSteel = 13987;
    public static Item itemDustBronze;
    public static final int idDustBronze = 13988;
    public static OreGenBase generationOreCopper;
    public static OreGenBase generationOreTin;
    public static boolean INITIALIZED;
    private static boolean registeredTileEntities;
    public static final ArrayList bcDependants;

    public static void init() {
        if (!INITIALIZED) {
            System.out.println("Basic Components Loaded: " + TranslationHelper.loadLanguages(LANGUAGE_PATH, LANGUAGES_SUPPORTED) + " Languages.");
            INITIALIZED = true;
        }
    }

    public static Item requireItem(String name, int id) {
        BasicComponents.init();
        try {
            Field field = ReflectionHelper.findField(BasicComponents.class, (String[])new String[]{"item" + Character.toUpperCase(name.charAt(0)) + name.substring(1)});
            Item f = (Item)field.get(null);
            Field idField = ReflectionHelper.findField(BasicComponents.class, (String[])new String[]{"id" + Character.toUpperCase(name.charAt(0)) + name.substring(1)});
            int n = id = id <= 0 ? (Integer)idField.get(null) : id;
            if (f == null) {
                Item item;
                CONFIGURATION.load();
                if (name.contains("ingot")) {
                    field.set(null, (Object)new ItemIngot(name, id));
                } else if (name.contains("plate")) {
                    field.set(null, (Object)new ItemPlate(name, id));
                    item = (Item)field.get(null);
                    String ingotName = name.replaceAll("plate", "ingot");
                    Item itemIngot = null;
                    if (OreDictionary.getOres((String)ingotName).size() > 0) {
                        itemIngot = ((ItemStack)OreDictionary.getOres((String)ingotName).get(0)).func_77973_b();
                    }
                    if (name.equals("plateIron")) {
                        itemIngot = Item.field_77703_o;
                    } else if (name.equals("plateGold")) {
                        itemIngot = Item.field_77717_p;
                    }
                    if (itemIngot != null) {
                        RecipeHelper.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemIngot, 4), new Object[]{item}), CONFIGURATION, true);
                        RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(item, new Object[]{"II", "II", Character.valueOf('I'), itemIngot}), CONFIGURATION, true);
                    }
                } else if (name.contains("dust")) {
                    field.set(null, new ItemBase(name, id).func_77637_a(CreativeTabs.field_78035_l));
                    item = (Item)field.get(null);
                    if (name.equals("dustBronze")) {
                        RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", Character.valueOf('!'), "ingotCopper", Character.valueOf('#'), "ingotTin"}), CONFIGURATION, true);
                        if (OreDictionary.getOres((String)"ingotBronze").size() > 0) {
                            GameRegistry.addSmelting((int)item.field_77779_bT, (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotBronze").get(0)), (float)0.6f);
                        }
                    } else if (name.equals("dustSteel")) {
                        RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{" C ", "CIC", " C ", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('C'), Item.field_77705_m}), CONFIGURATION, true);
                        if (OreDictionary.getOres((String)"ingotSteel").size() > 0) {
                            GameRegistry.addSmelting((int)item.field_77779_bT, (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (float)0.8f);
                        }
                    }
                } else if (name.equals("wrench")) {
                    field.set(null, new ItemWrench(id));
                    item = (Item)field.get(null);
                    if (OreDictionary.getOres((String)"ingotSteel").size() > 0) {
                        RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{" S ", " SS", "S  ", Character.valueOf('S'), "ingotSteel"}), CONFIGURATION, true);
                    } else {
                        RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{" S ", " SS", "S  ", Character.valueOf('S'), Item.field_77703_o}), CONFIGURATION, true);
                    }
                } else if (name.equals("battery")) {
                    field.set(null, new ItemBattery(name, id));
                    RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemBattery), new Object[]{" T ", "TRT", "TCT", Character.valueOf('T'), "ingotTin", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('C'), Item.field_77705_m}), CONFIGURATION, true);
                    OreDictionary.registerOre((String)name, (ItemStack)ElectricItemHelper.getUncharged(itemBattery));
                } else if (name.equals("infiniteBattery")) {
                    itemInfiniteBattery = new ItemInfiniteBattery(name, id);
                    OreDictionary.registerOre((String)name, (ItemStack)ElectricItemHelper.getUncharged(itemInfiniteBattery));
                } else {
                    field.set(null, new ItemBase(name, id).func_77637_a(CreativeTabs.field_78035_l));
                    item = (Item)field.get(null);
                    if (name.equals("circuitBasic")) {
                        if (OreDictionary.getOres((String)"copperWire").size() > 0) {
                            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), "plateBronze", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), "copperWire"}), CONFIGURATION, true);
                            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), "plateSteel", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), "copperWire"}), CONFIGURATION, true);
                        } else {
                            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), "plateBronze", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), Block.field_94346_cn}), CONFIGURATION, true);
                            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"!#!", "#@#", "!#!", Character.valueOf('@'), "plateSteel", Character.valueOf('#'), Item.field_77767_aC, Character.valueOf('!'), Block.field_94346_cn}), CONFIGURATION, true);
                        }
                    } else if (name.equals("circuitAdvanced")) {
                        RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"@@@", "#?#", "@@@", Character.valueOf('@'), Item.field_77767_aC, Character.valueOf('?'), Item.field_77702_n, Character.valueOf('#'), "circuitBasic"}), CONFIGURATION, true);
                    } else if (name.equals("circuitElite")) {
                        RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"@@@", "?#?", "@@@", Character.valueOf('@'), Item.field_77717_p, Character.valueOf('?'), "circuitAdvanced", Character.valueOf('#'), Block.field_71948_O}), CONFIGURATION, true);
                    } else if (name.equals("motor")) {
                        if (OreDictionary.getOres((String)"copperWire").size() > 0) {
                            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"@!@", "!#!", "@!@", Character.valueOf('!'), "ingotSteel", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('@'), "copperWire"}), CONFIGURATION, true);
                        } else {
                            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), new Object[]{"@!@", "!#!", "@!@", Character.valueOf('!'), "ingotSteel", Character.valueOf('#'), Item.field_77703_o, Character.valueOf('@'), Block.field_94346_cn}), CONFIGURATION, true);
                        }
                    }
                }
                item = (Item)field.get(null);
                OreDictionary.registerOre((String)name, (Item)item);
                CONFIGURATION.save();
                FMLLog.info((String)("Basic Components: Successfully requested item: " + name), (Object[])new Object[0]);
                return item;
            }
            return f;
        }
        catch (Exception e) {
            FMLLog.severe((String)("Basic Components: Failed to require item: " + name), (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    public static Item requestItem(String name, int id) {
        if (!(OreDictionary.getOres((String)name).size() > 0 || name.equals("wrench") && Loader.isModLoaded((String)"BuildCraft|Core"))) {
            return BasicComponents.requireItem(name, id);
        }
        FMLLog.info((String)("Basic Components: " + name + " already exists in Ore Dictionary, using the ore instead."), (Object[])new Object[0]);
        if (OreDictionary.getOres((String)name).size() > 0) {
            return ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b();
        }
        return null;
    }

    public static Block requireBlock(String name, int id) {
        BasicComponents.init();
        try {
            Field field = ReflectionHelper.findField(BasicComponents.class, (String[])new String[]{"block" + Character.toUpperCase(name.charAt(0)) + name.substring(1)});
            Block f = (Block)field.get(null);
            Field idField = ReflectionHelper.findField(BasicComponents.class, (String[])new String[]{"id" + Character.toUpperCase(name.charAt(0)) + name.substring(1)});
            int n = id = id <= 0 ? (Integer)idField.get(null) : id;
            if (f == null) {
                Block block;
                CONFIGURATION.load();
                if (name.equals("copperWire")) {
                    field.set(null, (Object)new BlockCopperWire(id));
                    GameRegistry.registerBlock((Block)((Block)field.get(null)), ItemBlockCopperWire.class, (String)name);
                    ConductorChunkInitiate.register();
                    if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                        try {
                            BasicComponents.registerCopperWireRenderer();
                        }
                        catch (Exception e) {
                            FMLLog.severe((String)"Basic Components copper wire registry error!", (Object[])new Object[0]);
                            e.printStackTrace();
                        }
                    }
                    GameRegistry.registerTileEntity(TileEntityCopperWire.class, (String)"copperWire");
                    RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockCopperWire, 6), new Object[]{"WWW", "CCC", "WWW", Character.valueOf('W'), Block.field_72101_ab, Character.valueOf('C'), "ingotCopper"}), CONFIGURATION, true);
                    UniversalElectricity.isNetworkActive = true;
                } else if (name.contains("ore")) {
                    field.set(null, (Object)new BlockBase(name, id));
                    block = (Block)field.get(null);
                    GameRegistry.registerBlock((Block)block, (String)name);
                    String ingotName = name.replaceAll("ore", "ingot");
                    if (OreDictionary.getOres((String)ingotName).size() > 0) {
                        GameRegistry.addSmelting((int)block.field_71990_ca, (ItemStack)((ItemStack)OreDictionary.getOres((String)ingotName).get(0)), (float)0.6f);
                    }
                    Field generationField = ReflectionHelper.findField(BasicComponents.class, (String[])new String[]{"generation" + Character.toUpperCase(name.charAt(0)) + name.substring(1)});
                    generationField.set(null, new OreGenReplaceStone(name, name, new ItemStack(block), 60, 22, 4).enable(CONFIGURATION));
                    OreGenerator.addOre((OreGenReplaceStone)generationField.get(null));
                }
                block = (Block)field.get(null);
                OreDictionary.registerOre((String)name, (Block)block);
                CONFIGURATION.save();
                FMLLog.info((String)("Basic Components: Successfully requested block: " + name), (Object[])new Object[0]);
                return block;
            }
            return f;
        }
        catch (Exception e) {
            FMLLog.severe((String)("Basic Components: Failed to require block: " + name), (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerCopperWireRenderer() throws Exception {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCopperWire.class, (TileEntitySpecialRenderer)new RenderCopperWire());
    }

    public static Block requestBlock(String name, int id) {
        if (OreDictionary.getOres((String)name).size() <= 0) {
            return BasicComponents.requireBlock(name, id);
        }
        FMLLog.info((String)("Basic Components: " + name + " already exists in Ore Dictionary, using the ore instead."), (Object[])new Object[0]);
        if (((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b() instanceof ItemBlock) {
            return Block.field_71973_m[((ItemBlock)((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b()).func_77883_f()];
        }
        return null;
    }

    @Deprecated
    public static Item requireBattery(int id) {
        return BasicComponents.requestItem("battery", id);
    }

    @Deprecated
    public static Item requireInfiniteBattery(int id) {
        return BasicComponents.requestItem("infiniteBattery", id);
    }

    @Deprecated
    public static ItemStack requireMachines(int id) {
        return BasicComponents.requireMachines(null, id);
    }

    public static ItemStack requireMachines(Object mod, int id) {
        if (blockMachine == null) {
            Compatibility.initiate();
            id = id <= 0 ? 3973 : id;
            CONFIGURATION.load();
            blockMachine = new BlockBasicMachine(CONFIGURATION.getBlock("Basic Machine", id).getInt(id), 0);
            GameRegistry.registerBlock((Block)blockMachine, ItemBlockBasicMachine.class, (String)"Basic Machine");
            OreDictionary.registerOre((String)"coalGenerator", (ItemStack)((BlockBasicMachine)blockMachine).getCoalGenerator());
            OreDictionary.registerOre((String)"batteryBox", (ItemStack)((BlockBasicMachine)blockMachine).getBatteryBox());
            OreDictionary.registerOre((String)"electricFurnace", (ItemStack)((BlockBasicMachine)blockMachine).getElectricFurnace());
            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"batteryBox").get(0), new Object[]{"SSS", "BBB", "SSS", Character.valueOf('B'), "battery", Character.valueOf('S'), "ingotSteel"}), CONFIGURATION, true);
            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"coalGenerator").get(0), new Object[]{"MMM", "MOM", "MCM", Character.valueOf('M'), "ingotSteel", Character.valueOf('C'), "motor", Character.valueOf('O'), Block.field_72051_aB}), CONFIGURATION, true);
            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"coalGenerator").get(0), new Object[]{"MMM", "MOM", "MCM", Character.valueOf('M'), "ingotBronze", Character.valueOf('C'), "motor", Character.valueOf('O'), Block.field_72051_aB}), CONFIGURATION, true);
            RecipeHelper.addRecipe((IRecipe)new ShapedOreRecipe((ItemStack)OreDictionary.getOres((String)"electricFurnace").get(0), new Object[]{"SSS", "SCS", "SMS", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('M'), "motor"}), CONFIGURATION, true);
            CONFIGURATION.save();
        }
        if (mod != null) {
            bcDependants.add(mod);
            NetworkRegistry.instance().registerGuiHandler(mod, (IGuiHandler)new BCGuiHandler());
        }
        return new ItemStack(blockMachine);
    }

    public static void registerTileEntities() {
        if (!registeredTileEntities) {
            GameRegistry.registerTileEntity(TileEntityBatteryBox.class, (String)"UEBatteryBox");
            GameRegistry.registerTileEntity(TileEntityCoalGenerator.class, (String)"UECoalGenerator");
            GameRegistry.registerTileEntity(TileEntityElectricFurnace.class, (String)"UEElectricFurnace");
            registeredTileEntities = true;
        }
    }

    public static void register(String channel) {
        CHANNEL = channel;
        if (itemDustBronze != null && OreDictionary.getOres((String)"ingotBronze").size() > 0) {
            GameRegistry.addSmelting((int)BasicComponents.itemDustBronze.field_77779_bT, (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotBronze").get(0)), (float)0.6f);
        }
        if (itemDustSteel != null && OreDictionary.getOres((String)"ingotSteel").size() > 0) {
            GameRegistry.addSmelting((int)BasicComponents.itemDustSteel.field_77779_bT, (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (float)0.6f);
        }
        if (blockOreCopper != null) {
            GameRegistry.addSmelting((int)BasicComponents.blockOreCopper.field_71990_ca, (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotCopper").get(0)), (float)0.7f);
        }
        if (blockOreTin != null) {
            GameRegistry.addSmelting((int)BasicComponents.blockOreTin.field_71990_ca, (ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotTin").get(0)), (float)0.7f);
        }
    }

    public static void requestAll(Object mod) {
        if (CONFIGURATION.get("general", "Allow full registry", true).getBoolean(true)) {
            BasicComponents.requestItem("ingotCopper", 0);
            BasicComponents.requestItem("ingotTin", 0);
            BasicComponents.requestBlock("oreCopper", 0);
            BasicComponents.requestBlock("oreTin", 0);
            BasicComponents.requestItem("ingotSteel", 0);
            BasicComponents.requestItem("dustSteel", 0);
            BasicComponents.requestItem("plateSteel", 0);
            BasicComponents.requestItem("ingotBronze", 0);
            BasicComponents.requestItem("dustBronze", 0);
            BasicComponents.requestItem("plateBronze", 0);
            BasicComponents.requestItem("plateCopper", 0);
            BasicComponents.requestItem("plateTin", 0);
            BasicComponents.requestItem("plateIron", 0);
            BasicComponents.requestItem("plateGold", 0);
            BasicComponents.requestBlock("copperWire", 0);
            BasicComponents.requestItem("circuitBasic", 0);
            BasicComponents.requestItem("circuitAdvanced", 0);
            BasicComponents.requestItem("circuitElite", 0);
            BasicComponents.requestItem("motor", 0);
            BasicComponents.requestItem("wrench", 0);
            BasicComponents.requestItem("battery", 0);
            BasicComponents.requestItem("infiniteBattery", 0);
            BasicComponents.requireMachines(mod, 0);
            BasicComponents.registerTileEntities();
        }
    }

    public static Object getFirstDependant() {
        if (bcDependants.size() > 0) {
            return bcDependants.get(0);
        }
        return null;
    }

    static {
        INITIALIZED = false;
        registeredTileEntities = false;
        bcDependants = new ArrayList();
    }
}

