/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderManager;
import codechicken.chunkloader.ChunkLoaderSPH;
import codechicken.chunkloader.ChunkLoaderShape;
import codechicken.chunkloader.TileChunkLoaderBase;
import codechicken.lib.packet.PacketCustom;
import java.util.HashSet;

public class TileChunkLoader
extends TileChunkLoaderBase {
    public int radius;
    public ChunkLoaderShape shape;

    public static void handleDescriptionPacket(PacketCustom packet, abv world) {
        asm tile = world.r(packet.readInt(), packet.readInt(), packet.readInt());
        if (tile instanceof TileChunkLoader) {
            TileChunkLoader ctile = (TileChunkLoader)tile;
            ctile.setShapeAndRadius(ChunkLoaderShape.values()[packet.readUByte()], packet.readUByte());
            ctile.active = packet.readBoolean();
            if (packet.readBoolean()) {
                ctile.owner = packet.readString();
            }
        }
    }

    public boolean setShapeAndRadius(ChunkLoaderShape newShape, int newRadius) {
        if (this.k.I) {
            this.radius = newRadius;
            this.shape = newShape;
            return true;
        }
        HashSet<abo> chunks = TileChunkLoader.getContainedChunks(newShape, this.l, this.n, newRadius);
        if (chunks.size() > ChunkLoaderManager.maxChunksPerLoader()) {
            return false;
        }
        if (this.powered) {
            this.radius = newRadius;
            this.shape = newShape;
            this.k.j(this.l, this.m, this.n);
            return true;
        }
        if (ChunkLoaderManager.canLoaderAdd(this, chunks)) {
            this.radius = newRadius;
            this.shape = newShape;
            ChunkLoaderManager.updateLoader(this);
            this.k.j(this.l, this.m, this.n);
            return true;
        }
        return false;
    }

    public ex m() {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 10);
        packet.setChunkDataPacket();
        packet.writeCoord(this.l, this.m, this.n);
        packet.writeByte(this.shape.ordinal());
        packet.writeByte(this.radius);
        packet.writeBoolean(this.active);
        packet.writeBoolean(this.owner != null);
        if (this.owner != null) {
            packet.writeString(this.owner);
        }
        return packet.toPacket();
    }

    @Override
    public void b(bx tag) {
        super.b(tag);
        tag.a("radius", (byte)this.radius);
        tag.a("shape", (byte)this.shape.ordinal());
    }

    @Override
    public void a(bx tag) {
        super.a(tag);
        this.radius = tag.c("radius");
        this.shape = ChunkLoaderShape.values()[tag.c("shape")];
    }

    public HashSet<abo> getChunks() {
        return TileChunkLoader.getContainedChunks(this.shape, this.l, this.n, this.radius);
    }

    public static HashSet<abo> getContainedChunks(ChunkLoaderShape shape, int xCoord, int zCoord, int radius) {
        return shape.getLoadedChunks(xCoord >> 4, zCoord >> 4, radius - 1);
    }

    public int countLoadedChunks() {
        return ((HashSet)this.getChunks()).size();
    }

    @Override
    public void activate() {
        if (this.radius == 0) {
            this.radius = 1;
            this.shape = ChunkLoaderShape.Square;
            this.setShapeAndRadius(ChunkLoaderShape.Square, 2);
        }
        super.activate();
    }
}

