/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderSPH;
import codechicken.chunkloader.PlayerChunkViewerManager;
import codechicken.core.CommonUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class PlayerChunkViewerTracker {
    private final PlayerChunkViewerManager manager;
    public final ue owner;
    private HashSet<Integer> knownTickets = new HashSet();

    public PlayerChunkViewerTracker(ue player, PlayerChunkViewerManager manager) {
        this.owner = player;
        this.manager = manager;
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 1);
        packet.sendToPlayer(player);
        jr[] jrArray = DimensionManager.getWorlds();
        int n = jrArray.length;
        int n2 = 0;
        while (n2 < n) {
            jr world = jrArray[n2];
            this.loadDimension(world);
            ++n2;
        }
    }

    public void writeTicketToPacket(PacketCustom packet, ForgeChunkManager.Ticket ticket, Collection<abo> chunkSet) {
        packet.writeInt(this.manager.ticketIDs.get(ticket).intValue());
        packet.writeString(ticket.getModId());
        String player = ticket.getPlayerName();
        packet.writeBoolean(player != null);
        if (player != null) {
            packet.writeString(player);
        }
        packet.writeByte(ticket.getType().ordinal());
        nm entity = ticket.getEntity();
        if (entity != null) {
            packet.writeInt(entity.k);
        }
        packet.writeShort(chunkSet.size());
        for (abo chunk : chunkSet) {
            packet.writeInt(chunk.a);
            packet.writeInt(chunk.b);
        }
        this.knownTickets.add(this.manager.ticketIDs.get(ticket));
    }

    public void loadDimension(jr world) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 2).compressed();
        int dim = CommonUtils.getDimension((abv)world);
        packet.writeInt(dim);
        List allchunks = world.b.g;
        packet.writeInt(allchunks.size());
        for (adq chunk : allchunks) {
            packet.writeInt(chunk.g);
            packet.writeInt(chunk.h);
        }
        ImmutableMap tickets = ForgeChunkManager.getPersistentChunksFor((abv)world).inverse().asMap();
        packet.writeInt(tickets.size());
        for (Map.Entry entry : tickets.entrySet()) {
            this.writeTicketToPacket(packet, (ForgeChunkManager.Ticket)entry.getKey(), (Collection)entry.getValue());
        }
        packet.sendToPlayer(this.owner);
    }

    public void unloadDimension(int dim) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 3);
        packet.writeInt(dim);
        packet.sendToPlayer(this.owner);
    }

    public void sendChunkChange(PlayerChunkViewerManager.ChunkChange change) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 4);
        packet.writeInt(change.dimension);
        packet.writeInt(change.chunk.a);
        packet.writeInt(change.chunk.b);
        packet.writeBoolean(change.add);
        packet.sendToPlayer(this.owner);
    }

    public void sendTicketChange(PlayerChunkViewerManager.TicketChange change) {
        int ticketID = this.manager.ticketIDs.get(change.ticket);
        if (!this.knownTickets.contains(ticketID)) {
            this.addTicket(change.dimension, change.ticket);
        }
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 5);
        packet.writeInt(change.dimension);
        packet.writeInt(ticketID);
        packet.writeInt(change.chunk.a);
        packet.writeInt(change.chunk.b);
        packet.writeBoolean(change.force);
        packet.sendToPlayer(this.owner);
    }

    public void updatePlayer(ue player) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 6);
        packet.writeString(player.bu);
        packet.writeInt(player.ar);
        Vector3 pos = Vector3.fromEntity((nm)player);
        packet.writeFloat((float)pos.x);
        packet.writeFloat((float)pos.y);
        packet.writeFloat((float)pos.z);
        packet.sendToPlayer(this.owner);
    }

    public void removePlayer(String username) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 7);
        packet.writeString(username);
        packet.sendToPlayer(this.owner);
    }

    public void addTicket(int dimension, ForgeChunkManager.Ticket ticket) {
        PacketCustom packet = new PacketCustom((Object)ChunkLoaderSPH.channel, 8);
        packet.writeInt(dimension);
        this.writeTicketToPacket(packet, ticket, (Collection<abo>)ticket.getChunkList());
        packet.sendToPlayer(this.owner);
    }
}

