/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.PlayerChunkViewerTracker;
import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class PlayerChunkViewerManager {
    public LinkedList<PlayerChunkViewerTracker> playerViewers = new LinkedList();
    public HashMap<ForgeChunkManager.Ticket, Integer> ticketIDs = new HashMap();
    private int ticketID = 0;
    private int time = 0;
    private HashMap<Integer, HashSet<abo>> lastLoadedChunkMap = new HashMap();
    public LinkedList<ChunkChange> chunkChanges = new LinkedList();
    public LinkedList<TicketChange> ticketChanges = new LinkedList();
    public LinkedList<DimensionChange> dimChanges = new LinkedList();
    public LinkedList<String> logouts = new LinkedList();
    public LinkedList<String> addViewers = new LinkedList();
    private static PlayerChunkViewerManager instance;

    public static PlayerChunkViewerManager instance() {
        if (instance == null) {
            instance = new PlayerChunkViewerManager();
        }
        return instance;
    }

    public void update() {
        ++this.time;
        for (String string : this.logouts) {
            Iterator iterator = this.playerViewers.iterator();
            while (iterator.hasNext()) {
                if (!((PlayerChunkViewerTracker)iterator.next()).owner.bu.equals(string)) continue;
                iterator.remove();
            }
        }
        for (String string : this.logouts) {
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.removePlayer(string);
            }
        }
        for (DimensionChange dimensionChange : this.dimChanges) {
            if (!dimensionChange.add) continue;
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.loadDimension(dimensionChange.world);
            }
        }
        for (ChunkChange chunkChange : this.chunkChanges) {
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.sendChunkChange(chunkChange);
            }
        }
        for (TicketChange ticketChange : this.ticketChanges) {
            if (this.ticketIDs.containsKey(ticketChange.ticket)) {
                for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                    tracker.sendTicketChange(ticketChange);
                }
                continue;
            }
            this.ticketIDs.put(ticketChange.ticket, this.ticketID++);
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.addTicket(CommonUtils.getDimension((abv)ticketChange.ticket.world), ticketChange.ticket);
            }
        }
        for (DimensionChange dimensionChange : this.dimChanges) {
            if (dimensionChange.add) continue;
            for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                tracker.unloadDimension(CommonUtils.getDimension((abv)dimensionChange.world));
            }
        }
        if (this.time % 10 == 0) {
            for (ue ue2 : ServerUtils.getAllPlayers()) {
                for (PlayerChunkViewerTracker tracker : this.playerViewers) {
                    tracker.updatePlayer(ue2);
                }
            }
        }
        for (String string : this.addViewers) {
            ju player = ServerUtils.getPlayer((String)string);
            if (player == null) continue;
            if (this.playerViewers.isEmpty()) {
                this.updateChunkChangeMap();
            }
            this.playerViewers.add(new PlayerChunkViewerTracker((ue)player, this));
        }
        this.addViewers.clear();
        this.dimChanges.clear();
        this.logouts.clear();
        this.chunkChanges.clear();
        this.ticketChanges.clear();
    }

    private void updateChunkChangeMap() {
        jr[] jrArray = DimensionManager.getWorlds();
        int n = jrArray.length;
        int n2 = 0;
        while (n2 < n) {
            jr world = jrArray[n2];
            HashSet<abo> allChunks = new HashSet<abo>();
            ArrayList loadedChunkCopy = new ArrayList(world.b.g);
            for (adq chunk : loadedChunkCopy) {
                allChunks.add(chunk.l());
            }
            this.lastLoadedChunkMap.put(CommonUtils.getDimension((abv)world), allChunks);
            ++n2;
        }
    }

    public void calculateChunkChanges(jr world) {
        if (this.playerViewers.isEmpty()) {
            return;
        }
        int dimension = CommonUtils.getDimension((abv)world);
        HashSet<Object> wasLoadedChunks = this.lastLoadedChunkMap.get(dimension);
        if (wasLoadedChunks == null) {
            wasLoadedChunks = new HashSet();
        }
        HashSet<abo> allChunks = new HashSet<abo>();
        ArrayList loadedChunkCopy = new ArrayList(world.b.g);
        for (adq adq2 : loadedChunkCopy) {
            abo coord = adq2.l();
            allChunks.add(coord);
            if (wasLoadedChunks.remove(coord)) continue;
            this.chunkChanges.add(new ChunkChange(dimension, coord, true));
        }
        for (abo abo2 : wasLoadedChunks) {
            this.chunkChanges.add(new ChunkChange(dimension, abo2, false));
        }
        this.lastLoadedChunkMap.put(dimension, allChunks);
    }

    public boolean isViewerOpen(String username) {
        for (PlayerChunkViewerTracker tracker : this.playerViewers) {
            if (!tracker.owner.bu.equals(username)) continue;
            return true;
        }
        return false;
    }

    public static void serverShutdown() {
        instance = null;
    }

    public void closeViewer(String username) {
        Iterator iterator = this.playerViewers.iterator();
        while (iterator.hasNext()) {
            if (!((PlayerChunkViewerTracker)iterator.next()).owner.bu.equals(username)) continue;
            iterator.remove();
        }
    }

    public static class ChunkChange {
        public final abo chunk;
        public final boolean add;
        public final int dimension;

        public ChunkChange(int dimension, abo chunk, boolean add) {
            this.dimension = dimension;
            this.chunk = chunk;
            this.add = add;
        }
    }

    public static class DimensionChange {
        public final jr world;
        public final boolean add;

        public DimensionChange(jr world, boolean add) {
            this.world = world;
            this.add = add;
        }
    }

    public static class TicketChange {
        public final ForgeChunkManager.Ticket ticket;
        public final abo chunk;
        public final boolean force;
        public final int dimension;

        public TicketChange(ForgeChunkManager.Ticket ticket, abo chunk, boolean force) {
            this.ticket = ticket;
            this.dimension = CommonUtils.getDimension((abv)ticket.world);
            this.chunk = chunk;
            this.force = force;
        }
    }
}

