/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderManager;
import codechicken.chunkloader.PlayerChunkViewerManager;
import codechicken.core.ServerUtils;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkLoaderEventHandler
implements ITickHandler,
IPlayerTracker {
    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (type.contains(TickType.SERVER)) {
            PlayerChunkViewerManager.instance().update();
        }
        if (type.contains(TickType.WORLD)) {
            ChunkLoaderManager.tickEnd((jr)tickData[0]);
            PlayerChunkViewerManager.instance().calculateChunkChanges((jr)tickData[0]);
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.PLAYER, TickType.SERVER, TickType.WORLD);
    }

    public String getLabel() {
        return "ChickenChunks";
    }

    public void onPlayerLogin(ue player) {
        ChunkLoaderManager.playerLogin(player.bu);
    }

    public void onPlayerLogout(ue player) {
        PlayerChunkViewerManager.instance().logouts.add(player.bu);
        ChunkLoaderManager.playerLogout(player.bu);
    }

    public void onPlayerChangedDimension(ue player) {
    }

    public void onPlayerRespawn(ue player) {
    }

    @ForgeSubscribe
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        ChunkLoaderManager.load((jr)event.world);
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.I) {
            ChunkLoaderManager.load((jr)event.world);
            ChunkLoaderManager.loadWorld((jr)event.world);
            PlayerChunkViewerManager.instance().dimChanges.add(new PlayerChunkViewerManager.DimensionChange((jr)event.world, true));
        }
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.I) {
            if (ServerUtils.mc().o()) {
                PlayerChunkViewerManager.instance().dimChanges.add(new PlayerChunkViewerManager.DimensionChange((jr)event.world, false));
            } else {
                PlayerChunkViewerManager.serverShutdown();
                ChunkLoaderManager.serverShutdown();
            }
        }
    }

    @ForgeSubscribe
    public void onWorldSave(WorldEvent.Save event) {
        ChunkLoaderManager.save((jr)event.world);
    }

    @ForgeSubscribe
    public void onChunkForce(ForgeChunkManager.ForceChunkEvent event) {
        PlayerChunkViewerManager.instance().ticketChanges.add(new PlayerChunkViewerManager.TicketChange(event.ticket, event.location, true));
    }

    @ForgeSubscribe
    public void onChunkUnForce(ForgeChunkManager.UnforceChunkEvent event) {
        PlayerChunkViewerManager.instance().ticketChanges.add(new PlayerChunkViewerManager.TicketChange(event.ticket, event.location, false));
    }
}

