/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network;

import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLNetworkException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import net.minecraftforge.common.network.packet.DimensionRegisterPacket;
import net.minecraftforge.fluids.FluidIdMapPacket;

public abstract class ForgePacket {
    public static final String CHANNEL_ID = "FORGE";
    private Type type;
    private byte[][] partials;

    public static dz[] makePacketSet(ForgePacket packet) {
        byte[] packetData = packet.generatePacket();
        if (packetData.length < 32000) {
            return new dz[]{new dz(CHANNEL_ID, Bytes.concat((byte[][])new byte[][]{{UnsignedBytes.checkedCast((long)0L), UnsignedBytes.checkedCast((long)packet.getID())}, packetData}))};
        }
        byte[][] chunks = new byte[packetData.length / 32000 + 1][];
        for (int i = 0; i < packetData.length / 32000 + 1; ++i) {
            int len = Math.min(32000, packetData.length - i * 32000);
            chunks[i] = Bytes.concat((byte[][])new byte[][]{{UnsignedBytes.checkedCast((long)1L), UnsignedBytes.checkedCast((long)packet.getID()), UnsignedBytes.checkedCast((long)i), UnsignedBytes.checkedCast((long)chunks.length)}, Ints.toByteArray((int)len), Arrays.copyOfRange(packetData, i * 32000, len + i * 32000)});
        }
        dz[] ret = new dz[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            ret[i] = new dz(CHANNEL_ID, chunks[i]);
        }
        return ret;
    }

    public static ForgePacket readPacket(cl network, byte[] payload) {
        boolean multipart = UnsignedBytes.toInt((byte)payload[0]) == 1;
        int type = UnsignedBytes.toInt((byte)payload[1]);
        Type eType = Type.values()[type];
        byte[] data = Arrays.copyOfRange(payload, 2, payload.length);
        if (multipart) {
            ForgePacket pkt = eType.consumePart(network, data);
            if (pkt != null) {
                return pkt.consumePacket(Bytes.concat((byte[][])pkt.partials));
            }
            return null;
        }
        return eType.make().consumePacket(data);
    }

    public ForgePacket() {
        for (Type t2 : Type.values()) {
            if (t2.packetType != this.getClass()) continue;
            this.type = t2;
        }
        if (this.type == null) {
            throw new RuntimeException("ForgePacket constructor called on ungregistered type.");
        }
    }

    public byte getID() {
        return UnsignedBytes.checkedCast((long)this.type.ordinal());
    }

    public abstract byte[] generatePacket();

    public abstract ForgePacket consumePacket(byte[] var1);

    public abstract void execute(cl var1, ue var2);

    static /* synthetic */ byte[][] access$002(ForgePacket x0, byte[][] x1) {
        x0.partials = x1;
        return x1;
    }

    static enum Type {
        REGISTERDIMENSION(DimensionRegisterPacket.class),
        FLUID_IDMAP(FluidIdMapPacket.class);

        private Class<? extends ForgePacket> packetType;
        private ConcurrentMap<cl, ForgePacket> partTracker;

        private Type(Class<? extends ForgePacket> clazz) {
            this.packetType = clazz;
        }

        ForgePacket make() {
            try {
                return this.packetType.newInstance();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                FMLLog.log(Level.SEVERE, e, "A bizarre critical error occured during packet encoding", new Object[0]);
                throw new FMLNetworkException(e);
            }
        }

        private ForgePacket consumePart(cl network, byte[] data) {
            if (this.partTracker == null) {
                this.partTracker = new MapMaker().weakKeys().weakValues().makeMap();
            }
            if (!this.partTracker.containsKey(network)) {
                this.partTracker.put(network, this.make());
            }
            ForgePacket pkt = (ForgePacket)this.partTracker.get(network);
            ByteArrayDataInput bdi = ByteStreams.newDataInput((byte[])data);
            int chunkIdx = UnsignedBytes.toInt((byte)bdi.readByte());
            int chunkTotal = UnsignedBytes.toInt((byte)bdi.readByte());
            int chunkLength = bdi.readInt();
            if (pkt.partials == null) {
                ForgePacket.access$002(pkt, new byte[chunkTotal][]);
            }
            ((ForgePacket)pkt).partials[chunkIdx] = new byte[chunkLength];
            bdi.readFully(pkt.partials[chunkIdx]);
            for (int i = 0; i < pkt.partials.length; ++i) {
                if (pkt.partials[i] != null) continue;
                return null;
            }
            return pkt;
        }
    }
}

