/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ForgeDummyContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;

public class ForgeHooks {
    static final List<GrassEntry> grassList = new ArrayList<GrassEntry>();
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static HashMap<yb, List> toolClasses = new HashMap();
    static HashMap<List, Integer> toolHarvestLevels = new HashMap();
    static HashSet<List> toolEffectiveness = new HashSet();

    public static void plantGrass(abv world, int x2, int y, int z2) {
        GrassEntry grass = (GrassEntry)mh.a((Random)world.s, grassList);
        if (grass == null || grass.block == null || !grass.block.f(world, x2, y, z2)) {
            return;
        }
        world.f(x2, y, z2, grass.block.cF, grass.metadata, 3);
    }

    public static yd getGrassSeed(abv world) {
        SeedEntry entry = (SeedEntry)mh.a((Random)world.s, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.seed.m();
    }

    public static boolean canHarvestBlock(aqw block, ue player, int metadata) {
        if (block.cU.l()) {
            return true;
        }
        yd stack = player.bn.h();
        if (stack == null) {
            return player.a(block);
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return player.a(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.a(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static boolean canToolHarvestBlock(aqw block, int metadata, yd stack) {
        if (stack == null) {
            return false;
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return false;
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        return blockHarvestLevel != null && blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(aqw block, ue player, abv world, int x2, int y, int z2) {
        int metadata = world.h(x2, y, z2);
        float hardness = block.l(world, x2, y, z2);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            float speed = ForgeEventFactory.getBreakSpeed(player, block, metadata, 1.0f);
            return (speed < 0.0f ? 0.0f : speed) / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, false, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(yd stack, aqw block, int metadata) {
        List toolClass = toolClasses.get(stack.b());
        return toolClass != null && toolEffectiveness.contains(Arrays.asList(block, metadata, toolClass.get(0)));
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(yb.v, "pickaxe", 0);
        MinecraftForge.setToolClass(yb.z, "pickaxe", 1);
        MinecraftForge.setToolClass(yb.i, "pickaxe", 2);
        MinecraftForge.setToolClass(yb.K, "pickaxe", 0);
        MinecraftForge.setToolClass(yb.D, "pickaxe", 3);
        MinecraftForge.setToolClass(yb.w, "axe", 0);
        MinecraftForge.setToolClass(yb.A, "axe", 1);
        MinecraftForge.setToolClass(yb.j, "axe", 2);
        MinecraftForge.setToolClass(yb.L, "axe", 0);
        MinecraftForge.setToolClass(yb.E, "axe", 3);
        MinecraftForge.setToolClass(yb.u, "shovel", 0);
        MinecraftForge.setToolClass(yb.y, "shovel", 1);
        MinecraftForge.setToolClass(yb.h, "shovel", 2);
        MinecraftForge.setToolClass(yb.J, "shovel", 0);
        MinecraftForge.setToolClass(yb.C, "shovel", 3);
        for (aqw block : ym.c) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (aqw block : yx.c) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (aqw block : xz.c) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
        MinecraftForge.setBlockHarvestLevel(aqw.au, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(aqw.bW, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqw.aB, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqw.aC, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqw.L, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqw.am, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqw.M, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqw.an, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqw.S, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqw.T, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aqw.aS, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aqw.aT, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(aqw.aS, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(aqw.au, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(aqw.aT, "pickaxe");
    }

    public static int getTotalArmorValue(ue player) {
        int ret = 0;
        for (int x2 = 0; x2 < player.bn.b.length; ++x2) {
            yd stack = player.bn.b[x2];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)stack.b()).getArmorDisplay(player, stack, x2);
                continue;
            }
            if (stack == null || !(stack.b() instanceof wg)) continue;
            ret += ((wg)stack.b()).c;
        }
        return ret;
    }

    public static boolean onPickBlock(asx target, ue player, abv world) {
        int x2;
        yd result = null;
        boolean isCreative = player.bG.d;
        if (target.a == asy.a) {
            x2 = target.b;
            int y = target.c;
            int z2 = target.d;
            aqw var8 = aqw.s[world.a(x2, y, z2)];
            if (var8 == null) {
                return false;
            }
            result = var8.getPickBlock(target, world, x2, y, z2);
        } else {
            if (target.a != asy.b || target.g == null || !isCreative) {
                return false;
            }
            result = target.g.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        for (x2 = 0; x2 < 9; ++x2) {
            yd stack = player.bn.a(x2);
            if (stack == null || !stack.a(result) || !yd.a((yd)stack, (yd)result)) continue;
            player.bn.c = x2;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.bn.j();
        if (slot < 0 || slot >= 9) {
            slot = player.bn.c;
        }
        player.bn.a(slot, result);
        player.bn.c = slot;
        return true;
    }

    public static void onLivingSetAttackTarget(oe entity, oe target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(oe entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(oe entity, na src, float amount) {
        return MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(oe entity, na src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.ammount;
    }

    public static boolean onLivingDeath(oe entity, na src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(oe entity, na source, ArrayList<sr> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit, specialDropValue));
    }

    public static float onLivingFall(oe entity, float distance) {
        LivingFallEvent event = new LivingFallEvent(entity, distance);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.distance;
    }

    public static boolean isLivingOnLadder(aqw block, abv world, int x2, int y, int z2, oe entity) {
        if (!ForgeDummyContainer.fullBoundingBoxLadders) {
            return block != null && block.isLadder(world, x2, y, z2, entity);
        }
        asu bb = entity.E;
        int mX = lr.c((double)bb.a);
        int mY = lr.c((double)bb.b);
        int mZ = lr.c((double)bb.c);
        int y2 = mY;
        while ((double)y < bb.e) {
            int x22 = mX;
            while ((double)x22 < bb.d) {
                int z22 = mZ;
                while ((double)z22 < bb.f) {
                    block = aqw.s[world.a(x22, y2, z22)];
                    if (block != null && block.isLadder(world, x22, y2, z22, entity)) {
                        return true;
                    }
                    ++z22;
                }
                ++x22;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(oe entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static sr onPlayerTossEvent(ue player, yd item) {
        player.captureDrops = true;
        sr ret = player.a(item, false);
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        player.a(event.entityItem);
        return event.entityItem;
    }

    public static float getEnchantPower(abv world, int x2, int y, int z2) {
        if (world.c(x2, y, z2)) {
            return 0.0f;
        }
        aqw block = aqw.s[world.a(x2, y, z2)];
        return block == null ? 0.0f : block.getEnchantPowerBonus(world, x2, y, z2);
    }

    public static cu onServerChatEvent(jz net, String raw, cu comp) {
        ServerChatEvent event = new ServerChatEvent(net.c, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.component;
    }

    static {
        grassList.add(new GrassEntry((aqw)aqw.ai, 0, 20));
        grassList.add(new GrassEntry((aqw)aqw.aj, 0, 10));
        seedList.add(new SeedEntry(new yd(yb.U), 10));
        ForgeHooks.initTools();
    }

    static class SeedEntry
    extends mi {
        public final yd seed;

        public SeedEntry(yd seed, int weight) {
            super(weight);
            this.seed = seed;
        }
    }

    static class GrassEntry
    extends mi {
        public final aqw block;
        public final int metadata;

        public GrassEntry(aqw block, int meta, int weight) {
            super(weight);
            this.block = block;
            this.metadata = meta;
        }
    }
}

