/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.EnumSet;

public class BiomeDictionary {
    private static final int BIOME_LIST_SIZE = 256;
    private static BiomeInfo[] biomeList = new BiomeInfo[256];
    private static ArrayList<acp>[] typeInfoList = new ArrayList[Type.values().length];

    public static boolean registerBiomeType(acp biome, Type ... types) {
        if (acp.a[biome.N] != null) {
            for (Type type : types) {
                if (typeInfoList[type.ordinal()] == null) {
                    BiomeDictionary.typeInfoList[type.ordinal()] = new ArrayList();
                }
                typeInfoList[type.ordinal()].add(biome);
            }
            if (biomeList[biome.N] == null) {
                BiomeDictionary.biomeList[biome.N] = new BiomeInfo(types);
            } else {
                for (Type type : types) {
                    BiomeDictionary.biomeList[biome.N].typeList.add(type);
                }
            }
            return true;
        }
        return false;
    }

    public static acp[] getBiomesForType(Type type) {
        if (typeInfoList[type.ordinal()] != null) {
            return typeInfoList[type.ordinal()].toArray(new acp[0]);
        }
        return new acp[0];
    }

    public static Type[] getTypesForBiome(acp biome) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.N] != null) {
            return BiomeDictionary.biomeList[biome.N].typeList.toArray(new Type[0]);
        }
        return new Type[0];
    }

    public static boolean areBiomesEquivalent(acp biomeA, acp biomeB) {
        int a2 = biomeA.N;
        int b2 = biomeB.N;
        BiomeDictionary.checkRegistration(biomeA);
        BiomeDictionary.checkRegistration(biomeB);
        if (biomeList[a2] != null && biomeList[b2] != null) {
            for (Type type : BiomeDictionary.biomeList[a2].typeList) {
                if (!BiomeDictionary.containsType(biomeList[b2], type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBiomeOfType(acp biome, Type type) {
        BiomeDictionary.checkRegistration(biome);
        if (biomeList[biome.N] != null) {
            return BiomeDictionary.containsType(biomeList[biome.N], type);
        }
        return false;
    }

    public static boolean isBiomeRegistered(acp biome) {
        return biomeList[biome.N] != null;
    }

    public static boolean isBiomeRegistered(int biomeID) {
        return biomeList[biomeID] != null;
    }

    public static void registerAllBiomes() {
        for (int i = 0; i < 256; ++i) {
            if (acp.a[i] == null) continue;
            BiomeDictionary.checkRegistration(acp.a[i]);
        }
    }

    public static void makeBestGuess(acp biome) {
        if (biome.I.z >= 3) {
            if (biome.e() && biome.F >= 1.0f) {
                BiomeDictionary.registerBiomeType(biome, Type.JUNGLE);
            } else if (!biome.e()) {
                BiomeDictionary.registerBiomeType(biome, Type.FOREST);
            }
        } else if (biome.E <= 0.3f && biome.E >= 0.0f && (!biome.e() || biome.D >= 0.0f)) {
            BiomeDictionary.registerBiomeType(biome, Type.PLAINS);
        }
        if (biome.e() && biome.D < 0.0f && biome.E <= 0.3f && biome.E >= 0.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.SWAMP);
        }
        if (biome.D <= -0.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.WATER);
        }
        if (biome.E >= 1.5f) {
            BiomeDictionary.registerBiomeType(biome, Type.MOUNTAIN);
        }
        if (biome.c() || biome.F < 0.2f) {
            BiomeDictionary.registerBiomeType(biome, Type.FROZEN);
        }
        if (!biome.e() && biome.F >= 1.0f) {
            BiomeDictionary.registerBiomeType(biome, Type.DESERT);
        }
    }

    private static void checkRegistration(acp biome) {
        if (!BiomeDictionary.isBiomeRegistered(biome)) {
            BiomeDictionary.makeBestGuess(biome);
        }
    }

    private static boolean containsType(BiomeInfo info, Type type) {
        return info.typeList.contains((Object)type);
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.registerBiomeType(acp.b, Type.WATER);
        BiomeDictionary.registerBiomeType(acp.c, Type.PLAINS);
        BiomeDictionary.registerBiomeType(acp.d, Type.DESERT);
        BiomeDictionary.registerBiomeType(acp.e, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(acp.f, Type.FOREST);
        BiomeDictionary.registerBiomeType(acp.g, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acp.u, Type.FOREST, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acp.h, Type.SWAMP);
        BiomeDictionary.registerBiomeType(acp.i, Type.WATER);
        BiomeDictionary.registerBiomeType(acp.l, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acp.m, Type.WATER, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acp.n, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acp.o, Type.FROZEN);
        BiomeDictionary.registerBiomeType(acp.r, Type.BEACH);
        BiomeDictionary.registerBiomeType(acp.s, Type.DESERT);
        BiomeDictionary.registerBiomeType(acp.w, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(acp.x, Type.JUNGLE);
        BiomeDictionary.registerBiomeType(acp.t, Type.FOREST);
        BiomeDictionary.registerBiomeType(acp.k, Type.END);
        BiomeDictionary.registerBiomeType(acp.j, Type.NETHER);
        BiomeDictionary.registerBiomeType(acp.p, Type.MUSHROOM);
        BiomeDictionary.registerBiomeType(acp.v, Type.MOUNTAIN);
        BiomeDictionary.registerBiomeType(acp.q, Type.MUSHROOM, Type.BEACH);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        public EnumSet<Type> typeList = EnumSet.noneOf(Type.class);

        public BiomeInfo(Type[] types) {
            for (Type t2 : types) {
                this.typeList.add(t2);
            }
        }
    }

    public static enum Type {
        FOREST,
        PLAINS,
        MOUNTAIN,
        HILLS,
        SWAMP,
        WATER,
        DESERT,
        FROZEN,
        JUNGLE,
        WASTELAND,
        BEACH,
        NETHER,
        END,
        MUSHROOM,
        MAGICAL;

    }
}

