/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ModListResponsePacket
extends FMLPacket {
    private Map<String, String> modVersions;
    private List<String> missingMods;

    public ModListResponsePacket() {
        super(FMLPacket.Type.MOD_LIST_RESPONSE);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        Map modVersions = (Map)data[0];
        List missingMods = (List)data[1];
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        dat.writeInt(modVersions.size());
        for (Map.Entry version : modVersions.entrySet()) {
            dat.writeUTF((String)version.getKey());
            dat.writeUTF((String)version.getValue());
        }
        dat.writeInt(missingMods.size());
        for (String missing : missingMods) {
            dat.writeUTF(missing);
        }
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])data);
        int versionListSize = dat.readInt();
        this.modVersions = Maps.newHashMapWithExpectedSize((int)versionListSize);
        for (int i = 0; i < versionListSize; ++i) {
            String modName = dat.readUTF();
            String modVersion = dat.readUTF();
            this.modVersions.put(modName, modVersion);
        }
        int missingModSize = dat.readInt();
        this.missingMods = Lists.newArrayListWithExpectedSize((int)missingModSize);
        for (int i = 0; i < missingModSize; ++i) {
            this.missingMods.add(dat.readUTF());
        }
        return this;
    }

    @Override
    public void execute(cl network, FMLNetworkHandler handler, ey netHandler, String userName) {
        NetworkModHandler networkMod;
        ModContainer mc;
        HashMap indexedModList = Maps.newHashMap(Loader.instance().getIndexedModList());
        ArrayList missingClientMods = Lists.newArrayList();
        ArrayList versionIncorrectMods = Lists.newArrayList();
        for (String string : this.missingMods) {
            mc = (ModContainer)indexedModList.get(string);
            networkMod = handler.findNetworkModHandler(mc);
            if (!networkMod.requiresClientSide()) continue;
            missingClientMods.add(string);
        }
        for (Map.Entry entry : this.modVersions.entrySet()) {
            mc = (ModContainer)indexedModList.get(entry.getKey());
            networkMod = handler.findNetworkModHandler(mc);
            if (networkMod.acceptVersion((String)entry.getValue())) continue;
            versionIncorrectMods.add(entry.getKey());
        }
        dz pkt = new dz();
        pkt.a = "FML";
        if (missingClientMods.size() > 0 || versionIncorrectMods.size() > 0) {
            pkt.c = FMLPacket.makePacket(FMLPacket.Type.MOD_MISSING, missingClientMods, versionIncorrectMods);
            Logger.getLogger("Minecraft").info(String.format("User %s connection failed: missing %s, bad versions %s", userName, missingClientMods, versionIncorrectMods));
            FMLLog.info("User %s connection failed: missing %s, bad versions %s", userName, missingClientMods, versionIncorrectMods);
            FMLNetworkHandler.setHandlerState((jx)netHandler, -2);
            pkt.b = pkt.c.length;
            network.a((ex)pkt);
        } else {
            pkt.c = FMLPacket.makePacket(FMLPacket.Type.MOD_IDENTIFIERS, netHandler);
            Logger.getLogger("Minecraft").info(String.format("User %s connecting with mods %s", userName, this.modVersions.keySet()));
            FMLLog.info("User %s connecting with mods %s", userName, this.modVersions.keySet());
            pkt.b = pkt.c.length;
            network.a((ex)pkt);
            cf cf2 = new cf();
            GameData.writeItemData(cf2);
            byte[][] registryPackets = FMLPacket.makePacketSet(FMLPacket.Type.MOD_IDMAP, cf2);
            for (int i = 0; i < registryPackets.length; ++i) {
                network.a((ex)PacketDispatcher.getPacket("FML", registryPackets[i]));
            }
        }
        jx.a((jx)((jx)netHandler), (boolean)true);
    }
}

