/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.ItemData;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.server.FMLServerHandler;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private IFMLSidedHandler sidedDelegate;
    private List<IScheduledTickHandler> scheduledClientTicks = Lists.newArrayList();
    private List<IScheduledTickHandler> scheduledServerTicks = Lists.newArrayList();
    private Class<?> forge;
    private boolean noForge;
    private List<String> brandings;
    private List<ICrashCallable> crashCallables = Lists.newArrayList((Object[])new ICrashCallable[]{Loader.instance().getCallableCrashInformation()});
    private Set<aln> handlerSet = Sets.newSetFromMap((Map)new MapMaker().weakKeys().makeMap());

    public void beginLoading(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
        FMLLog.log("MinecraftForge", Level.INFO, "Attempting early MinecraftForge initialization", new Object[0]);
        this.callForgeMethod("initialize");
        this.callForgeMethod("registerCrashCallable");
        FMLLog.log("MinecraftForge", Level.INFO, "Completed early MinecraftForge initialization", new Object[0]);
    }

    public void rescheduleTicks(Side side) {
        TickRegistry.updateTickQueue(side.isClient() ? this.scheduledClientTicks : this.scheduledServerTicks, side);
    }

    public void tickStart(EnumSet<TickType> ticks, Side side, Object ... data) {
        List<IScheduledTickHandler> scheduledTicks;
        List<IScheduledTickHandler> list = scheduledTicks = side.isClient() ? this.scheduledClientTicks : this.scheduledServerTicks;
        if (scheduledTicks.size() == 0) {
            return;
        }
        for (IScheduledTickHandler ticker : scheduledTicks) {
            EnumSet<TickType> ticksToRun = EnumSet.copyOf((EnumSet)Objects.firstNonNull(ticker.ticks(), EnumSet.noneOf(TickType.class)));
            ticksToRun.retainAll(ticks);
            if (ticksToRun.isEmpty()) continue;
            ticker.tickStart(ticksToRun, data);
        }
    }

    public void tickEnd(EnumSet<TickType> ticks, Side side, Object ... data) {
        List<IScheduledTickHandler> scheduledTicks;
        List<IScheduledTickHandler> list = scheduledTicks = side.isClient() ? this.scheduledClientTicks : this.scheduledServerTicks;
        if (scheduledTicks.size() == 0) {
            return;
        }
        for (IScheduledTickHandler ticker : scheduledTicks) {
            EnumSet<TickType> ticksToRun = EnumSet.copyOf((EnumSet)Objects.firstNonNull(ticker.ticks(), EnumSet.noneOf(TickType.class)));
            ticksToRun.retainAll(ticks);
            if (ticksToRun.isEmpty()) continue;
            ticker.tickEnd(ticksToRun, data);
        }
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object mod) {
        return (ModContainer)Loader.instance().getReversedModObjectList().get(mod);
    }

    public Logger getFMLLogger() {
        return FMLLog.getLogger();
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public Side getEffectiveSide() {
        Thread thr = Thread.currentThread();
        if (thr instanceof hh || thr instanceof ix) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLLog.log(Level.SEVERE, exception, "Something raised an exception. The message was '%s'. 'stopGame' is %b", message, stopGame);
        if (stopGame) {
            this.getSidedDelegate().haltGame(message, exception);
        }
    }

    private Class<?> findMinecraftForge() {
        if (this.forge == null && !this.noForge) {
            try {
                this.forge = Class.forName("net.minecraftforge.common.MinecraftForge");
            }
            catch (Exception ex2) {
                this.noForge = true;
            }
        }
        return this.forge;
    }

    private Object callForgeMethod(String method) {
        if (this.noForge) {
            return null;
        }
        try {
            return this.findMinecraftForge().getMethod(method, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void computeBranding() {
        if (this.brandings == null) {
            ImmutableList.Builder brd = ImmutableList.builder();
            brd.add((Object)Loader.instance().getMCVersionString());
            brd.add((Object)Loader.instance().getMCPVersionString());
            brd.add((Object)("FML v" + Loader.instance().getFMLVersionString()));
            String forgeBranding = (String)this.callForgeMethod("getBrandingVersion");
            if (!Strings.isNullOrEmpty((String)forgeBranding)) {
                brd.add((Object)forgeBranding);
            }
            if (this.sidedDelegate != null) {
                brd.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
            }
            if (Loader.instance().getFMLBrandingProperties().containsKey("fmlbranding")) {
                brd.add((Object)Loader.instance().getFMLBrandingProperties().get("fmlbranding"));
            }
            int tModCount = Loader.instance().getModList().size();
            int aModCount = Loader.instance().getActiveModList().size();
            brd.add((Object)String.format("%d mod%s loaded, %d mod%s active", tModCount, tModCount != 1 ? "s" : "", aModCount, aModCount != 1 ? "s" : ""));
            this.brandings = brd.build();
        }
    }

    public List<String> getBrandings() {
        if (this.brandings == null) {
            this.computeBranding();
        }
        return ImmutableList.copyOf(this.brandings);
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void onPostServerTick() {
        this.tickEnd(EnumSet.of(TickType.SERVER), Side.SERVER, new Object[0]);
    }

    public void onPostWorldTick(Object world) {
        this.tickEnd(EnumSet.of(TickType.WORLD), Side.SERVER, world);
    }

    public void onPreServerTick() {
        this.tickStart(EnumSet.of(TickType.SERVER), Side.SERVER, new Object[0]);
    }

    public void onPreWorldTick(Object world) {
        this.tickStart(EnumSet.of(TickType.WORLD), Side.SERVER, world);
    }

    public void onWorldLoadTick(abv[] worlds) {
        this.rescheduleTicks(Side.SERVER);
        for (abv w : worlds) {
            this.tickStart(EnumSet.of(TickType.WORLDLOAD), Side.SERVER, w);
        }
    }

    public boolean handleServerAboutToStart(MinecraftServer server) {
        return Loader.instance().serverAboutToStart(server);
    }

    public boolean handleServerStarting(MinecraftServer server) {
        return Loader.instance().serverStarting(server);
    }

    public void handleServerStarted() {
        Loader.instance().serverStarted();
    }

    public void handleServerStopping() {
        Loader.instance().serverStopping();
    }

    public MinecraftServer getMinecraftServerInstance() {
        return this.sidedDelegate.getServer();
    }

    public void showGuiScreen(Object clientGuiElement) {
        this.sidedDelegate.showGuiScreen(clientGuiElement);
    }

    public nm spawnEntityIntoClientWorld(EntityRegistry.EntityRegistration registration, EntitySpawnPacket entitySpawnPacket) {
        return this.sidedDelegate.spawnEntityIntoClientWorld(registration, entitySpawnPacket);
    }

    public void adjustEntityLocationOnClient(EntitySpawnAdjustmentPacket entitySpawnAdjustmentPacket) {
        this.sidedDelegate.adjustEntityLocationOnClient(entitySpawnAdjustmentPacket);
    }

    public void onServerStart(ir dedicatedServer) {
        FMLServerHandler.instance();
        this.sidedDelegate.beginServerLoading((MinecraftServer)dedicatedServer);
    }

    public void onServerStarted() {
        this.sidedDelegate.finishServerLoading();
    }

    public void onPreClientTick() {
        this.tickStart(EnumSet.of(TickType.CLIENT), Side.CLIENT, new Object[0]);
    }

    public void onPostClientTick() {
        this.tickEnd(EnumSet.of(TickType.CLIENT), Side.CLIENT, new Object[0]);
    }

    public void onRenderTickStart(float timer) {
        this.tickStart(EnumSet.of(TickType.RENDER), Side.CLIENT, Float.valueOf(timer));
    }

    public void onRenderTickEnd(float timer) {
        this.tickEnd(EnumSet.of(TickType.RENDER), Side.CLIENT, Float.valueOf(timer));
    }

    public void onPlayerPreTick(ue player) {
        Side side = player instanceof ju ? Side.SERVER : Side.CLIENT;
        this.tickStart(EnumSet.of(TickType.PLAYER), side, player);
    }

    public void onPlayerPostTick(ue player) {
        Side side = player instanceof ju ? Side.SERVER : Side.CLIENT;
        this.tickEnd(EnumSet.of(TickType.PLAYER), side, player);
    }

    public void registerCrashCallable(ICrashCallable callable) {
        this.crashCallables.add(callable);
    }

    public void enhanceCrashReport(b crashReport, m category) {
        for (ICrashCallable call : this.crashCallables) {
            category.a(call.getLabel(), (Callable)call);
        }
    }

    public void handleTinyPacket(ey handler, dq mapData) {
        this.sidedDelegate.handleTinyPacket(handler, mapData);
    }

    public void handleWorldDataSave(aln handler, alp worldInfo, bx tagCompound) {
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            bx dataForWriting = wac.getDataForWriting(handler, worldInfo);
            tagCompound.a(mc.getModId(), dataForWriting);
        }
    }

    public void handleWorldDataLoad(aln handler, alp worldInfo, bx tagCompound) {
        if (this.getEffectiveSide() != Side.SERVER) {
            return;
        }
        if (this.handlerSet.contains(handler)) {
            return;
        }
        this.handlerSet.add(handler);
        HashMap additionalProperties = Maps.newHashMap();
        worldInfo.setAdditionalProperties((Map)additionalProperties);
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            wac.readData(handler, worldInfo, additionalProperties, tagCompound.l(mc.getModId()));
        }
    }

    public boolean shouldServerBeKilledQuietly() {
        if (this.sidedDelegate == null) {
            return false;
        }
        return this.sidedDelegate.shouldServerShouldBeKilledQuietly();
    }

    public void disconnectIDMismatch(MapDifference<Integer, ItemData> serverDifference, ey toKill, cl network) {
        this.sidedDelegate.disconnectIDMismatch(serverDifference, toKill, network);
    }

    public void handleServerStopped() {
        MinecraftServer server = this.getMinecraftServerInstance();
        Loader.instance().serverStopped();
        if (server != null) {
            ObfuscationReflectionHelper.setPrivateValue(MinecraftServer.class, server, Boolean.valueOf(false), "serverStopped", "u", "serverStopped");
        }
    }

    public String getModName() {
        ArrayList modNames = Lists.newArrayListWithExpectedSize((int)3);
        modNames.add("fml");
        if (!this.noForge) {
            modNames.add("forge");
        }
        if (Loader.instance().getFMLBrandingProperties().containsKey("snooperbranding")) {
            modNames.add(Loader.instance().getFMLBrandingProperties().get("snooperbranding"));
        }
        return Joiner.on((char)',').join((Iterable)modNames);
    }

    public void addModToResourcePack(ModContainer container) {
        this.sidedDelegate.addModAsResource(container);
    }

    public void updateResourcePackList() {
        this.sidedDelegate.updateResourcePackList();
    }
}

